/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;

public class ContainerOperationResult<T> {
    private List<Operation<T>> operations = new ArrayList<Operation<T>>();

    public static Operation<Void> setupSuccess(Container container) {
        return new GenericOperation<Void>(Type.SETUP, container);
    }

    public static Operation<Void> setupFailure(Container container, Throwable exception) {
        return new GenericOperation<Void>(Type.SETUP, container, exception);
    }

    public static Operation<Void> startSuccess(Container container) {
        return new GenericOperation<Void>(Type.START, container);
    }

    public static Operation<Void> startFailure(Container container, Throwable exception) {
        return new GenericOperation<Void>(Type.START, container, exception);
    }

    public static Operation<Void> stopSuccess(Container container) {
        return new GenericOperation<Void>(Type.STOP, container);
    }

    public static Operation<Void> stopFailure(Container container, Throwable exception) {
        return new GenericOperation<Void>(Type.STOP, container, exception);
    }

    public static Operation<DeploymentDescription> deploySuccess(Container container, DeploymentDescription deployment) {
        return new GenericOperation<DeploymentDescription>(Type.DEPLOY, container, deployment);
    }

    public static Operation<DeploymentDescription> deployFailure(Container container, DeploymentDescription deployment, Throwable exception) {
        return new GenericOperation<DeploymentDescription>(Type.DEPLOY, container, exception, deployment);
    }

    public static Operation<DeploymentDescription> unDeploySuccess(Container container, DeploymentDescription deployment) {
        return new GenericOperation<DeploymentDescription>(Type.UNDEPLOY, container, deployment);
    }

    public static Operation<DeploymentDescription> unDeployFailure(Container container, DeploymentDescription deployment, Throwable exception) {
        return new GenericOperation<DeploymentDescription>(Type.UNDEPLOY, container, exception, deployment);
    }

    void add(Operation<T> operation) {
        this.operations.add(operation);
    }

    public List<Operation<T>> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public boolean hasFailure() {
        for (Operation<T> operation : this.operations) {
            if (!operation.hasFailed()) continue;
            return true;
        }
        return false;
    }

    public static class GenericOperation<X>
    implements Operation<X> {
        private Type type;
        private Container contianer;
        private Throwable exception;
        private X object;

        public GenericOperation(Type type, Container contianer) {
            this(type, contianer, null, null);
        }

        public GenericOperation(Type type, Container contianer, X object) {
            this(type, contianer, null, object);
        }

        public GenericOperation(Type type, Container contianer, Throwable exception) {
            this(type, contianer, exception, null);
        }

        public GenericOperation(Type type, Container contianer, Throwable exception, X object) {
            this.type = type;
            this.contianer = contianer;
            this.exception = exception;
            this.object = object;
        }

        @Override
        public Container getContainer() {
            return this.contianer;
        }

        @Override
        public boolean hasFailed() {
            return this.getFailure() != null;
        }

        @Override
        public Throwable getFailure() {
            return this.exception;
        }

        @Override
        public X getObject() {
            return this.object;
        }

        @Override
        public Type getType() {
            return this.type;
        }
    }

    public static interface Operation<T> {
        public Type getType();

        public Container getContainer();

        public boolean hasFailed();

        public Throwable getFailure();

        public T getObject();
    }

    public static enum Type {
        SETUP,
        START,
        STOP,
        DEPLOY,
        UNDEPLOY;

    }
}

