/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.form;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import ee.jakarta.tck.mvc.tests.form.AbstractFormMethodOverwriteTest;
import ee.jakarta.tck.mvc.tests.form.DisabledFormMethodOverwriteCustomApplication;
import ee.jakarta.tck.mvc.tests.form.FormMethodOverwriteController;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="2.1")
public class DisabledFormMethodOverwriteTest
extends AbstractFormMethodOverwriteTest {
    @ArquillianResource
    protected URL baseUrl;
    protected WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive(DisabledFormMethodOverwriteCustomApplication.class).addClass(FormMethodOverwriteController.class).addView("form/form-with-hidden-field.jsp").addView("form/result.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="form_method_overwrite_resolving_algorithm", id="form-overwriter-algorithm")})
    public void processPOSTIgnoringHiddenFieldWhenFormMethodOverwriteIsDisabled() throws IOException {
        HtmlPage page = this.getDefaultFormPage(this.webClient, this.baseUrl);
        HtmlForm form = this.setHiddenMethodInForm(page, "PUT");
        HtmlPage resultPage = this.submit(form);
        Assert.assertEquals((Object)"POST", (Object)resultPage.getElementById("invoked-method").getTextContent());
    }
}

