/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class StorageHolder
implements Serializable {
    private Map<String, Map<String, String>> globalStorage_ = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> localStorage_ = new HashMap<String, Map<String, String>>();
    private transient Map<String, Map<String, String>> sessionStorage_ = new HashMap<String, Map<String, String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getStore(Type storageType, Page page) {
        Map<String, Map<String, String>> storage = this.getStorage(storageType);
        if (storage == null) {
            return null;
        }
        Map<String, Map<String, String>> map = storage;
        synchronized (map) {
            String key = StorageHolder.getKey(storageType, page);
            return storage.computeIfAbsent(key, k -> new LinkedHashMap());
        }
    }

    private static String getKey(Type type, Page page) {
        switch (type) {
            case GLOBAL_STORAGE: {
                return page.getUrl().getHost();
            }
            case LOCAL_STORAGE: {
                URL url = page.getUrl();
                return url.getProtocol() + "://" + url.getHost() + ':' + url.getProtocol();
            }
            case SESSION_STORAGE: {
                WebWindow topWindow = page.getEnclosingWindow().getTopWindow();
                return Integer.toHexString(topWindow.hashCode());
            }
        }
        return null;
    }

    private Map<String, Map<String, String>> getStorage(Type type) {
        switch (type) {
            case GLOBAL_STORAGE: {
                return this.globalStorage_;
            }
            case LOCAL_STORAGE: {
                return this.localStorage_;
            }
            case SESSION_STORAGE: {
                return this.sessionStorage_;
            }
        }
        return null;
    }

    public static enum Type {
        GLOBAL_STORAGE,
        LOCAL_STORAGE,
        SESSION_STORAGE;

    }
}

