/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.mvc.redirect.scope;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import ee.jakarta.tck.mvc.tests.mvc.redirect.scope.RedirectScopeBean;
import ee.jakarta.tck.mvc.tests.mvc.redirect.scope.RedirectScopeController;
import ee.jakarta.tck.mvc.tests.mvc.redirect.scope.RequestScopeBean;
import ee.jakarta.tck.mvc.tests.mvc.redirect.scope.SessionScopeBean;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class RedirectScopeTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(RedirectScopeController.class).addClass(RequestScopeBean.class).addClass(SessionScopeBean.class).addClass(RedirectScopeBean.class).addView("<html><h1>Scopes</h1><p>Request = [${requestScopeBean.value}]</p>\n<p>Session = [${sessionScopeBean.value}]</p>\n<p>Redirect = [${redirectScopeBean.value}]</p></html>", "read.jsp").build();
    }

    @Test
    @SpecAssertion(section="redirect", id="scope-request")
    public void requestScope() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/scope/write-redirect-read").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Request = []"));
    }

    @Test
    @SpecAssertion(section="redirect", id="scope-session")
    public void sessionScope() throws IOException {
        WebClient webClient = new WebClient();
        WebResponse response1 = webClient.getPage(this.baseUrl.toString() + "mvc/scope/write-redirect-read").getWebResponse();
        Assert.assertThat((Object)response1.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response1.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Session = [bar]"));
        WebResponse response2 = webClient.getPage(this.baseUrl.toString() + "mvc/scope/read").getWebResponse();
        Assert.assertThat((Object)response2.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response2.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Session = [bar]"));
    }

    @Test
    @SpecAssertion(section="redirect", id="scope-redirect")
    public void redirectScope() throws IOException {
        WebClient webClient = new WebClient();
        WebResponse response1 = webClient.getPage(this.baseUrl.toString() + "mvc/scope/write-redirect-read").getWebResponse();
        Assert.assertThat((Object)response1.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response1.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Redirect = [foobar]"));
        WebResponse response2 = webClient.getPage(this.baseUrl.toString() + "mvc/scope/read").getWebResponse();
        Assert.assertThat((Object)response2.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response2.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Redirect = []"));
    }
}

