/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeUint8ClampedArray;

@JsxClass
public class ImageData
extends SimpleScriptable {
    private final RenderingBackend renderingContext_;
    private final int sx_;
    private final int sy_;
    private final int width_;
    private final int height_;
    private NativeUint8ClampedArray data_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public ImageData() {
        this(null, 0, 0, 0, 0);
    }

    ImageData(RenderingBackend context, int x, int y, int width, int height) {
        this.renderingContext_ = context;
        this.sx_ = x;
        this.sy_ = y;
        this.width_ = width;
        this.height_ = height;
    }

    @JsxGetter
    public int getWidth() {
        return this.width_;
    }

    @JsxGetter
    public int getHeight() {
        return this.height_;
    }

    @JsxGetter
    public NativeUint8ClampedArray getData() {
        if (this.data_ == null) {
            byte[] bytes = this.renderingContext_.getBytes(this.width_, this.height_, this.sx_, this.sy_);
            NativeArrayBuffer arrayBuffer = new NativeArrayBuffer((double)bytes.length);
            System.arraycopy(bytes, 0, arrayBuffer.getBuffer(), 0, bytes.length);
            this.data_ = new NativeUint8ClampedArray(arrayBuffer, 0, bytes.length);
            this.data_.setParentScope(this.getParentScope());
            this.data_.setPrototype(ScriptableObject.getClassPrototype((Scriptable)ImageData.getWindow((Scriptable)this), (String)this.data_.getClassName()));
        }
        return this.data_;
    }
}

