/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.mvc.controller.returntype;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import jakarta.mvc.tck.tests.mvc.controller.returntype.ReturnTypesController;
import jakarta.mvc.tck.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class ReturnTypeTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(ReturnTypesController.class).addView("Some rendered view", "view.jsp").build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="controllers", id="return-string"), @SpecAssertion(section="controllers", id="return-string2")})
    public void stringReturnType() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/return/string").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Some rendered view"));
    }

    @Test
    @SpecAssertion(section="controllers", id="return-void")
    public void voidWithViewAnnotation() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/return/void-with-view").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Some rendered view"));
    }

    @Test
    @SpecAssertion(section="controllers", id="return-void")
    public void voidWithoutViewAnnotation() throws IOException {
        WebClient client = new WebClient();
        client.getOptions().setThrowExceptionOnFailingStatusCode(false);
        Page page = client.getPage(this.baseUrl.toString() + "mvc/return/void-no-view");
        Assert.assertThat((String)"Expected status code != 204", (Object)page, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)500));
    }

    @Test
    @SpecAssertion(section="controllers", id="return-response")
    public void responseWithStringEntity() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/return/response-string").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Some rendered view"));
    }

    @Test
    @SpecAssertion(section="controllers", id="return-response")
    public void responseWithNullEntity() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/return/response-null").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Some rendered view"));
    }

    @Test
    @SpecAssertion(section="controllers", id="non-null-viewable")
    public void stringWithNullResult() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/return/string-null").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Some rendered view"));
    }
}

