/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.application.inheritance;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import jakarta.mvc.tck.tests.application.inheritance.InheritanceBaseClass;
import jakarta.mvc.tck.tests.application.inheritance.InheritanceBaseInterface;
import jakarta.mvc.tck.tests.application.inheritance.InheritanceController;
import jakarta.mvc.tck.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class InheritanceTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(InheritanceController.class).addClass(InheritanceBaseClass.class).addClass(InheritanceBaseInterface.class).addView("application/inheritance/controller.jsp").addView("application/inheritance/superclass.jsp").addView("application/inheritance/interface.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotation_inheritance", id="inheritance")})
    public void annotationsOnlyOnControllerMethod() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/inheritance/annotations-only-on-controller-method");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Annotations on controller win!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotation_inheritance", id="inheritance")})
    public void annotationsOnlyOnSuperMethod() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/inheritance/annotations-only-on-super-method");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Annotations on superclass win!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotation_inheritance", id="inheritance")})
    public void annotationsOnControllerAndSuperMethod() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/inheritance/annotations-on-controller-and-super-method");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Annotations on controller win!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotation_inheritance", id="inheritance")})
    public void annotationsOnlyOnInterfaceMethod() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/inheritance/annotations-only-on-interface-method");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Annotations on interface win!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotation_inheritance", id="inheritance")})
    public void annotationsOnControllerAndInterfaceMethod() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/inheritance/annotations-on-controller-and-interface-method");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Annotations on controller win!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotation_inheritance", id="inheritance"), @SpecAssertion(section="annotation_inheritance", id="class-vs-iface")})
    public void annotationsOnSuperClassAndInterfaceMethod() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/inheritance/annotations-on-superclass-and-interface-method");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Annotations on superclass win!"));
    }
}

