/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.diffmerge.internal.context;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.diffmerge.internal.context.Activator;
import org.eclipse.emf.ecp.diffmerge.internal.context.CompareControls;
import org.eclipse.emf.ecp.diffmerge.spi.context.ControlPair;
import org.eclipse.emf.ecp.diffmerge.spi.context.DiffMergeModelContext;
import org.eclipse.emf.ecp.spi.diffmerge.model.VDiffAttachment;
import org.eclipse.emf.ecp.spi.diffmerge.model.VDiffmergeFactory;
import org.eclipse.emf.ecp.view.internal.context.ViewModelContextImpl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;

public class DiffMergeModelContextImpl
extends ViewModelContextImpl
implements DiffMergeModelContext {
    private final EObject left;
    private final EObject right;
    private Map<VControl, ControlPair> controlDiffMap;
    private List<VControl> diffControls;
    private final Set<VControl> mergedControls = new LinkedHashSet<VControl>();

    public DiffMergeModelContextImpl(VElement view, EObject domainObject, EObject left, EObject right) {
        super(view, domainObject);
        this.left = left;
        this.right = right;
        this.initComparison();
    }

    public DiffMergeModelContextImpl(VElement view, EObject domainObject, EObject left, EObject right, Set<VDomainModelReference> mergedReferences) {
        this(view, domainObject, left, right);
        this.readAlreadyMerged(mergedReferences);
    }

    public DiffMergeModelContextImpl(VElement view, EObject domainObject, EObject origin1, EObject origin2, ViewModelService ... modelServices) {
        super(view, domainObject, modelServices);
        this.left = origin1;
        this.right = origin2;
        this.initComparison();
    }

    public DiffMergeModelContextImpl(VElement view, EObject domainObject, EObject origin1, EObject origin2, Set<VDomainModelReference> mergedReferences, ViewModelService ... modelServices) {
        this(view, domainObject, origin1, origin2, modelServices);
        this.readAlreadyMerged(mergedReferences);
    }

    private void readAlreadyMerged(Set<VDomainModelReference> mergedReferences) {
        for (VDomainModelReference domainModelReference : mergedReferences) {
            IObservableValue observableValue;
            try {
                observableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(domainModelReference, this.getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                continue;
            }
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            InternalEObject internalEObject = (InternalEObject)((IObserving)observableValue).getObserved();
            EStructuralFeature.Setting setting = internalEObject.eSetting(structuralFeature);
            observableValue.dispose();
            Set<VControl> controls = this.getControlsFor(setting);
            controls = this.getValidMergeControls(controls);
            if (controls == null) continue;
            for (VControl vControl : controls) {
                this.markControl(vControl, true);
            }
        }
    }

    protected Set<VControl> getValidMergeControls(Set<VControl> controls) {
        return controls;
    }

    private void initComparison() {
        VElement viewModelLeft = (VElement)EcoreUtil.copy((EObject)this.getViewModel());
        VElement viewModelRight = (VElement)EcoreUtil.copy((EObject)this.getViewModel());
        TreeIterator mainViewModel = this.getViewModel().eAllContents();
        TreeIterator leftViewModel = viewModelLeft.eAllContents();
        TreeIterator rightViewModel = viewModelRight.eAllContents();
        this.controlDiffMap = new LinkedHashMap<VControl, ControlPair>();
        this.diffControls = new ArrayList<VControl>();
        while (mainViewModel.hasNext()) {
            EObject mainEObject = (EObject)mainViewModel.next();
            EObject leftEObject = (EObject)leftViewModel.next();
            EObject rightEObject = (EObject)rightViewModel.next();
            if (!VControl.class.isInstance(mainEObject) || !this.hasDiff((VControl)leftEObject, this.getLeftModel(), (VControl)rightEObject, this.getRightModel(), (VControl)mainEObject)) continue;
            VControl control = (VControl)mainEObject;
            this.controlDiffMap.put(control, new ControlPair((VControl)leftEObject, (VControl)rightEObject));
            this.diffControls.add(control);
        }
        for (VControl control : this.diffControls) {
            VDiffAttachment diffAttachment = this.getDiffAttachment((VElement)control);
            diffAttachment.setTotalNumberOfDiffs(1);
            diffAttachment.setMergedDiffs(this.mergedControls.contains(control) ? 1 : 0);
            this.propagateDiffAttachment(control, diffAttachment);
        }
    }

    private void propagateDiffAttachment(VControl control, VDiffAttachment childDiff) {
        EObject parent = control.eContainer();
        while (parent != null) {
            EObject newParent = parent.eContainer();
            if (!VElement.class.isInstance(parent)) {
                parent = newParent;
                continue;
            }
            VElement vElement = (VElement)parent;
            VDiffAttachment attachment = this.getDiffAttachment(vElement);
            attachment.setMergedDiffs(0);
            attachment.setTotalNumberOfDiffs(0);
            for (EObject eObject : vElement.eContents()) {
                if (!VElement.class.isInstance(eObject)) continue;
                VElement childElement = (VElement)eObject;
                VDiffAttachment childAttachment = this.getDiffAttachment(childElement);
                attachment.setMergedDiffs(attachment.getMergedDiffs() + childAttachment.getMergedDiffs());
                attachment.setTotalNumberOfDiffs(attachment.getTotalNumberOfDiffs() + childAttachment.getTotalNumberOfDiffs());
            }
            parent = newParent;
            childDiff = attachment;
        }
    }

    private VDiffAttachment getDiffAttachment(VElement vElement) {
        VDiffAttachment attachment = null;
        boolean hasAttachment = false;
        for (VAttachment vAttachment : vElement.getAttachments()) {
            if (!VDiffAttachment.class.isInstance(vAttachment)) continue;
            attachment = (VDiffAttachment)vAttachment;
            hasAttachment = true;
            break;
        }
        if (!hasAttachment) {
            VDiffAttachment vDiffAttachment = VDiffmergeFactory.eINSTANCE.createDiffAttachment();
            vElement.getAttachments().add((Object)vDiffAttachment);
            attachment = vDiffAttachment;
        }
        return attachment;
    }

    protected boolean hasDiff(VControl leftControl, EObject leftDomainModel, VControl rightControl, EObject rightDomainModel, VControl targetControl) {
        return !CompareControls.areEqual(leftControl, leftDomainModel, rightControl, rightDomainModel);
    }

    @Override
    public EObject getLeftModel() {
        return this.left;
    }

    @Override
    public EObject getRightModel() {
        return this.right;
    }

    @Override
    public boolean hasDiff(VControl control) {
        return this.controlDiffMap.containsKey(control);
    }

    @Override
    public ControlPair getPairWithDiff(VControl control) {
        return this.controlDiffMap.get(control);
    }

    @Override
    public int getTotalNumberOfDiffs() {
        return this.diffControls.size();
    }

    @Override
    public int getIndexOf(VControl control) {
        return this.diffControls.indexOf(control);
    }

    @Override
    public VControl getControl(int diffIndex) throws IllegalArgumentException {
        if (diffIndex < 0) {
            throw new IllegalArgumentException("The index must be 0 or greater.");
        }
        if (diffIndex >= this.getTotalNumberOfDiffs()) {
            throw new IllegalArgumentException(String.format("The index %1$d is to high. There are only %2$d differences.", diffIndex, this.getTotalNumberOfDiffs()));
        }
        return this.diffControls.get(diffIndex);
    }

    @Override
    public boolean isControlMerged(VControl vControl) {
        if (!this.diffControls.contains(vControl)) {
            return true;
        }
        return this.mergedControls.contains(vControl);
    }

    @Override
    public void markControl(VControl vControl, boolean merged) {
        if (vControl.isReadonly()) {
            return;
        }
        if (merged) {
            this.mergedControls.add(vControl);
        } else {
            this.mergedControls.remove(vControl);
        }
        VDiffAttachment diffAttachment = this.getDiffAttachment((VElement)vControl);
        diffAttachment.setMergedDiffs(merged && diffAttachment.getTotalNumberOfDiffs() != 0 ? 1 : 0);
        this.propagateDiffAttachment(vControl, diffAttachment);
    }

    @Override
    public Set<VDomainModelReference> getMergedDomainObjects() {
        LinkedHashSet<VDomainModelReference> result = new LinkedHashSet<VDomainModelReference>();
        for (VControl control : this.mergedControls) {
            result.add((VDomainModelReference)EcoreUtil.copy((EObject)control.getDomainModelReference()));
        }
        return result;
    }
}

