/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedComparisonSideViewer
extends HeaderViewer<ComparisonSideViewer> {
    protected final boolean _isLeftSide;

    public EnhancedComparisonSideViewer(Composite parent_p, boolean isLeftSide_p) {
        this._isLeftSide = isLeftSide_p;
        this.createControls(parent_p);
    }

    @Override
    protected ComparisonSideViewer createInnerViewer(Composite parent_p) {
        return new ComparisonSideViewer(parent_p, this._isLeftSide);
    }

    protected LabelProvider getHeaderLabelProvider() {
        return DiffMergeLabelProvider.getInstance();
    }

    public EMFDiffNode getInput() {
        return (EMFDiffNode)((Object)super.getInput());
    }

    public ITreeSelection getSelection() {
        return ((ComparisonSideViewer)this.getInnerViewer()).getSelection();
    }

    @Override
    protected void inputChanged(Object input_p, Object oldInput_p) {
        Label imageLabel;
        super.inputChanged(input_p, oldInput_p);
        EMFDiffNode input = this.getInput();
        IModelScope scope = ((ComparisonSideViewer)this.getInnerViewer()).getSideScope();
        Label textLabel = this.getTextLabel();
        if (textLabel != null) {
            textLabel.setForeground(((ComparisonSideViewer)this.getInnerViewer()).getSideColor());
            this.updateHeaderText(textLabel, input, scope);
        }
        if ((imageLabel = this.getImageLabel()) != null) {
            this.updateHeaderImage(imageLabel, input, scope);
        }
    }

    protected void updateHeaderImage(Label headerImageWidget_p, EMFDiffNode input_p, IModelScope scope_p) {
        headerImageWidget_p.setImage(this.getHeaderLabelProvider().getImage((Object)scope_p));
    }

    protected void updateHeaderText(Label headerTextWidget_p, EMFDiffNode input_p, IModelScope scope_p) {
        String label = this.getHeaderLabelProvider().getText((Object)scope_p);
        headerTextWidget_p.setText(label);
        headerTextWidget_p.setToolTipText(label);
    }
}

