/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.util.DiffDecoratingLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceRelatedViewer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ValuesViewer
extends TableViewer
implements IComparisonSideViewer,
IDifferenceRelatedViewer {
    private final boolean _sideIsLeft;
    private boolean _showAllValues;
    protected final IPropertyChangeListener _inputPropertyChangeListener;

    public ValuesViewer(Composite parent_p, boolean sideIsLeft_p) {
        this(parent_p, 770, sideIsLeft_p);
    }

    public ValuesViewer(Composite parent_p, int style_p, boolean sideIsLeft_p) {
        super(parent_p, style_p);
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._sideIsLeft = sideIsLeft_p;
        this._showAllValues = false;
        this._inputPropertyChangeListener = this.createInputPropertyChangeListener();
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected IPropertyChangeListener createInputPropertyChangeListener() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if (DefaultUserProperties.P_TECHNICAL_LABELS.matches(event_p)) {
                    ValuesViewer.this.refresh(true);
                }
            }
        };
    }

    public ValuesInput getInput() {
        return (ValuesInput)super.getInput();
    }

    protected Role getSideRole() {
        return this.getInput() == null ? null : this.getInput().getContext().getRoleForSide(this.isLeftSide());
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)super.getSelection();
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        if (oldInput_p instanceof ValuesInput) {
            ((ValuesInput)oldInput_p).getContext().removeUserPropertyChangeListener(DefaultUserProperties.P_TECHNICAL_LABELS, this._inputPropertyChangeListener);
        }
        if (input_p instanceof ValuesInput) {
            ((ValuesInput)input_p).getContext().addUserPropertyChangeListener(DefaultUserProperties.P_TECHNICAL_LABELS, this._inputPropertyChangeListener);
        }
        super.inputChanged(input_p, oldInput_p);
    }

    @Override
    public boolean isDifferenceAgnostic() {
        return this._showAllValues;
    }

    @Override
    public boolean isLeftSide() {
        return this._sideIsLeft;
    }

    protected boolean isOwnership(Object object_p) {
        boolean result = false;
        Object object = object_p;
        if (object instanceof ValuesInput) {
            object = ((ValuesInput)object).getMatchAndFeature();
        }
        if (object instanceof MatchAndFeature) {
            EStructuralFeature feature = ((MatchAndFeature)object).getFeature();
            result = EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature().equals(feature);
        }
        return result;
    }

    @Override
    public void setDifferenceAgnostic(boolean agnostic_p) {
        if (agnostic_p != this.isDifferenceAgnostic()) {
            this._showAllValues = agnostic_p;
            this.refresh(false);
        }
    }

    protected class ContentProvider
    implements IStructuredContentProvider {
        protected ContentProvider() {
        }

        public Object[] getElements(Object inputElement_p) {
            ArrayList<Object> result;
            block8: {
                MatchAndFeature maf;
                block10: {
                    EComparison comparison;
                    ValuesInput valuesInput;
                    block9: {
                        result = new ArrayList<Object>();
                        valuesInput = (ValuesInput)inputElement_p;
                        if (valuesInput == null) break block8;
                        maf = valuesInput.getMatchAndFeature();
                        if (!ValuesViewer.this.isOwnership(maf)) break block9;
                        IReferenceValuePresence ownership = maf.getMatch().getOwnershipDifference(ValuesViewer.this.getSideRole());
                        if (ownership == null) break block8;
                        result.add(ownership);
                        break block8;
                    }
                    IValuePresence orderDifference = maf.getMatch().getOrderDifference(maf.getFeature(), ValuesViewer.this.getSideRole());
                    if (orderDifference != null) {
                        result.add(orderDifference);
                    }
                    if (valuesInput.isContainment()) break block8;
                    if (!ValuesViewer.this.isDifferenceAgnostic()) break block10;
                    EMatch match = maf.getMatch();
                    EObject source = match.get(ValuesViewer.this.getSideRole());
                    if (source == null) break block8;
                    EComparison eComparison = comparison = ValuesViewer.this.getInput() == null ? null : ValuesViewer.this.getInput().getContext().getActualComparison();
                    if (comparison == null) break block8;
                    if (maf.getFeature() instanceof EAttribute) {
                        EAttribute attribute = (EAttribute)maf.getFeature();
                        List values = comparison.getScope(ValuesViewer.this.getSideRole()).get(source, attribute);
                        for (Object value : values) {
                            IAttributeValuePresence presence = match.getAttributeValueDifference(attribute, value);
                            if (presence != null) {
                                result.add(presence);
                                continue;
                            }
                            result.add(value);
                        }
                    } else {
                        EReference reference = (EReference)maf.getFeature();
                        List values = comparison.getScope(ValuesViewer.this.getSideRole()).get(source, reference);
                        for (EObject value : values) {
                            IReferenceValuePresence presence = match.getReferenceValueDifference(reference, value);
                            if (presence != null) {
                                result.add(presence);
                                continue;
                            }
                            result.add(value);
                        }
                    }
                    break block8;
                }
                Collection bothSides = maf.getFeature() instanceof EAttribute ? maf.getMatch().getAttributeDifferences((EAttribute)maf.getFeature()) : maf.getMatch().getReferenceDifferences((EReference)maf.getFeature());
                for (IValuePresence presence : bothSides) {
                    if ((presence.isOrder() || presence.getPresenceRole() != ValuesViewer.this.getSideRole() || presence.getMergeDestination() == ValuesViewer.this.getSideRole()) && (presence.isOrder() || presence.getPresenceRole() != ValuesViewer.this.getSideRole().opposite() || presence.getMergeDestination() != ValuesViewer.this.getSideRole())) continue;
                    result.add(presence);
                }
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }
    }

    protected class LabelProvider
    extends DiffDecoratingLabelProvider {
        protected LabelProvider() {
        }

        @Override
        protected EMFDiffNode getDiffNode() {
            ValuesInput input = ValuesViewer.this.getInput();
            return input == null ? null : input.getContext();
        }

        @Override
        protected Role getSide() {
            return ValuesViewer.this.getSideRole();
        }

        @Override
        public String getToolTipText(Object element_p) {
            return this.getText(element_p);
        }

        @Override
        public String getUndecoratedText(Object element_p) {
            String result = super.getUndecoratedText(element_p);
            String[] lines = result.split("\r\n|\r|\n", 2);
            if (lines.length > 1) {
                result = String.valueOf(lines[0]) + " [...]";
            }
            return result;
        }

        @Override
        protected boolean isFromValue(IValuePresence valuePresence_p) {
            return ValuesViewer.this.isOwnership(ValuesViewer.this.getInput());
        }

        @Override
        protected boolean isTextTechnicalForMeta() {
            return ValuesViewer.this.getInput() == null ? false : ValuesViewer.this.getInput().getContext().isUserPropertyTrue(DefaultUserProperties.P_TECHNICAL_LABELS);
        }
    }

    public static class ValuesInput {
        private final EMFDiffNode _context;
        private final MatchAndFeature _matchAndFeature;

        public ValuesInput(EMFDiffNode context_p, MatchAndFeature matchAndFeature_p) {
            this._context = context_p;
            this._matchAndFeature = matchAndFeature_p;
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof ValuesInput) {
                ValuesInput peer = (ValuesInput)object_p;
                result = this._context == peer.getContext() && this._matchAndFeature.getFeature() == peer.getMatchAndFeature().getFeature() && this._matchAndFeature.getMatch().equals((Object)peer.getMatchAndFeature().getMatch());
            }
            return result;
        }

        public EMFDiffNode getContext() {
            return this._context;
        }

        public MatchAndFeature getMatchAndFeature() {
            return this._matchAndFeature;
        }

        public int hashCode() {
            return this._context.hashCode() + this._matchAndFeature.getMatch().hashCode() + this._matchAndFeature.getFeature().hashCode();
        }

        public boolean isContainment() {
            return this._context.isContainment(this._matchAndFeature.getFeature());
        }
    }
}

