/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.diffmerge.api.config.IComparisonConfiguration;
import org.eclipse.emf.diffmerge.api.config.IComparisonConfigurator;
import org.eclipse.emf.diffmerge.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableDiffPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMergePolicy;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.specification.ext.ComparisonConfiguration;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ConfigureComparisonDialog
extends Dialog {
    protected final ComparisonConfiguration _data;
    protected final Map<Control, Object> _advancedSettingsAreas;
    protected TabFolder _advancedSettingsContainer;

    public ConfigureComparisonDialog(Shell shell_p, ComparisonConfiguration data_p) {
        super(shell_p);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._advancedSettingsAreas = new LinkedHashMap<Control, Object>();
        this._data = data_p;
    }

    protected void applyShowAdvancedSettings() {
        if (this._advancedSettingsContainer != null) {
            boolean toShow = this._data.isShowAdvancedSettings();
            for (Map.Entry entry : new LinkedList<Map.Entry<Control, Object>>(this._advancedSettingsAreas.entrySet())) {
                Control control = (Control)entry.getKey();
                Object data = entry.getValue();
                if (toShow && data instanceof String) {
                    TabItem newItem = new TabItem(this._advancedSettingsContainer, 0);
                    newItem.setText((String)data);
                    newItem.setControl(control);
                    this._advancedSettingsAreas.put(control, newItem);
                    continue;
                }
                if (toShow || !(data instanceof TabItem)) continue;
                String title = ((TabItem)data).getText();
                this._advancedSettingsAreas.put(control, title);
                ((TabItem)data).dispose();
            }
        }
    }

    protected void configureShell(Shell newShell_p) {
        super.configureShell(newShell_p);
        newShell_p.setText(Messages.ConfigureComparisonDialog_Title);
    }

    public void create() {
        super.create();
        this.applyShowAdvancedSettings();
    }

    protected Composite createAreaConfiguration(Composite parent_p) {
        TabFolder result = new TabFolder(parent_p, 0);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAreaMain((Composite)result);
        this.createAreaMatching((Composite)result);
        this.createAreaDifferencing((Composite)result);
        this.createAreaMerging((Composite)result);
        this.createAreaMisc((Composite)result);
        this._advancedSettingsContainer = result;
        return result;
    }

    protected Composite createAreaDifferencing(Composite parent_p) {
        if (this._data.getDiffPolicy() == null) {
            return null;
        }
        Composite result = this.createAreaTopic(parent_p, Messages.ConfigureComparisonDialog_Differencing, true);
        this.createOptionIgnoreOrders(result);
        return result;
    }

    protected Composite createAreaMain(Composite parent_p) {
        Composite result = this.createAreaTopic(parent_p, Messages.ConfigureComparisonDialog_Topic_Main, false);
        this.createAreaUsages(result);
        this.createAreaShowAdvancedSettings(result);
        return result;
    }

    protected Composite createAreaMatching(Composite parent_p) {
        Composite result = null;
        ConfigurableMatchPolicy matchPolicy = this._data.getMatchPolicy();
        if (matchPolicy != null) {
            result = this.createAreaTopic(parent_p, Messages.ConfigureComparisonDialog_Matching, true);
            if (matchPolicy.getVisibleCriteria().size() > 1) {
                this.createLabelWithNote(result, Messages.ConfigureComparisonDialog_MatchingTooltip);
            }
            this.createAreaMatchingAbsolute(result);
            this.createAreaMatchingRelative(result);
        }
        return result;
    }

    protected Composite createAreaMatchingAbsolute(Composite parent_p) {
        assert (this._data.getMatchPolicy() != null);
        Group result = null;
        Collection visibleCriteria = this._data.getMatchPolicy().getVisibleCriteria();
        if (visibleCriteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID) || visibleCriteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID)) {
            Group group = new Group(parent_p, 0);
            group.setLayoutData(this.createLayoutData());
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(Messages.ConfigureComparisonDialog_AbsoluteCriteria);
            group.setToolTipText(Messages.ConfigureComparisonDialog_AbsoluteCriteriaTooltip);
            this.createAreaMatchingCriterion((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID, Messages.ConfigureComparisonDialog_EIDCriterion, Messages.ConfigureComparisonDialog_EIDCriterionTooltip);
            this.createAreaMatchingCriterion((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID, Messages.ConfigureComparisonDialog_IIDCriterion, Messages.ConfigureComparisonDialog_IIDCriterionTooltip);
            result = group;
        }
        return result;
    }

    protected Composite createAreaMatchingCriterion(Composite parent_p, ConfigurableMatchPolicy.MatchCriterionKind criterion_p, String label_p, String tooltip_p) {
        ConfigurableMatchPolicy matchPolicy = this._data.getMatchPolicy();
        assert (matchPolicy != null);
        if (!matchPolicy.getVisibleCriteria().contains(criterion_p)) {
            return null;
        }
        this.createOptionMatchingCriterion(parent_p, criterion_p, label_p, tooltip_p);
        Composite result = new Composite(parent_p, 0);
        result.setLayoutData(this.createLayoutData());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        for (ConfigurableMatchPolicy.FineGrainedMatchCriterion fgCriterion : matchPolicy.getAvailableFineGrainedCriteria()) {
            if (fgCriterion.getParentCriterion() != criterion_p) continue;
            this.createOptionMatchingFineGrainedCriterion(result, fgCriterion);
        }
        return result;
    }

    protected Composite createAreaMatchingRelative(Composite parent_p) {
        assert (this._data.getMatchPolicy() != null);
        Group result = null;
        Collection visibleCriteria = this._data.getMatchPolicy().getVisibleCriteria();
        if (visibleCriteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.NAME) || visibleCriteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.STRUCTURE) || visibleCriteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS)) {
            Group group = new Group(parent_p, 0);
            group.setLayoutData(this.createLayoutData());
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(Messages.ConfigureComparisonDialog_RelativeCriteria);
            group.setToolTipText(Messages.ConfigureComparisonDialog_RelativeCriteriaTooltip);
            this.createAreaMatchingCriterion((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.NAME, Messages.ConfigureComparisonDialog_NameCriterion, Messages.ConfigureComparisonDialog_NameCriterionTooltip);
            this.createAreaMatchingCriterion((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.STRUCTURE, Messages.ConfigureComparisonDialog_StructureCriterion, Messages.ConfigureComparisonDialog_StructureCriterionTooltip);
            this.createAreaMatchingCriterion((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS, Messages.ConfigureComparisonDialog_SemanticCriteria, Messages.ConfigureComparisonDialog_SemanticCriteriaTooltip);
            result = group;
        }
        return result;
    }

    protected Composite createAreaMerging(Composite parent_p) {
        return null;
    }

    protected Composite createAreaMisc(Composite parent_p) {
        Composite result = this.createAreaTopic(parent_p, Messages.ConfigureComparisonDialog_Topic_Misc, true);
        this.createOptionKeepMatchIDs(result);
        this.createOptionUseCache(result);
        return result;
    }

    protected Composite createAreaUsages(Composite parent_p) {
        Group result = new Group(parent_p, 0);
        result.setLayoutData(this.createLayoutData());
        result.setText(Messages.ConfigureComparisonDialog_PredefinedUsages);
        result.setLayout((Layout)new GridLayout(1, false));
        for (IComparisonConfigurator configurator : this._data.getConfigurators()) {
            this.createOptionUsage((Composite)result, configurator);
        }
        return result;
    }

    protected Control createAreaShowAdvancedSettings(Composite parent_p) {
        final Button switchButton = new Button(parent_p, 8);
        final String labelOn = Messages.ConfigureComparisonDialog_ShowAdvanced;
        final String labelOff = Messages.ConfigureComparisonDialog_HideAdvanced;
        switchButton.setText(this._data.isShowAdvancedSettings() ? labelOff : labelOn);
        switchButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean toShow = !ConfigureComparisonDialog.this._data.isShowAdvancedSettings();
                ConfigureComparisonDialog.this._data.setShowAdvancedSettings(toShow);
                switchButton.setText(toShow ? labelOff : labelOn);
                ConfigureComparisonDialog.this.applyShowAdvancedSettings();
            }
        });
        return switchButton;
    }

    protected Composite createAreaTopic(Composite parent_p, String title_p, boolean advanced_p) {
        Composite result;
        if (parent_p instanceof TabFolder) {
            result = new Composite(parent_p, 0);
            TabItem tab = new TabItem((TabFolder)parent_p, 0);
            tab.setText(title_p);
            tab.setControl((Control)result);
            if (advanced_p) {
                this._advancedSettingsAreas.put((Control)result, tab);
            }
        } else {
            Group group = new Group(parent_p, 0);
            group.setText(title_p);
            result = group;
            if (advanced_p) {
                this._advancedSettingsAreas.put((Control)result, null);
            }
        }
        result.setLayout((Layout)new GridLayout(1, false));
        result.setLayoutData(this.createLayoutData());
        return result;
    }

    protected Control createDialogArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        result.setLayout((Layout)new GridLayout(1, false));
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(result, 0);
        label.setText(Messages.ConfigureComparisonDialog_Label);
        label.setLayoutData(this.createLayoutData());
        this.createAreaConfiguration(result);
        return result;
    }

    protected Control createLabelWithNote(Composite parent_p, String text_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createNoteLabel(composite);
        Label label = new Label(composite, 0);
        label.setText(text_p);
        return composite;
    }

    protected Object createLayoutData() {
        return new GridData(4, 128, true, false);
    }

    protected Label createNoteLabel(Composite parent_p) {
        Label result = new Label(parent_p, 0);
        result.setText(Messages.ConfigureComparisonDialog_Note);
        result.setFont(UIUtil.getBold(result.getFont()));
        return result;
    }

    protected void createOptionIgnoreOrders(Composite parent_p) {
        final ConfigurableDiffPolicy policy = this._data.getDiffPolicy();
        assert (policy != null);
        final Button checkBox = new Button(parent_p, 32);
        checkBox.setLayoutData(this.createLayoutData());
        checkBox.setText(Messages.ConfigureComparisonDialog_IgnoreOrders);
        checkBox.setSelection(this._data.getDiffPolicy().isIgnoreOrders());
        checkBox.setToolTipText(Messages.ConfigureComparisonDialog_IgnoreOrdersTooltip);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                policy.setIgnoreOrders(!policy.isIgnoreOrders());
            }
        });
        final IConfigurablePolicy.IConfigurationChangedListener updateListener = new IConfigurablePolicy.IConfigurationChangedListener(){

            public void configurationChanged(IConfigurablePolicy notifier_p, Object property_p) {
                checkBox.setSelection(policy.isIgnoreOrders());
            }
        };
        policy.addConfigurationChangedListener(updateListener);
        parent_p.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e_p) {
                policy.removeConfigurationChangedListener(updateListener);
            }
        });
    }

    protected void createOptionKeepMatchIDs(Composite parent_p) {
        final Button checkBox = new Button(parent_p, 32);
        checkBox.setLayoutData(this.createLayoutData());
        checkBox.setText(Messages.ConfigureComparisonDialog_KeepMatchData);
        checkBox.setSelection(this._data.isKeepMatchIDs());
        checkBox.setToolTipText(Messages.ConfigureComparisonDialog_KeepMatchDataTooltip);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ConfigureComparisonDialog.this._data.setKeepMatchIDs(!ConfigureComparisonDialog.this._data.isKeepMatchIDs());
            }
        });
        final ConfigurableMatchPolicy policy = this._data.getMatchPolicy();
        if (policy != null) {
            final IConfigurablePolicy.IConfigurationChangedListener updateListener = new IConfigurablePolicy.IConfigurationChangedListener(){

                public void configurationChanged(IConfigurablePolicy notifier_p, Object property_p) {
                    checkBox.setSelection(ConfigureComparisonDialog.this._data.isKeepMatchIDs());
                }
            };
            policy.addConfigurationChangedListener(updateListener);
            parent_p.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e_p) {
                    policy.removeConfigurationChangedListener(updateListener);
                }
            });
        }
    }

    protected Button createOptionMatchingCriterion(Composite parent_p, final ConfigurableMatchPolicy.MatchCriterionKind criterion_p, String label_p, String tooltip_p) {
        final ConfigurableMatchPolicy matchPolicy = this._data.getMatchPolicy();
        assert (matchPolicy != null);
        final Button result = new Button(parent_p, 32);
        result.setLayoutData(this.createLayoutData());
        result.setText(label_p);
        result.setSelection(matchPolicy.useCriterion(criterion_p));
        result.setToolTipText(tooltip_p);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                matchPolicy.setUseCriterion(criterion_p, result.getSelection());
            }
        });
        final IConfigurablePolicy.IConfigurationChangedListener updateListener = new IConfigurablePolicy.IConfigurationChangedListener(){

            public void configurationChanged(IConfigurablePolicy notifier_p, Object property_p) {
                if (ConfigurableMatchPolicy.PROPERTY_MATCH_CRITERIA == property_p || criterion_p == property_p) {
                    boolean criterionSelected = matchPolicy.useCriterion(criterion_p);
                    result.setSelection(criterionSelected);
                }
            }
        };
        matchPolicy.addConfigurationChangedListener(updateListener);
        parent_p.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e_p) {
                matchPolicy.removeConfigurationChangedListener(updateListener);
            }
        });
        return result;
    }

    protected Button createOptionMatchingFineGrainedCriterion(Composite parent_p, final ConfigurableMatchPolicy.FineGrainedMatchCriterion criterion_p) {
        final ConfigurableMatchPolicy matchPolicy = this._data.getMatchPolicy();
        assert (matchPolicy != null);
        String INDENT = "  ";
        new Label(parent_p, 0).setText("  ");
        final Button result = new Button(parent_p, 32);
        result.setLayoutData(this.createLayoutData());
        result.setText(criterion_p.getLabel());
        result.setEnabled(matchPolicy.useCriterion(criterion_p.getParentCriterion()));
        result.setSelection(matchPolicy.useFineGrainedCriterion(criterion_p));
        result.setToolTipText(criterion_p.getDescription());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                matchPolicy.setUseFineGrainedCriterion(criterion_p, result.getSelection());
            }
        });
        final IConfigurablePolicy.IConfigurationChangedListener updateListener = new IConfigurablePolicy.IConfigurationChangedListener(){

            public void configurationChanged(IConfigurablePolicy notifier_p, Object property_p) {
                if (ConfigurableMatchPolicy.PROPERTY_MATCH_CRITERIA == property_p || criterion_p.getParentCriterion() == property_p) {
                    boolean criterionSelected = matchPolicy.useCriterion(criterion_p.getParentCriterion());
                    result.setEnabled(criterionSelected);
                } else if (ConfigurableMatchPolicy.PROPERTY_FINE_GRAINED_MATCH_CRITERIA == property_p || criterion_p == property_p) {
                    boolean criterionSelected = matchPolicy.useFineGrainedCriterion(criterion_p);
                    result.setSelection(criterionSelected);
                }
            }
        };
        matchPolicy.addConfigurationChangedListener(updateListener);
        parent_p.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e_p) {
                matchPolicy.removeConfigurationChangedListener(updateListener);
            }
        });
        return result;
    }

    protected void createOptionUsage(Composite parent_p, final IComparisonConfigurator configurator_p) {
        ConfigurableMergePolicy mergePolicy;
        ConfigurableDiffPolicy diffPolicy;
        final Button button = new Button(parent_p, 16);
        button.setText(configurator_p.getLabel());
        button.setToolTipText(configurator_p.getDescription());
        button.setSelection(configurator_p.isCompliant((IComparisonConfiguration)this._data));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                configurator_p.apply((IComparisonConfiguration)ConfigureComparisonDialog.this._data);
            }
        });
        final IConfigurablePolicy.IConfigurationChangedListener listener = new IConfigurablePolicy.IConfigurationChangedListener(){

            public void configurationChanged(IConfigurablePolicy notifier_p, Object property_p) {
                boolean fits = configurator_p.isCompliant((IComparisonConfiguration)ConfigureComparisonDialog.this._data);
                button.setSelection(fits);
            }
        };
        final ConfigurableMatchPolicy matchPolicy = this._data.getMatchPolicy();
        if (matchPolicy != null) {
            matchPolicy.addConfigurationChangedListener(listener);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e_p) {
                    matchPolicy.removeConfigurationChangedListener(listener);
                }
            });
        }
        if ((diffPolicy = this._data.getDiffPolicy()) != null) {
            diffPolicy.addConfigurationChangedListener(listener);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e_p) {
                    diffPolicy.removeConfigurationChangedListener(listener);
                }
            });
        }
        if ((mergePolicy = this._data.getMergePolicy()) != null) {
            mergePolicy.addConfigurationChangedListener(listener);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e_p) {
                    mergePolicy.removeConfigurationChangedListener(listener);
                }
            });
        }
    }

    protected void createOptionUseCache(Composite parent_p) {
        final ConfigurableMatchPolicy policy = this._data.getMatchPolicy();
        if (policy != null) {
            final Button checkBox = new Button(parent_p, 32);
            checkBox.setLayoutData(this.createLayoutData());
            checkBox.setText(Messages.ConfigureComparisonDialog_UseCache);
            checkBox.setSelection(policy.useCache());
            checkBox.setToolTipText(Messages.ConfigureComparisonDialog_UseCache_Tooltip);
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e_p) {
                    policy.setUseCache(!policy.useCache());
                }
            });
            final IConfigurablePolicy.IConfigurationChangedListener updateListener = new IConfigurablePolicy.IConfigurationChangedListener(){

                public void configurationChanged(IConfigurablePolicy notifier_p, Object property_p) {
                    checkBox.setSelection(policy.useCache());
                }
            };
            policy.addConfigurationChangedListener(updateListener);
            parent_p.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e_p) {
                    policy.removeConfigurationChangedListener(updateListener);
                }
            });
        }
    }
}

