/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternBasedBijection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractBijectiveTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.AbstractRoleDerivationRule;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.AdditionKind;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatepatternsFactory;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TextualRoleConstraint;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TextualRoleDerivationRule;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.OclPatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.OclInputMessageDialog;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractRoleSelectionPage;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRoleSpecificationPage<T extends AbstractBijectiveTemplatePatternSpecification>
extends AbstractRoleSelectionPage<T> {
    static final String NO_DATA = Messages.AbstractRoleSpecificationPage_None;
    protected final Collection<Control> _alwaysEnabled = new HashSet<Control>();
    protected final Collection<Control> _alwaysDisabled = new HashSet<Control>();

    public AbstractRoleSpecificationPage(String pageTitle_p, String defaultMessage_p, T data_p, boolean isBlocking_p) {
        super("RolesPage", pageTitle_p, defaultMessage_p, data_p, isBlocking_p);
    }

    protected void createAdditionGroup(Composite parent_p) {
        Group additionComposite = this.createGroup(parent_p, Messages.AbstractRoleSpecificationPage_ApplyAdd, true, 3);
        this.fillLineWith((Control)additionComposite);
        this.createAllowAdditionButton((Composite)additionComposite);
        if (!this.showSimplifiedInterface()) {
            this.createPreferredContainmentLine((Composite)additionComposite);
        }
        this.createContainerDerivationLine((Composite)additionComposite);
    }

    protected Button createAllowAdditionButton(final Composite parent_p) {
        final Button result = new Button(parent_p, 32);
        result.setText(Messages.AbstractRoleSpecificationPage_AllowApplyAdd);
        this.fillLineWith((Control)result);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                AdditionKind kind = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole().getAdditionKind();
                if (kind == AdditionKind.FORBIDDEN) {
                    ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole().setAdditionKind(AdditionKind.ANY_CONTAINMENT);
                } else {
                    ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole().setAdditionKind(AdditionKind.FORBIDDEN);
                }
                AbstractRoleSpecificationPage.this.enableAll(parent_p, result.getSelection(), true);
                parent_p.setEnabled(true);
                result.setEnabled(true);
            }
        });
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                if (newRole_p != null) {
                    boolean allowAddition = newRole_p.getAdditionKind() != AdditionKind.FORBIDDEN;
                    result.setSelection(allowAddition);
                    if (allowAddition) {
                        AbstractRoleSpecificationPage.this.enableAll((Control)parent_p, true, true, AbstractRoleSpecificationPage.this._alwaysEnabled, AbstractRoleSpecificationPage.this._alwaysDisabled);
                    } else {
                        AbstractRoleSpecificationPage.this.enableAll(parent_p, false, true);
                        parent_p.setEnabled(true);
                        result.setEnabled(!AbstractRoleSpecificationPage.this.isReadOnly());
                    }
                }
            }
        });
        if (this.isReadOnly()) {
            this._alwaysDisabled.add((Control)result);
        }
        return result;
    }

    protected void createConformityLine(Composite parent_p) {
        new Label(parent_p, 0).setText(Messages.AbstractRoleSpecificationPage_ConformityConstraint);
        final Text conformityConstraint = new Text(parent_p, 2048);
        conformityConstraint.setEditable(false);
        GridData conformityConstraintData = new GridData(4, 128, true, false);
        conformityConstraint.setLayoutData((Object)conformityConstraintData);
        Button conformityConstraintButton = new Button(parent_p, 8);
        conformityConstraintButton.setText("...");
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                String toSet = NO_DATA;
                if (newRole_p != null) {
                    toSet = AbstractRoleSpecificationPage.this.getConformityConstraint(newRole_p);
                }
                conformityConstraint.setText(AbstractRoleSpecificationPage.this.getOclLabel(toSet));
            }
        });
        conformityConstraintButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplatePatternRole role = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole();
                if (role != null) {
                    if (role.getTemplateElements().isEmpty()) {
                        MessageDialog.openError((Shell)AbstractRoleSpecificationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.AbstractRoleSpecificationPage_EmptyRole);
                    } else {
                        try {
                            EObject context = (EObject)role.getTemplateElements().get(0);
                            EObject modelContext = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getCounterpart(context, true);
                            OclInputMessageDialog dialog = new OclInputMessageDialog(AbstractRoleSpecificationPage.this.getShell(), Messages.AbstractRoleSpecificationPage_ConformityConstraint, Messages.AbstractRoleSpecificationPage_PromptOCLConstraint, modelContext, role, (IPatternBasedBijection)AbstractRoleSpecificationPage.this.getData(), AbstractRoleSpecificationPage.this.getConformityConstraint(role), !AbstractRoleSpecificationPage.this.isReadOnly()){

                                protected boolean isValid(OCLExpression parsedExpression_p, Object evaluationResult_p) {
                                    Object type = parsedExpression_p.getType();
                                    return type == this.getInterpreter().getStandardLibrary().getBoolean();
                                }
                            };
                            int answer = dialog.open();
                            if (answer == 0) {
                                String newValue = dialog.getExpression();
                                AbstractRoleSpecificationPage.this.setConformityConstraint(role, newValue);
                                conformityConstraint.setText(AbstractRoleSpecificationPage.this.getOclLabel(newValue));
                            }
                        }
                        catch (NoClassDefFoundError e) {
                            AbstractRoleSpecificationPage.this.warnOCLAbsent();
                        }
                    }
                }
            }
        });
    }

    protected void createContainerDerivationLine(Composite parent_p) {
        new Label(parent_p, 0).setText(String.valueOf(Messages.AbstractRoleSpecificationPage_ContainerDerivation) + ':');
        final Text containerDerivationRule = new Text(parent_p, 2048);
        containerDerivationRule.setEditable(false);
        GridData containerDerivationRuleData = new GridData(4, 128, true, false);
        containerDerivationRule.setLayoutData((Object)containerDerivationRuleData);
        Button containerDerivationRuleButton = new Button(parent_p, 8);
        containerDerivationRuleButton.setText("...");
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                String toSet = NO_DATA;
                if (newRole_p != null) {
                    toSet = AbstractRoleSpecificationPage.this.getAdditionDerivationRule(newRole_p);
                }
                containerDerivationRule.setText(AbstractRoleSpecificationPage.this.getOclLabel(toSet));
            }
        });
        containerDerivationRuleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplatePatternRole role = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole();
                if (role != null) {
                    if (role.getTemplateElements().isEmpty()) {
                        MessageDialog.openError((Shell)AbstractRoleSpecificationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.AbstractRoleSpecificationPage_EmptyRole);
                    } else {
                        try {
                            EObject context = (EObject)role.getTemplateElements().get(0);
                            EObject modelContext = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getCounterpart(context, true);
                            OclInputMessageDialog dialog = new OclInputMessageDialog(AbstractRoleSpecificationPage.this.getShell(), Messages.AbstractRoleSpecificationPage_ContainerDerivation, Messages.AbstractRoleSpecificationPage_PromptOCLQuery, modelContext, role, (IPatternBasedBijection)AbstractRoleSpecificationPage.this.getData(), AbstractRoleSpecificationPage.this.getAdditionDerivationRule(role), !AbstractRoleSpecificationPage.this.isReadOnly());
                            int answer = dialog.open();
                            if (answer == 0) {
                                String newValue = dialog.getExpression();
                                AbstractRoleSpecificationPage.this.setAdditionDerivationRule(role, newValue);
                                containerDerivationRule.setText(AbstractRoleSpecificationPage.this.getOclLabel(newValue));
                                ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).roleUpdated();
                                AbstractRoleSpecificationPage.this.validate();
                            }
                        }
                        catch (NoClassDefFoundError e) {
                            AbstractRoleSpecificationPage.this.warnOCLAbsent();
                        }
                    }
                }
            }
        });
    }

    public void createControl(Composite parent_p) {
        Composite mainComposite = new Composite(parent_p, 0);
        this.setControl((Control)mainComposite);
        GridLayout mainCompositeLayout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)mainCompositeLayout);
        this.setDefaultMessage();
        this.createRoleControls(mainComposite, !this.isReadOnly());
        this.createRoleDetailsControls(mainComposite);
    }

    protected void createDescriptionLine(Composite parent_p) {
        Label label = new Label(parent_p, 0);
        label.setText(Messages.AbstractRoleSpecificationPage_Description);
        GridData labelData = new GridData();
        labelData.verticalAlignment = 128;
        label.setLayoutData((Object)labelData);
        Text text = this.createDescriptionText(parent_p);
        GridData textData = new GridData(4, 4, true, true, 2, 2);
        text.setLayoutData((Object)textData);
        this.addEmptyControl(parent_p);
    }

    protected Text createDescriptionText(Composite parent_p) {
        final Text descriptionText = new Text(parent_p, 2626);
        descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e_p) {
                TemplatePatternRole role = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole();
                if (role != null && !AbstractRoleSpecificationPage.this.isReadOnly()) {
                    String value = descriptionText.getText();
                    role.setDescription(value);
                }
            }
        });
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                if (newRole_p != null) {
                    descriptionText.setText(newRole_p.getDescription());
                }
            }
        });
        if (this.isReadOnly()) {
            descriptionText.setEditable(false);
        }
        return descriptionText;
    }

    protected void createExclusiveRoleLine(Composite parent_p) {
        final Button result = new Button(parent_p, 32);
        result.setText(Messages.AbstractRoleSpecificationPage_ExclusiveTarget);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole().setExclusive(!((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole().isExclusive());
            }
        });
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                if (newRole_p != null) {
                    result.setSelection(newRole_p.isExclusive());
                }
            }
        });
        this.fillLineWith((Control)result);
        if (this.isReadOnly()) {
            this._alwaysDisabled.add((Control)result);
        }
    }

    protected void createGeneralGroup(Composite parent_p) {
        Group generalComposite = this.createGroup(parent_p, Messages.AbstractRoleSpecificationPage_GeneralProperties, true, 3);
        this.createDescriptionLine((Composite)generalComposite);
        this.createConformityLine((Composite)generalComposite);
    }

    protected Button createMandatoryContainmentButton(Composite parent_p) {
        final Button result = new Button(parent_p, 32);
        result.setText(Messages.AbstractRoleSpecificationPage_Mandatory);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                AdditionKind kind = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole().getAdditionKind();
                if (kind == AdditionKind.PREFERRED_CONTAINMENT) {
                    ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole().setAdditionKind(AdditionKind.ANY_CONTAINMENT);
                } else {
                    ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole().setAdditionKind(AdditionKind.PREFERRED_CONTAINMENT);
                }
            }
        });
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                if (newRole_p != null) {
                    boolean mandatoryContainment = newRole_p.getAdditionKind() == AdditionKind.PREFERRED_CONTAINMENT;
                    result.setSelection(mandatoryContainment);
                }
            }
        });
        if (this.isReadOnly()) {
            this._alwaysDisabled.add((Control)result);
        }
        return result;
    }

    protected void createMergeApplicabilityScopeLine(Composite parent_p) {
        new Label(parent_p, 0).setText(Messages.AbstractRoleSpecificationPage_TargetType);
        final Text mergeApplicabilityScope = new Text(parent_p, 2048);
        mergeApplicabilityScope.setEditable(false);
        GridData mergeApplicabilityScopeData = new GridData(4, 128, true, false);
        mergeApplicabilityScope.setLayoutData((Object)mergeApplicabilityScopeData);
        this.addEmptyControl(parent_p);
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                if (newRole_p != null) {
                    EClass commonClass = ModelsUtil.getCommonType((Collection)newRole_p.getTemplateElements());
                    mergeApplicabilityScope.setText(commonClass == null ? "" : commonClass.getName());
                }
            }
        });
    }

    protected void createMergeGroup(Composite parent_p) {
        Group mergeComposite = this.createGroup(parent_p, Messages.AbstractRoleSpecificationPage_ApplyMerge, true, 3);
        this.fillLineWith((Control)mergeComposite);
        if (!this.showSimplifiedInterface()) {
            this.createExclusiveRoleLine((Composite)mergeComposite);
            this.createMergeApplicabilityScopeLine((Composite)mergeComposite);
        }
        this.createTargetDerivationLine((Composite)mergeComposite, null);
    }

    protected void createPreferredContainmentLine(Composite parent_p) {
        new Label(parent_p, 0).setText(Messages.AbstractRoleSpecificationPage_PreferredContainment);
        this.createPreferredContainmentText(parent_p);
        this.createMandatoryContainmentButton(parent_p);
    }

    protected Text createPreferredContainmentText(Composite parent_p) {
        final Text preferredContainment = new Text(parent_p, 2048);
        preferredContainment.setEditable(false);
        GridData preferredContainmentData = new GridData(4, 128, true, false);
        preferredContainment.setLayoutData((Object)preferredContainmentData);
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                if (newRole_p != null) {
                    EReference containment = AbstractRoleSpecificationPage.this.getPreferredContainment(newRole_p);
                    preferredContainment.setText(containment == null ? "" : containment.getName());
                }
            }
        });
        return preferredContainment;
    }

    protected void createRoleDetailsControls(Composite parent_p) {
        final Group group = this.createGroup(parent_p, Messages.AbstractRoleSpecificationPage_RoleDetails, true, 3);
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                boolean unselected;
                boolean bl = unselected = newRole_p == null;
                if (unselected == group.getEnabled()) {
                    boolean enable;
                    boolean bl2 = enable = !unselected;
                    if (enable) {
                        AbstractRoleSpecificationPage.this.enableAll((Control)group, true, true, AbstractRoleSpecificationPage.this._alwaysEnabled, AbstractRoleSpecificationPage.this._alwaysDisabled);
                    } else {
                        AbstractRoleSpecificationPage.this.enableAll((Composite)group, false, true);
                    }
                }
            }
        });
        this.createGeneralGroup((Composite)group);
        this.createMergeGroup((Composite)group);
        this.createAdditionGroup((Composite)group);
        this.enableAll((Composite)group, false, true);
    }

    protected void createTargetDerivationLine(Composite parent_p, String label_p) {
        String label = label_p != null ? label_p : Messages.AbstractRoleSpecificationPage_TargetDerivation;
        new Label(parent_p, 0).setText(String.valueOf(label) + ':');
        final Text mergeDerivationRule = new Text(parent_p, 2048);
        mergeDerivationRule.setEditable(false);
        GridData mergeDerivationRuleData = new GridData(4, 128, true, false);
        mergeDerivationRule.setLayoutData((Object)mergeDerivationRuleData);
        Button mergeDerivationRuleButton = new Button(parent_p, 8);
        mergeDerivationRuleButton.setText("...");
        ((AbstractBijectiveTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                String toSet = NO_DATA;
                if (newRole_p != null) {
                    toSet = AbstractRoleSpecificationPage.this.getMergeDerivationRule(newRole_p);
                }
                mergeDerivationRule.setText(AbstractRoleSpecificationPage.this.getOclLabel(toSet));
            }
        });
        mergeDerivationRuleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplatePatternRole role = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getRole();
                if (role != null) {
                    if (role.getTemplateElements().isEmpty()) {
                        MessageDialog.openError((Shell)AbstractRoleSpecificationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.AbstractRoleSpecificationPage_EmptyRole);
                    } else {
                        try {
                            EObject context = (EObject)role.getTemplateElements().get(0);
                            EObject modelContext = ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).getCounterpart(context, true);
                            OclInputMessageDialog dialog = new OclInputMessageDialog(AbstractRoleSpecificationPage.this.getShell(), Messages.AbstractRoleSpecificationPage_TargetDerivation, Messages.AbstractRoleSpecificationPage_PromptOCLQueryWithRoles, modelContext, role, (IPatternBasedBijection)AbstractRoleSpecificationPage.this.getData(), AbstractRoleSpecificationPage.this.getMergeDerivationRule(role), !AbstractRoleSpecificationPage.this.isReadOnly());
                            int answer = dialog.open();
                            if (answer == 0) {
                                String newValue = dialog.getExpression();
                                AbstractRoleSpecificationPage.this.setMergeDerivationRule(role, newValue);
                                mergeDerivationRule.setText(AbstractRoleSpecificationPage.this.getOclLabel(newValue));
                                ((AbstractBijectiveTemplatePatternSpecification)AbstractRoleSpecificationPage.this.getData()).roleUpdated();
                                AbstractRoleSpecificationPage.this.validate();
                            }
                        }
                        catch (NoClassDefFoundError e) {
                            AbstractRoleSpecificationPage.this.warnOCLAbsent();
                        }
                    }
                }
            }
        });
    }

    protected void fillLineWith(Control control_p) {
        GridData data = new GridData(4, 128, true, false);
        Composite parent = control_p.getParent();
        Layout parentLayout = parent.getLayout();
        if (parentLayout instanceof GridLayout) {
            int nbCol;
            GridLayout gridLayout = (GridLayout)parentLayout;
            data.horizontalSpan = nbCol = gridLayout.numColumns;
        }
        control_p.setLayoutData((Object)data);
    }

    protected String getAdditionDerivationRule(TemplatePatternRole role_p) {
        String result = null;
        AbstractRoleDerivationRule rule = role_p.getAdditionDerivationRule();
        if (rule instanceof TextualRoleDerivationRule) {
            TextualRoleDerivationRule textualRule = (TextualRoleDerivationRule)rule;
            result = textualRule.getSpecification();
        }
        return result;
    }

    protected String getConformityConstraint(TemplatePatternRole role_p) {
        String result = null;
        if (!role_p.getConstraints().isEmpty()) {
            TextualRoleConstraint constraint = (TextualRoleConstraint)role_p.getConstraints().get(0);
            result = constraint.getSpecification();
        }
        return result;
    }

    protected String getMergeDerivationRule(TemplatePatternRole role_p) {
        String result = null;
        AbstractRoleDerivationRule rule = role_p.getMergeDerivationRule();
        if (rule instanceof TextualRoleDerivationRule) {
            TextualRoleDerivationRule textualRule = (TextualRoleDerivationRule)rule;
            result = textualRule.getSpecification();
        }
        return result;
    }

    protected String getOclLabel(String oclSpecification_p) {
        String result = oclSpecification_p == null || oclSpecification_p.length() == 0 ? NO_DATA : oclSpecification_p;
        result = result.replaceAll("\r|\n|\t", " ");
        return result;
    }

    protected EReference getPreferredContainment(TemplatePatternRole role_p) {
        return role_p.getPreferredContainment();
    }

    protected boolean isReadOnly() {
        return false;
    }

    protected void setAdditionDerivationRule(TemplatePatternRole role_p, String specification_p) {
        if (specification_p == null || specification_p.trim().length() == 0) {
            role_p.setAdditionDerivationRule(null);
        } else {
            TextualRoleDerivationRule rule = (TextualRoleDerivationRule)role_p.getAdditionDerivationRule();
            if (rule == null) {
                rule = TemplatepatternsFactory.eINSTANCE.createTextualRoleDerivationRule();
                rule.setLanguage(OclPatternsPlugin.getDefault().getLanguage());
                role_p.setAdditionDerivationRule((AbstractRoleDerivationRule)rule);
            }
            rule.setSpecification(specification_p);
        }
    }

    protected void setConformityConstraint(TemplatePatternRole role_p, String oclBody_p) {
        if (oclBody_p == null || oclBody_p.length() == 0) {
            role_p.getConstraints().clear();
        } else {
            TextualRoleConstraint constraint;
            if (role_p.getConstraints().isEmpty()) {
                constraint = TemplatepatternsFactory.eINSTANCE.createTextualRoleConstraint();
                constraint.setLanguage(OclPatternsPlugin.getDefault().getLanguage());
                role_p.getConstraints().add((Object)constraint);
            } else {
                constraint = (TextualRoleConstraint)role_p.getConstraints().get(0);
            }
            constraint.setSpecification(oclBody_p);
        }
    }

    protected void setMergeDerivationRule(TemplatePatternRole role_p, String specification_p) {
        if (specification_p == null || specification_p.trim().length() == 0) {
            role_p.setMergeDerivationRule(null);
        } else {
            TextualRoleDerivationRule rule = (TextualRoleDerivationRule)role_p.getMergeDerivationRule();
            if (rule == null) {
                rule = TemplatepatternsFactory.eINSTANCE.createTextualRoleDerivationRule();
                rule.setLanguage(OclPatternsPlugin.getDefault().getLanguage());
                role_p.setMergeDerivationRule((AbstractRoleDerivationRule)rule);
            }
            rule.setSpecification(specification_p);
        }
    }

    protected boolean showSimplifiedInterface() {
        return true;
    }

    protected void warnOCLAbsent() {
        String msg = Messages.AbstractRoleSpecificationPage_WarnOCLAbsence;
        MessageDialog dialog = new MessageDialog(this.getShell(), CorePatternsPlugin.getDefault().getLabel(), null, msg, 1, new String[]{IDialogConstants.HELP_LABEL, IDialogConstants.CLOSE_LABEL}, 1);
        int answer = dialog.open();
        if (answer == 0) {
            try {
                String helpLocation = "http://help.eclipse.org/oxygen/index.jsp?topic=%2Forg.eclipse.ocl.doc%2Fhelp%2FInstallation.html";
                URL helpURL = new URL(helpLocation);
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(helpURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

