/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards.application;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IAtomicLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementMappingLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicElementLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IMultiRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternApplicationSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TextualRoleDerivationRule;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.ContainmentChoiceDialog;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.ElementMappingDialog;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.MergeTargetChoiceDialog;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.StorageChoiceDialog;
import org.eclipse.emf.diffmerge.patterns.ui.providers.DiscriminatingLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.RoleBindingViewer;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractMultiRoleSelectionPage;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternApplicationAssociationPage
extends AbstractMultiRoleSelectionPage<TemplatePatternApplicationSpecification> {
    private static final int COLUMNS_NB = 3;
    protected ModelSubsetViewer _modelViewer;
    protected Text _multiplicityText;
    protected Text _numberText;
    protected final Object _diagram;

    public PatternApplicationAssociationPage(TemplatePatternApplicationSpecification data_p, Object diagram_p) {
        super("ApplicationPage", Messages.PatternApplicationAssociationPage_Header, Messages.PatternApplicationAssociationPage_Message, data_p, true);
        this._diagram = diagram_p;
    }

    protected boolean isShowInstanceEnabled() {
        return this._diagramUtil.isShowInstanceEnabled(this._diagram);
    }

    private MenuItem createAddMenuItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_AddRole);
        result.setEnabled(false);
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeAdditionMenuItemEnabled(viewer_p));
            }
        });
        viewer_p.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeAdditionMenuItemEnabled(viewer_p));
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                Object selected = viewer_p.getSelection().getFirstElement();
                if (selected instanceof EObject) {
                    EObject selectedElement = (EObject)selected;
                    for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles()) {
                        PatternApplicationAssociationPage.this.setAdditionFromContainer(role, selectedElement);
                    }
                }
            }
        });
        return result;
    }

    private MenuItem createDeriveAdditionMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_DeriveAdd);
        result.setEnabled(false);
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeDeriveAdditionMenuItemEnabled());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                String ruleText = "";
                List<Object> derivedList = Collections.emptyList();
                for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles()) {
                    ruleText = ((TextualRoleDerivationRule)role.getAdditionDerivationRule()).getSpecification();
                    derivedList = PatternApplicationAssociationPage.this.deriveForAddition(role).getElements();
                }
                if (((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles().size() >= 1) {
                    if (derivedList.isEmpty()) {
                        MessageDialog.openError((Shell)PatternApplicationAssociationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)(String.valueOf(Messages.PatternApplicationAssociationPage_RuleReturnsNone) + '\n' + ruleText));
                    } else if (derivedList.size() > 1) {
                        MessageDialog.openError((Shell)PatternApplicationAssociationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)(String.valueOf(Messages.PatternApplicationAssociationPage_RuleReturnsMany) + '\n' + ruleText));
                    } else {
                        EObject target = (EObject)derivedList.get(0);
                        String targetName = DiscriminatingLabelProvider.getInstance().getText(target);
                        MessageDialog.openInformation((Shell)PatternApplicationAssociationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)(String.valueOf(Messages.PatternApplicationAssociationPage_ComputedContainer) + ' ' + targetName));
                    }
                }
            }
        });
        return result;
    }

    private MenuItem createGuessAddMenuItem(Menu menu_p) {
        MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_GuessAdd);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternApplicationAssociationPage.this.guessMappingFromUI(false);
            }
        });
        return result;
    }

    private MenuItem createGuessMergeMenuItem(Menu menu_p) {
        MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_GuessMerge);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternApplicationAssociationPage.this.guessMappingFromUI(true);
            }
        });
        return result;
    }

    private MenuItem createDeriveMergeMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_DeriveMerge);
        result.setEnabled(false);
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeDeriveMergeMenuItemEnabled());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplatePatternRole role2;
                List<Object> derivedList = Collections.emptyList();
                for (TemplatePatternRole role2 : ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles()) {
                    derivedList = PatternApplicationAssociationPage.this.deriveForMerge(role2).getElements();
                    if (derivedList != null) continue;
                    PatternApplicationAssociationPage.this._modelViewer.refresh();
                    PatternApplicationAssociationPage.this.getRolesViewer().refresh();
                    PatternApplicationAssociationPage.this.getRolesViewer().setSelection(PatternApplicationAssociationPage.this.getRolesViewer().getSelection());
                    PatternApplicationAssociationPage.this.validate();
                    return;
                }
                if (((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles().size() == 1 && !(role2 = (TemplatePatternRole)((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles().iterator().next()).isGeneric()) {
                    if (derivedList.isEmpty()) {
                        String ruleText = ((TextualRoleDerivationRule)role2.getMergeDerivationRule()).getSpecification();
                        MessageDialog.openError((Shell)PatternApplicationAssociationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)("No element is computed by the rule:\n" + ruleText));
                    } else {
                        EObject firstTarget = (EObject)derivedList.get(0);
                        String targetName = DiscriminatingLabelProvider.getInstance().getText(firstTarget);
                        String feedback = derivedList.size() > 1 ? String.format(Messages.PatternApplicationAssociationPage_RuleResultMany, derivedList.size(), targetName) : String.valueOf(Messages.PatternApplicationAssociationPage_RuleResultTarget) + targetName;
                        MessageDialog.openInformation((Shell)PatternApplicationAssociationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)feedback);
                    }
                }
                PatternApplicationAssociationPage.this._modelViewer.refresh();
                PatternApplicationAssociationPage.this.getRolesViewer().refresh();
                PatternApplicationAssociationPage.this.getRolesViewer().setSelection(PatternApplicationAssociationPage.this.getRolesViewer().getSelection());
                PatternApplicationAssociationPage.this.validate();
            }
        });
        return result;
    }

    private MenuItem createFindContainerMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_AddIn);
        result.setEnabled(true);
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeFindContainerMenuItemEnabled());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                FOrderedSet templateElements = new FOrderedSet();
                for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles()) {
                    templateElements.addAll(role.getTemplateElements());
                }
                Object scopeElement = ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getScopeElement();
                if (scopeElement instanceof EObject) {
                    IReferenceLocation location;
                    StorageChoiceDialog dialog;
                    int answer;
                    String message = ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles().size() == 1 ? String.format(Messages.PatternApplicationAssociationPage_SelectContainerSingleRole, ((TemplatePatternRole)((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles().iterator().next()).getName()) : Messages.PatternApplicationAssociationPage_SelectContainerManyRoles;
                    ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(scopeElement);
                    ArrayList candidateContainers = ruleProvider.getPossibleContainersInContext(scopeElement, (Collection)templateElements);
                    if (candidateContainers == null) {
                        candidateContainers = new ArrayList();
                    }
                    if ((answer = (dialog = new StorageChoiceDialog(PatternApplicationAssociationPage.this.getShell(), message, candidateContainers, (Collection<? extends EObject>)templateElements)).open()) == 0 && (location = dialog.getChoice()) != null) {
                        for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles()) {
                            ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().setLocation((IPatternRole)role, (ILocation)location);
                        }
                        EObject container = location.getElement();
                        ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getSelectedElements().add(container);
                        PatternApplicationAssociationPage.this._modelViewer.setInput(PatternApplicationAssociationPage.this.getData());
                        PatternApplicationAssociationPage.this.getRolesViewer().refresh();
                        PatternApplicationAssociationPage.this.getRolesViewer().setSelection(PatternApplicationAssociationPage.this.getRolesViewer().getSelection());
                        PatternApplicationAssociationPage.this.validate();
                    }
                }
            }
        });
        return result;
    }

    private MenuItem createFindMergeTargetMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_MergeWith);
        result.setEnabled(true);
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeFindMergeTargetMenuItemEnabled());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                Object scopeElement = ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getScopeElement();
                if (scopeElement instanceof EObject && ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles().size() == 1) {
                    TemplatePatternRole role = (TemplatePatternRole)((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles().iterator().next();
                    EList templateElements = role.getTemplateElements();
                    IElementMappingLocation location = null;
                    if (templateElements.size() == 1) {
                        EClass mergeType = ((EObject)templateElements.get(0)).eClass();
                        String message = String.format(Messages.PatternApplicationAssociationPage_SelectMerge, role.getName());
                        MergeTargetChoiceDialog dialog = new MergeTargetChoiceDialog(PatternApplicationAssociationPage.this.getShell(), message, (EObject)scopeElement, mergeType);
                        int answer = dialog.open();
                        if (answer == 0) {
                            location = dialog.getChoice();
                        }
                    } else {
                        FArrayList candidates = new FArrayList();
                        try {
                            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress((List)templateElements, (List)candidates, scopeElement){
                                private final /* synthetic */ List val$templateElements;
                                private final /* synthetic */ List val$candidates;
                                private final /* synthetic */ Object val$scopeElement;
                                {
                                    this.val$templateElements = list;
                                    this.val$candidates = list2;
                                    this.val$scopeElement = object;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    final HashSet<EClass> types = new HashSet<EClass>();
                                    for (EObject templateElement : this.val$templateElements) {
                                        types.add(templateElement.eClass());
                                    }
                                    this.val$candidates.addAll(ModelsUtil.getAllContents((EObject)EcoreUtil.getRootContainer((EObject)((EObject)this.val$scopeElement)), (boolean)true, (ModelsUtil.IElementFilter)new ModelsUtil.IElementFilter(){

                                        public boolean accepts(EObject element_p) {
                                            return types.contains(element_p.eClass());
                                        }
                                    }));
                                }
                            });
                        }
                        catch (Exception message) {
                            // empty catch block
                        }
                        ElementMappingDialog dialog = new ElementMappingDialog(PatternApplicationAssociationPage.this.getShell(), role, (Collection<? extends EObject>)candidates);
                        if (dialog.open() == 0) {
                            location = dialog.getResult();
                        }
                    }
                    if (location != null) {
                        Collection mappedElements;
                        boolean mergeMappingExists = false;
                        EObject selectedElement = null;
                        if (location instanceof IElementLocation) {
                            selectedElement = ((IElementLocation)location).getElement();
                        } else if (location instanceof IElementMappingLocation && !(mappedElements = location.getModelElements()).isEmpty()) {
                            selectedElement = (EObject)mappedElements.iterator().next();
                        }
                        if (selectedElement != null) {
                            ArrayList mergeRoles = new ArrayList(((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().getRolesOf(selectedElement));
                            mergeRoles.removeAll(((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().getAdditionRolesOf(selectedElement));
                            if (mergeRoles.size() > 0) {
                                mergeMappingExists = true;
                                MessageDialog.openInformation((Shell)PatternApplicationAssociationPage.this.getShell(), null, (String)(String.valueOf(Messages.PatternApplicationAssociationPage_UniqueAssociationByMerge) + " " + ((IPatternRole)mergeRoles.get(0)).getName()));
                            }
                            if (!mergeMappingExists) {
                                ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().setLocation((IPatternRole)role, (ILocation)location);
                            }
                            PatternApplicationAssociationPage.this.extendSelectedElements((ILocation)location);
                            PatternApplicationAssociationPage.this._modelViewer.setInput(PatternApplicationAssociationPage.this.getData());
                            PatternApplicationAssociationPage.this.getRolesViewer().refresh();
                            PatternApplicationAssociationPage.this.getRolesViewer().setSelection(PatternApplicationAssociationPage.this.getRolesViewer().getSelection());
                            PatternApplicationAssociationPage.this.validate();
                        }
                    }
                }
            }
        });
        return result;
    }

    private MenuItem createResetMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_ResetRole);
        result.setEnabled(true);
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeResetMenuItemEnabled());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles()) {
                    ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().setLocation((IPatternRole)role, null);
                }
                result.setEnabled(false);
                PatternApplicationAssociationPage.this._modelViewer.refresh();
                PatternApplicationAssociationPage.this.getRolesViewer().refresh();
                PatternApplicationAssociationPage.this.getRolesViewer().setSelection(PatternApplicationAssociationPage.this.getRolesViewer().getSelection());
                PatternApplicationAssociationPage.this.validate();
            }
        });
        return result;
    }

    private MenuItem createResetAllMenuItem(Menu menu_p) {
        MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_ResetAllRoles);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getPattern().getRoles()) {
                    ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().setLocation((IPatternRole)role, null);
                }
                PatternApplicationAssociationPage.this.getRolesViewer().refresh();
                PatternApplicationAssociationPage.this.getRolesViewer().setSelection(PatternApplicationAssociationPage.this.getRolesViewer().getSelection());
                PatternApplicationAssociationPage.this._modelViewer.refresh();
                PatternApplicationAssociationPage.this.validate();
            }
        });
        return result;
    }

    protected boolean computeAdditionMenuItemEnabled(ModelSubsetViewer viewer_p) {
        Object selected;
        boolean result = false;
        if (viewer_p.getSelection() != null && viewer_p.getSelection().size() == 1 && !((TemplatePatternApplicationSpecification)this.getData()).getRoles().isEmpty() && (selected = viewer_p.getSelection().getFirstElement()) instanceof EObject) {
            EObject selectedElement = (EObject)selected;
            result = true;
            for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)this.getData()).getRoles()) {
                if (!((TemplatePatternApplicationSpecification)this.getData()).isAssigned(role) && !((TemplatePatternApplicationSpecification)this.getData()).getApplicableAdditionLocations(role, selectedElement).isEmpty()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected boolean computeDeriveAdditionMenuItemEnabled() {
        if (((TemplatePatternApplicationSpecification)this.getData()).getRoles().isEmpty()) {
            return false;
        }
        for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)this.getData()).getRoles()) {
            if (role.acceptsAddition() && role.getAdditionDerivationRule() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean computeDeriveMergeMenuItemEnabled() {
        if (((TemplatePatternApplicationSpecification)this.getData()).getRoles().isEmpty()) {
            return false;
        }
        for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)this.getData()).getRoles()) {
            if (role.acceptsMerge() && role.getMergeDerivationRule() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean computeFindContainerMenuItemEnabled() {
        Collection roles = ((TemplatePatternApplicationSpecification)this.getData()).getRoles();
        if (roles.isEmpty()) {
            return false;
        }
        for (TemplatePatternRole role : roles) {
            if (role.acceptsAddition()) continue;
            return false;
        }
        return true;
    }

    protected boolean computeFindMergeTargetMenuItemEnabled() {
        boolean result = false;
        Collection roles = ((TemplatePatternApplicationSpecification)this.getData()).getRoles();
        if (roles.size() == 1) {
            TemplatePatternRole role = (TemplatePatternRole)roles.iterator().next();
            result = role.acceptsMerge() && (role.getTemplateElements().size() < 2 || role.isGeneric());
        }
        return result;
    }

    protected boolean computeMergeMenuItemEnabled(ModelSubsetViewer viewer_p) {
        Object selected;
        boolean result = false;
        if (viewer_p.getSelection() != null && viewer_p.getSelection().size() == 1 && !((TemplatePatternApplicationSpecification)this.getData()).getRoles().isEmpty() && (selected = viewer_p.getSelection().getFirstElement()) instanceof EObject) {
            EObject selectedElement = (EObject)selected;
            result = true;
            for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)this.getData()).getRoles()) {
                IElementLocation location = ((TemplatePatternApplicationSpecification)this.getData()).getApplicableMergeLocation(role, selectedElement);
                if (location != null) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected boolean computeResetMenuItemEnabled() {
        Collection roles = ((TemplatePatternApplicationSpecification)this.getData()).getRoles();
        boolean result = roles.isEmpty() ? false : (roles.size() > 1 ? true : ((TemplatePatternApplicationSpecification)this.getData()).isAssigned((TemplatePatternRole)roles.iterator().next()));
        return result;
    }

    public void createControl(Composite parent_p) {
        Composite mainComposite = new Composite(parent_p, 0);
        this.setControl((Control)mainComposite);
        GridLayout mainCompositeLayout = new GridLayout(3, false);
        mainCompositeLayout.makeColumnsEqualWidth = true;
        mainComposite.setLayout((Layout)mainCompositeLayout);
        this.setDefaultMessage();
        this.createPatternPart(mainComposite);
        Composite rolesComposite = this.createRoleControls(mainComposite, false);
        ((GridData)rolesComposite.getLayoutData()).horizontalAlignment = 4;
        this._modelViewer = this.createModelPart(mainComposite);
        this.createInitializationControls(mainComposite);
        Menu menu = new Menu(this.getRolesViewer().getControl());
        this.createResetMenuItem(menu);
        this.createFindMergeTargetMenuItem(menu);
        this.createFindContainerMenuItem(menu);
        new MenuItem(menu, 2);
        this.createDeriveMergeMenuItem(menu);
        this.createDeriveAdditionMenuItem(menu);
        new MenuItem(menu, 2);
        this.createResetAllMenuItem(menu);
        this.createGuessMergeMenuItem(menu);
        this.createGuessAddMenuItem(menu);
        this.getRolesViewer().getControl().setMenu(menu);
    }

    private MenuItem createMergeMenuItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_MergeWithRole);
        result.setEnabled(false);
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeMergeMenuItemEnabled(viewer_p));
            }
        });
        viewer_p.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(PatternApplicationAssociationPage.this.computeMergeMenuItemEnabled(viewer_p));
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                Object selected = viewer_p.getSelection().getFirstElement();
                if (selected instanceof EObject) {
                    EObject selectedElement = (EObject)selected;
                    for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getRoles()) {
                        IElementLocation location = ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplicableMergeLocation(role, selectedElement);
                        if (location == null) continue;
                        boolean mergeMappingExists = false;
                        ArrayList mergeRoles = new ArrayList(((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().getRolesOf(selectedElement));
                        mergeRoles.removeAll(((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().getAdditionRolesOf(selectedElement));
                        int n = mergeRoles.size();
                        if (n > 0) {
                            mergeMappingExists = true;
                            MessageDialog.openInformation((Shell)PatternApplicationAssociationPage.this.getShell(), null, (String)(String.valueOf(Messages.PatternApplicationAssociationPage_UniqueAssociationByMerge) + " " + ((IPatternRole)mergeRoles.get(0)).getName()));
                        }
                        if (mergeMappingExists) continue;
                        ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication().setLocation((IPatternRole)role, (ILocation)location);
                    }
                    viewer_p.refresh();
                    PatternApplicationAssociationPage.this.getRolesViewer().refresh();
                    PatternApplicationAssociationPage.this.getRolesViewer().setSelection(PatternApplicationAssociationPage.this.getRolesViewer().getSelection());
                    PatternApplicationAssociationPage.this.validate();
                }
            }
        });
        return result;
    }

    private ModelSubsetViewer createModelPart(Composite parent_p) {
        Group modelGroup = this.createGroup(parent_p, Messages.PatternApplicationAssociationPage_Selected, true, 1);
        RoleBindingViewer modelViewer = new RoleBindingViewer((Composite)modelGroup, false, false){

            protected int getControlWidgetConfiguration() {
                return ModelSubsetViewer.SHOW_PARENTS;
            }
        };
        ((ModelSubsetViewer)modelViewer).setInput(this.getData());
        Menu menu = new Menu((Control)modelViewer.getTreeViewer().getTree());
        this.createMergeMenuItem(menu, modelViewer);
        this.createAddMenuItem(menu, modelViewer);
        modelViewer.getTreeViewer().getTree().setMenu(menu);
        return modelViewer;
    }

    private void createPatternPart(Composite parent_p) {
        Group patternGroup = this.createGroup(parent_p, Messages.PatternApplicationAssociationPage_RoleContents, true, 1);
        Group descriptionGroup = this.createGroup((Composite)patternGroup, Messages.PatternApplicationAssociationPage_Description, true, 1);
        final Text descriptionText = new Text((Composite)descriptionGroup, 2626);
        descriptionText.setEditable(false);
        GridData textData = new GridData(4, 4, true, true);
        descriptionText.setLayoutData((Object)textData);
        final ModelSubsetViewer resultViewer = new ModelSubsetViewer((Composite)patternGroup, false, false){

            protected int getExpandDepth() {
                return 2;
            }

            protected int getControlWidgetConfiguration() {
                return ModelSubsetViewer.NONE;
            }
        };
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                String newDescription = newRoles_p.size() == 1 ? newRoles_p.iterator().next().getDescription() : "";
                FOrderedSet newElements = new FOrderedSet();
                for (TemplatePatternRole templatePatternRole : newRoles_p) {
                    newElements.addAll(templatePatternRole.getTemplateElements());
                }
                descriptionText.setText(newDescription);
                resultViewer.setInput(ModelsUtil.getAllContents((Collection)newElements, (boolean)true, null));
            }
        });
        resultViewer.getTreeViewer().getControl().setEnabled(true);
    }

    protected RuleEvaluationResult deriveForMerge(TemplatePatternRole role_p) {
        RuleEvaluationResult result;
        EList evalResult = role_p.getMergeDerivationRule().deriveCandidateElements((IPatternApplication)((TemplatePatternApplicationSpecification)this.getData()).getApplication());
        if (evalResult != null) {
            if (role_p.isGeneric()) {
                ElementMappingDialog dialog = new ElementMappingDialog(this.getShell(), role_p, (Collection<? extends EObject>)evalResult);
                if (dialog.open() == 0) {
                    ((TemplatePatternApplicationSpecification)this.getData()).getApplication().setLocation((IPatternRole)role_p, (ILocation)dialog.getResult());
                    result = new RuleEvaluationResult((List<EObject>)evalResult);
                } else {
                    result = new RuleEvaluationResult(RuleEvaluationStatus.CANCEL);
                }
            } else if (!evalResult.isEmpty()) {
                ((TemplatePatternApplicationSpecification)this.getData()).getApplication().setLocation((IPatternRole)role_p, null);
                for (EObject target : evalResult) {
                    BasicElementLocation location = new BasicElementLocation(target);
                    ((TemplatePatternApplicationSpecification)this.getData()).getApplication().addLocation((IPatternRole)role_p, (ILocation)location);
                }
                result = new RuleEvaluationResult((List<EObject>)evalResult);
            } else {
                result = new RuleEvaluationResult(RuleEvaluationStatus.FAILURE);
            }
        } else {
            result = new RuleEvaluationResult(RuleEvaluationStatus.FAILURE);
        }
        return result;
    }

    private Button createDisplayControls(Composite parent_p) {
        Button result = new Button(parent_p, 32);
        GridData data = new GridData(16384, 128, true, false);
        result.setLayoutData((Object)data);
        boolean showInstanceAvailable = this.isShowInstanceEnabled();
        ((TemplatePatternApplicationSpecification)this.getData()).setDisplayWhenDone(showInstanceAvailable);
        result.setEnabled(showInstanceAvailable);
        result.setText(Messages.PatternApplicationAssociationPage_ShowInstance);
        result.setSelection(((TemplatePatternApplicationSpecification)this.getData()).mustDisplayWhenDone());
        final Button layoutCheckbox = new Button(parent_p, 32);
        GridData dataLayoutCheckbox = new GridData(16384, 128, true, false);
        layoutCheckbox.setLayoutData((Object)dataLayoutCheckbox);
        layoutCheckbox.setEnabled(((TemplatePatternApplicationSpecification)this.getData()).mayReuseLayoutAndStyle());
        layoutCheckbox.setText(Messages.PatternApplicationAssociationPage_ReuseLayout);
        layoutCheckbox.setSelection(((TemplatePatternApplicationSpecification)this.getData()).mustReuseLayout());
        new Label(parent_p, 0);
        final Button styleCheckbox = new Button(parent_p, 32);
        GridData dataStyleCheckbox = new GridData(16384, 128, true, false);
        styleCheckbox.setLayoutData((Object)dataStyleCheckbox);
        styleCheckbox.setEnabled(((TemplatePatternApplicationSpecification)this.getData()).mayReuseLayoutAndStyle());
        styleCheckbox.setText(Messages.PatternApplicationAssociationPage_ReuseStyle);
        styleCheckbox.setSelection(((TemplatePatternApplicationSpecification)this.getData()).mustReuseStyle());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).setDisplayWhenDone(!((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).mustDisplayWhenDone());
            }
        });
        layoutCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).setReuseLayout(layoutCheckbox.getSelection());
            }
        });
        styleCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).setReuseStyle(styleCheckbox.getSelection());
            }
        });
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

            public void patternChanged(TemplatePattern newPattern_p) {
                boolean layoutIsPresent = ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).mayReuseLayoutAndStyle();
                layoutCheckbox.setEnabled(((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).mustDisplayWhenDone() && layoutIsPresent);
                layoutCheckbox.setSelection(layoutIsPresent && ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).mustReuseLayout());
                styleCheckbox.setEnabled(((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).mustDisplayWhenDone() && layoutIsPresent);
                styleCheckbox.setSelection(layoutIsPresent && ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).mustReuseStyle());
            }
        });
        return result;
    }

    private Composite createInitializationControls(Composite parent_p) {
        Group result = new Group(parent_p, 0);
        result.setText(Messages.PatternApplicationAssociationPage_Initialization);
        GridData data = new GridData(4, 128, true, false);
        data.horizontalSpan = 3;
        result.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, true);
        result.setLayout((Layout)layout);
        this._numberText = this.createNumberControls((Composite)result);
        this._multiplicityText = this.createMultiplicityControls((Composite)result);
        this.createUnfoldControls((Composite)result);
        this.createDisplayControls((Composite)result);
        return result;
    }

    private Text createMultiplicityControls(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        final Label label = new Label(composite, 0);
        label.setText(Messages.PatternApplicationAssociationPage_Multiplicity);
        boolean mustEnable = ((TemplatePatternApplicationSpecification)this.getData()).getPattern() != null && !((TemplatePatternApplicationSpecification)this.getData()).getPattern().getMultiElements().isEmpty();
        label.setEnabled(mustEnable);
        final Text result = new Text(composite, 2052);
        GridData data = new GridData();
        data.widthHint = 20;
        result.setLayoutData((Object)data);
        final String defaultMultiplicity = String.valueOf(((TemplatePatternApplicationSpecification)this.getData()).getMultiplicity());
        result.setText(defaultMultiplicity);
        result.setEnabled(mustEnable);
        result.setToolTipText(Messages.PatternApplicationAssociationPage_MultiplicityTooltip);
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e_p) {
                try {
                    int multiplicity = Integer.parseInt(result.getText());
                    ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).setMultiplicity(multiplicity);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                PatternApplicationAssociationPage.this.validate();
            }
        });
        ((TemplatePatternApplicationSpecification)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

            public void patternChanged(TemplatePattern newPattern_p) {
                boolean enable = newPattern_p != null && !newPattern_p.getMultiElements().isEmpty();
                label.setEnabled(enable);
                result.setEnabled(enable);
                if (!enable) {
                    result.setText(defaultMultiplicity);
                }
            }
        });
        return result;
    }

    private Text createNumberControls(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.PatternApplicationAssociationPage_NumberOfInstancesLabel);
        final Text result = new Text(composite, 2052);
        GridData data = new GridData();
        data.widthHint = 20;
        result.setLayoutData((Object)data);
        String defaultNumber = String.valueOf(((TemplatePatternApplicationSpecification)this.getData()).getNumberOfApplications());
        result.setText(defaultNumber);
        result.setToolTipText(Messages.PatternApplicationAssociationPage_NumberOfInstancesTooltip);
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e_p) {
                try {
                    int number = Integer.parseInt(result.getText());
                    ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).setNumberOfApplications(number);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                PatternApplicationAssociationPage.this.validate();
            }
        });
        return result;
    }

    private Button createUnfoldControls(Composite parent_p) {
        Button result = new Button(parent_p, 32);
        GridData data = new GridData(16384, 128, true, false);
        result.setLayoutData((Object)data);
        result.setText(Messages.PatternApplicationAssociationPage_UnfoldInstance);
        result.setSelection(((TemplatePatternApplicationSpecification)this.getData()).mustUnfoldWhenDone());
        final Composite nrComposite = new Composite(parent_p, 0);
        GridData nrcData = new GridData(4, 128, true, false);
        nrComposite.setLayoutData((Object)nrcData);
        GridLayout nrLayout = new GridLayout(3, false);
        nrLayout.marginHeight = 0;
        nrLayout.marginWidth = 0;
        nrComposite.setLayout((Layout)nrLayout);
        Label nrLabel = new Label(nrComposite, 0);
        nrLabel.setText(Messages.PatternApplicationAssociationPage_NamingRule);
        final Text nrText = new Text(nrComposite, 2052);
        GridData nrtData = new GridData(4, 4, true, false);
        nrText.setLayoutData((Object)nrtData);
        nrText.setText(((TemplatePatternApplicationSpecification)this.getData()).getNamingRule());
        nrText.setToolTipText(String.format(Messages.PatternApplicationAssociationPage_NamingRuleTooltip, NamingUtil.getNeutralRenamingRule(), NamingUtil.getIndexSymbol()));
        Button nrPropose = new Button(nrComposite, 8);
        nrPropose.setText(Messages.PatternApplicationAssociationPage_Propose);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newUnfold = !((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).mustUnfoldWhenDone();
                ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).setUnfoldWhenDone(newUnfold);
                PatternApplicationAssociationPage.this.enableAll(nrComposite, newUnfold, true);
            }
        });
        nrText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e_p) {
                ((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).setNamingRule(nrText.getText());
            }
        });
        nrPropose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String namingRule = PatternApplicationAssociationPage.this.hasSignificantNumber() ? NamingUtil.getSymbolicIndexedName() : NamingUtil.proposeNamingRule((IPatternApplication)((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getApplication());
                if (namingRule == null) {
                    namingRule = NamingUtil.getNeutralRenamingRule();
                }
                if (!namingRule.equals(((TemplatePatternApplicationSpecification)PatternApplicationAssociationPage.this.getData()).getNamingRule())) {
                    nrText.setText(namingRule);
                }
            }
        });
        return result;
    }

    protected RuleEvaluationResult deriveForAddition(TemplatePatternRole role_p) {
        RuleEvaluationResult result;
        EList evalResult = role_p.getAdditionDerivationRule().deriveCandidateElements((IPatternApplication)((TemplatePatternApplicationSpecification)this.getData()).getApplication());
        if (evalResult != null && evalResult.size() == 1) {
            this.setAdditionFromContainer(role_p, (EObject)evalResult.get(0));
            result = new RuleEvaluationResult((List<EObject>)evalResult);
        } else {
            result = new RuleEvaluationResult(RuleEvaluationStatus.FAILURE);
        }
        return result;
    }

    protected void extendSelectedElements(ILocation location_p) {
        List targets = LocationsUtil.getMergeTargets((ILocation)location_p);
        List involved = LocationsUtil.getInvolvedElements((ILocation)location_p);
        Object set = new FOrderedSet();
        set.addAll(((TemplatePatternApplicationSpecification)this.getData()).getSelectedElements());
        set.addAll(targets);
        set.addAll(involved);
        set = ModelsUtil.getRoots((Collection)set);
        ((TemplatePatternApplicationSpecification)this.getData()).getSelectedElements().clear();
        ((TemplatePatternApplicationSpecification)this.getData()).getSelectedElements().addAll(set);
    }

    @Override
    protected String getTextForRole(TemplatePatternRole role_p, String defaultLabel_p) {
        String result = defaultLabel_p;
        if (!((TemplatePatternApplicationSpecification)this.getData()).isAssigned(role_p)) {
            if (role_p.isDerivable(true) || role_p.isDerivable(false)) {
                result = UIUtil.markAsDerivableRole(result);
            }
            result = UIUtil.markAsFreeRole(result);
        }
        return result;
    }

    @Override
    protected String getValidationMessage() {
        String result = super.getValidationMessage();
        if (result == null && this._multiplicityText != null && this._numberText != null) {
            try {
                int multiplicity = Integer.parseInt(this._multiplicityText.getText());
                int number = Integer.parseInt(this._numberText.getText());
                if (multiplicity < 1 || number < 1) {
                    result = Messages.PatternApplicationAssociationPage_MultiplicityPositive;
                }
            }
            catch (NumberFormatException e) {
                result = Messages.PatternApplicationAssociationPage_MultiplicityInteger;
            }
        }
        return result;
    }

    protected void guessMappingFromUI(boolean mergeFirst_p) {
        RuleEvaluationResult result = new RuleEvaluationResult(RuleEvaluationStatus.OK);
        TemplatePatternRole faultyRole = null;
        for (TemplatePatternRole role : ((TemplatePatternApplicationSpecification)this.getData()).getPattern().getRoles()) {
            if (((TemplatePatternApplicationSpecification)this.getData()).getApplication().getLocation((IPatternRole)role) != null) continue;
            RuleEvaluationResult ruleEvaluationResult = result = mergeFirst_p ? this.guessMergeBasedMappingFor(role) : this.guessAdditionBasedMappingFor(role);
            if (result.getStatus() == RuleEvaluationStatus.FAILURE) {
                faultyRole = role;
            }
            if (!result.isOK()) break;
            ILocation location = ((TemplatePatternApplicationSpecification)this.getData()).getApplication().getLocation((IPatternRole)role);
            if (location == null) continue;
            this.extendSelectedElements(location);
        }
        this._modelViewer.setInput(this.getData());
        this.getRolesViewer().refresh();
        this.getRolesViewer().setSelection(this.getRolesViewer().getSelection());
        this._modelViewer.refresh();
        this.validate();
        String title = this.getWizard().getWindowTitle();
        if (result.isOK()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)Messages.PatternApplicationAssociationPage_GuessOK);
        } else if (faultyRole != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)title, (String)String.format(Messages.PatternApplicationAssociationPage_GuessFailed, faultyRole.getName()));
        }
    }

    protected RuleEvaluationResult guessAdditionBasedMappingFor(TemplatePatternRole role_p) {
        RuleEvaluationResult result = new RuleEvaluationResult(RuleEvaluationStatus.FAILURE);
        boolean derivableForAddition = role_p.isDerivable(false);
        if (derivableForAddition) {
            result = this.deriveForAddition(role_p);
        }
        if (!result.isOK()) {
            boolean derivableForMerge = role_p.isDerivable(true);
            if (derivableForMerge) {
                result = this.deriveForMerge(role_p);
            }
            if (!result.isOK() && this.guessContainerFromSelection(role_p)) {
                result = new RuleEvaluationResult(RuleEvaluationStatus.OK);
            }
            if (!result.isOK() && this.guessContainerFromApplication(role_p)) {
                result = new RuleEvaluationResult(RuleEvaluationStatus.OK);
            }
            if (!result.isOK() && this.guessMergeTargetFromSelection(role_p)) {
                result = new RuleEvaluationResult(RuleEvaluationStatus.OK);
            }
        }
        return result;
    }

    protected RuleEvaluationResult guessMergeBasedMappingFor(TemplatePatternRole role_p) {
        RuleEvaluationResult result = new RuleEvaluationResult(RuleEvaluationStatus.FAILURE);
        boolean derivableForMerge = role_p.isDerivable(true);
        if (derivableForMerge) {
            result = this.deriveForMerge(role_p);
        }
        if (!result.isOK()) {
            boolean derivableForAddition = role_p.isDerivable(false);
            if (derivableForAddition) {
                result = this.deriveForAddition(role_p);
            }
            if (!(result.isOK() || derivableForMerge || derivableForAddition || !this.guessMergeTargetFromSelection(role_p) && !this.guessContainerFromApplication(role_p))) {
                result = new RuleEvaluationResult(RuleEvaluationStatus.OK);
            }
        }
        return result;
    }

    protected boolean guessContainerFromApplication(TemplatePatternRole role_p) {
        boolean result = false;
        if (role_p.acceptsAddition() && role_p.getTemplateElements().size() == 1) {
            EObject templateElement = (EObject)role_p.getTemplateElements().get(0);
            BasicPatternApplication application = ((TemplatePatternApplicationSpecification)this.getData()).getApplication();
            Iterator it = role_p.getPattern().getRoles().iterator();
            ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(((TemplatePatternApplicationSpecification)this.getData()).getScopeElement());
            while (!result && it.hasNext()) {
                List candidateContainments;
                TemplatePatternRole previousRole = (TemplatePatternRole)it.next();
                if (previousRole == role_p) break;
                ILocation location = application.getLocation((IPatternRole)previousRole);
                if (location == null) continue;
                EObject candidateContainer = null;
                EReference candidateContainment = null;
                IAtomicLocation atomicLocation = (IAtomicLocation)location.getAtomicContents().get(0);
                if (atomicLocation instanceof IReferenceLocation) {
                    candidateContainer = ((IReferenceLocation)atomicLocation).getElement();
                    if (!ruleProvider.supportsAdditionOf(candidateContainer, candidateContainment = ((IReferenceLocation)atomicLocation).getReference(), templateElement, true)) {
                        candidateContainment = null;
                    }
                } else if (atomicLocation instanceof IElementLocation) {
                    EObject mergeTarget = ((IElementLocation)atomicLocation).getElement();
                    candidateContainer = mergeTarget.eContainer();
                }
                if (candidateContainer != null && candidateContainment == null && (candidateContainments = ruleProvider.getReferencesForAddition(candidateContainer, templateElement.eClass(), true, true)) != null && !candidateContainments.isEmpty()) {
                    candidateContainment = (EReference)candidateContainments.get(0);
                }
                if (candidateContainer == null || candidateContainment == null) continue;
                BasicReferenceLocation referenceLocation = new BasicReferenceLocation(candidateContainer, candidateContainment);
                application.setLocation((IPatternRole)role_p, (ILocation)referenceLocation);
                result = true;
            }
        }
        return result;
    }

    protected boolean guessContainerFromSelection(TemplatePatternRole role_p) {
        boolean result = false;
        if (role_p.acceptsAddition()) {
            BasicPatternApplication application = ((TemplatePatternApplicationSpecification)this.getData()).getApplication();
            Iterator selectionIt = ((TemplatePatternApplicationSpecification)this.getData()).getSelectedElements().iterator();
            while (selectionIt.hasNext() && !result) {
                EObject selectedElement = (EObject)selectionIt.next();
                Iterator containmentsIt = selectedElement.eClass().getEAllContainments().iterator();
                while (containmentsIt.hasNext() && !result) {
                    EReference containment = (EReference)containmentsIt.next();
                    BasicReferenceLocation candidateLocation = new BasicReferenceLocation(selectedElement, containment);
                    if (!role_p.checkApplicability((ILocation)candidateLocation, (IPatternApplication)application).isOk() || role_p.isExclusive() && !application.getRolesOf(selectedElement).isEmpty()) continue;
                    application.setLocation((IPatternRole)role_p, (ILocation)candidateLocation);
                    result = true;
                }
            }
        }
        return result;
    }

    protected boolean guessMergeTargetFromSelection(TemplatePatternRole role_p) {
        boolean result = false;
        if (role_p.acceptsMerge()) {
            BasicPatternApplication application = ((TemplatePatternApplicationSpecification)this.getData()).getApplication();
            for (EObject selectedElement : ((TemplatePatternApplicationSpecification)this.getData()).getSelectedElements()) {
                BasicElementLocation elementLocation = new BasicElementLocation(selectedElement);
                if (!role_p.checkApplicability((ILocation)elementLocation, (IPatternApplication)application).isOk() || role_p.isExclusive() && !application.getRolesOf(selectedElement).isEmpty()) continue;
                application.setLocation((IPatternRole)role_p, (ILocation)elementLocation);
                result = true;
                break;
            }
        }
        return result;
    }

    protected boolean hasSignificantNumber() {
        boolean result = false;
        if (this._numberText != null) {
            try {
                int number = Integer.parseInt(this._numberText.getText());
                if (number > 1) {
                    result = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected void setAdditionFromContainer(TemplatePatternRole role_p, EObject container_p) {
        Collection locations = ((TemplatePatternApplicationSpecification)this.getData()).getApplicableAdditionLocations(role_p, container_p);
        IAtomicLocation location = null;
        if (locations.size() == 1) {
            location = (IAtomicLocation)locations.iterator().next();
        } else if (!locations.isEmpty()) {
            ContainmentChoiceDialog dialog;
            int answer;
            IReferenceLocation defaultSelection = null;
            EReference preferred = role_p.getPreferredContainment();
            if (preferred != null) {
                for (IReferenceLocation current : locations) {
                    if (current.getReference() != preferred) continue;
                    defaultSelection = current;
                    break;
                }
            }
            if ((answer = (dialog = new ContainmentChoiceDialog(this.getShell(), null, Messages.PatternApplicationAssociationPage_PromptForContainment, locations, defaultSelection)).open()) == 0) {
                location = (IAtomicLocation)dialog.getChoice();
            }
        }
        if (location != null) {
            ((TemplatePatternApplicationSpecification)this.getData()).getApplication().setLocation((IPatternRole)role_p, (ILocation)location);
            this._modelViewer.refresh();
            this.getRolesViewer().refresh();
            this.getRolesViewer().setSelection(this.getRolesViewer().getSelection());
            this.validate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RuleEvaluationResult {
        private final RuleEvaluationStatus _status;
        private final List<EObject> _elements;

        public RuleEvaluationResult(RuleEvaluationStatus status_p) {
            this._status = status_p;
            this._elements = null;
        }

        public RuleEvaluationResult(List<EObject> elements_p) {
            this._status = RuleEvaluationStatus.OK;
            this._elements = elements_p;
        }

        public RuleEvaluationStatus getStatus() {
            return this._status;
        }

        public List<EObject> getElements() {
            return this._elements;
        }

        public boolean isOK() {
            return this.getStatus() == RuleEvaluationStatus.OK;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum RuleEvaluationStatus {
        OK,
        FAILURE,
        CANCEL;

    }
}

