/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.ddl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.ase.SybaseASESQLUtil;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlBuilder;
import org.eclipse.datatools.enablement.sybase.IGenericDdlConstants;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEColumnCheckConstraint;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDefault;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASERule;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESegment;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.emf.ecore.EObject;

public final class SybaseASEDdlGenerator
extends SybaseDdlGenerator
implements DDLGenerator,
IExecutableExtension,
ISybaseASEDdlConstants,
IGenericDdlConstants {
    private String product;
    private String version;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.product = config.getAttribute("product");
        this.version = config.getAttribute("version");
    }

    protected void createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        if (this.sybaseDdlBuilder == null) {
            this.sybaseDdlBuilder = this.createBuilder();
        }
        int i = 0;
        while (i < elements.length) {
            this.createStatement(elements[i], quoteIdentifiers, qualifyNames, fullSyntax, script, progressMonitor, task);
            ++i;
        }
    }

    protected void dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        if (this.sybaseDdlBuilder == null) {
            this.sybaseDdlBuilder = this.createBuilder();
        }
        int i = 0;
        while (i < elements.length) {
            this.dropStatement(elements[i], quoteIdentifiers, qualifyNames, script, progressMonitor, task);
            ++i;
        }
    }

    public void createStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        if (!(element instanceof SybaseASEColumnCheckConstraint)) {
            if (element instanceof SybaseASESegment) {
                String[] statements = ((SybaseASEDdlBuilder)this.sybaseDdlBuilder).createSegment((SybaseASESegment)element, quoteIdentifiers, qualifyNames, fullSyntax);
                int j = 0;
                while (j < statements.length) {
                    script.addCreateDatabaseObjectStatements(statements[j]);
                    ++j;
                }
            } else if (element instanceof SybaseASEDefault) {
                String[] statements = ((SybaseASEDdlBuilder)this.sybaseDdlBuilder).createDefault((SybaseASEDefault)element, quoteIdentifiers, qualifyNames, fullSyntax);
                int j = 0;
                while (j < statements.length) {
                    script.addCreateDefaultStatements(statements[j]);
                    ++j;
                }
            } else if (element instanceof SybaseASERule) {
                String[] statements = ((SybaseASEDdlBuilder)this.sybaseDdlBuilder).createRule((SybaseASERule)element, quoteIdentifiers, qualifyNames, fullSyntax);
                int j = 0;
                while (j < statements.length) {
                    script.addCreateRuleStatements(statements[j]);
                    ++j;
                }
            } else {
                super.createStatement(element, quoteIdentifiers, qualifyNames, fullSyntax, script, progressMonitor, task);
            }
        }
    }

    public void dropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        super.dropStatement(element, quoteIdentifiers, qualifyNames, script, progressMonitor, task);
        if (element instanceof SybaseASESegment) {
            script.addDropDatabaseObjectStatements(((SybaseASEDdlBuilder)this.sybaseDdlBuilder).dropSegment((SybaseASESegment)element, quoteIdentifiers, qualifyNames));
        } else if (element instanceof SybaseASEDefault) {
            script.addDropDefaultStatements(((SybaseASEDdlBuilder)this.sybaseDdlBuilder).dropDefault((SybaseASEDefault)element, quoteIdentifiers, qualifyNames));
        } else if (element instanceof SybaseASERule) {
            script.addDropRuleStatements(((SybaseASEDdlBuilder)this.sybaseDdlBuilder).dropRule((SybaseASERule)element, quoteIdentifiers, qualifyNames));
        }
    }

    protected SybaseDdlBuilder createBuilder() {
        this.sybaseDdlBuilder = SybaseASEDdlBuilder.getInstance();
        return this.sybaseDdlBuilder;
    }

    public byte[] getAdditionalOptionIndices(int objectType) {
        if (objectType == 18) {
            return new byte[]{8, 21, 20, 7, 4, 16, 6, 5, 10, 15, 22};
        }
        if (objectType == 4 || objectType == 16) {
            return new byte[]{11, 12, 13, 14, 5, 7, 10, 20, 21};
        }
        return new byte[0];
    }

    public byte[] getGenerationOptionIndices(int objectType) {
        if (objectType == 4 || objectType == 8 || objectType == 9 || objectType == 6 || objectType == 18 || objectType == 16) {
            byte[] byArray = new byte[5];
            byArray[0] = 3;
            byArray[1] = 2;
            byArray[3] = 1;
            byArray[4] = 17;
            return byArray;
        }
        byte[] byArray = new byte[4];
        byArray[0] = 3;
        byArray[1] = 2;
        byArray[3] = 1;
        return byArray;
    }

    public byte[] getExclusiveAdditionalOptionIndices(int objectType) {
        if (objectType == 18) {
            return new byte[]{21, 20, 22};
        }
        if (objectType == 4 || objectType == 16) {
            return new byte[]{7, 20, 21};
        }
        return new byte[0];
    }

    public String[] dropSQLObjectsForDeltaDDL(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.dropStatements(elements, quoteIdentifiers, qualifyNames, script, progressMonitor, 100);
        return script.getStatements();
    }

    public String[] createSQLObjectsForDeltaDDL(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.createStatements(elements, quoteIdentifiers, qualifyNames, fullSyntax, script, progressMonitor, 100);
        return script.getStatements();
    }

    public String[] createSQLObjects(SQLObject[] elements, EngineeringOption[] options, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.createStatements(elements, options, script, progressMonitor, 100);
        if (this.generateUseDatabase(options)) {
            int i = 0;
            while (i < elements.length) {
                Catalog catalog;
                if (!(elements[i] instanceof Catalog) && (catalog = SybaseASESQLUtil.getContainedCatalog((EObject)elements[i])) != null) {
                    String useDbStr = SybaseASESQLUtil.getUseDbStatement(catalog, (DatabaseIdentifier)this.getParameter());
                    script.addUseDatabaseCreateStatements(useDbStr);
                    break;
                }
                ++i;
            }
        }
        return script.getStatements();
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.createStatements(elements, quoteIdentifiers, qualifyNames, fullSyntax, script, progressMonitor, 100);
        int i = 0;
        while (i < elements.length) {
            Catalog catalog;
            if (!(elements[i] instanceof Catalog) && (catalog = SybaseASESQLUtil.getContainedCatalog((EObject)elements[i])) != null) {
                String useDbStr = SybaseASESQLUtil.getUseDbStatement(catalog, (DatabaseIdentifier)this.getParameter());
                script.addUseDatabaseCreateStatements(useDbStr);
                break;
            }
            ++i;
        }
        return script.getStatements();
    }

    public String[] dropSQLObjects(SQLObject[] elements, EngineeringOption[] options, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.dropStatements(elements, options, script, progressMonitor, 100);
        if (this.generateUseDatabase(options)) {
            int i = 0;
            while (i < elements.length) {
                Catalog catalog;
                if (!(elements[i] instanceof Catalog) && (catalog = SybaseASESQLUtil.getContainedCatalog((EObject)elements[i])) != null) {
                    String useDbStr = SybaseASESQLUtil.getUseDbStatement(catalog, (DatabaseIdentifier)this.getParameter());
                    script.addUseDatabaseCreateStatements(useDbStr);
                    break;
                }
                ++i;
            }
        }
        return script.getStatements();
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.dropStatements(elements, quoteIdentifiers, qualifyNames, script, progressMonitor, 100);
        int i = 0;
        while (i < elements.length) {
            Catalog catalog;
            if (!(elements[i] instanceof Catalog) && (catalog = SybaseASESQLUtil.getContainedCatalog((EObject)elements[i])) != null) {
                String useDbStr = SybaseASESQLUtil.getUseDbStatement(catalog, (DatabaseIdentifier)this.getParameter());
                script.addUseDatabaseDropStatements(useDbStr);
                break;
            }
            ++i;
        }
        return script.getStatements();
    }
}

