/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate;

import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkNode;

public class EdgeAngleCalculator
implements ILayoutProcessor<ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        ElkNode root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
        for (ElkEdge edge : root.getOutgoingEdges()) {
            KVector start = new KVector(((ElkEdgeSection)edge.getSections().get(0)).getStartX(), ((ElkEdgeSection)edge.getSections().get(0)).getStartY());
            KVector end = new KVector(((ElkEdgeSection)edge.getSections().get(0)).getEndX(), ((ElkEdgeSection)edge.getSections().get(0)).getEndY());
            KVector edgeVector = KVector.diff((KVector)end, (KVector)start);
            double angle = Math.atan2(edgeVector.y, edgeVector.x);
            ((ElkConnectableShape)edge.getTargets().get(0)).setProperty(RadialOptions.ROTATION_TARGET_ANGLE, (Object)angle);
        }
    }
}

