/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.svg.util;

import java.awt.LinearGradientPaint;
import java.util.Arrays;
import org.jfree.svg.util.Args;

public class LinearGradientPaintKey {
    private final LinearGradientPaint paint;

    public LinearGradientPaintKey(LinearGradientPaint lgp) {
        Args.nullNotPermitted(lgp, "lgp");
        this.paint = lgp;
    }

    public LinearGradientPaint getPaint() {
        return this.paint;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LinearGradientPaint)) {
            return false;
        }
        LinearGradientPaint that = (LinearGradientPaint)obj;
        if (!this.paint.getStartPoint().equals(that.getStartPoint())) {
            return false;
        }
        if (!this.paint.getEndPoint().equals(that.getEndPoint())) {
            return false;
        }
        if (!Arrays.equals(this.paint.getColors(), that.getColors())) {
            return false;
        }
        return Arrays.equals(this.paint.getFractions(), that.getFractions());
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.paint.getStartPoint().hashCode();
        hash = 47 * hash + this.paint.getEndPoint().hashCode();
        hash = 47 * hash + Arrays.hashCode(this.paint.getColors());
        hash = 47 * hash + Arrays.hashCode(this.paint.getFractions());
        return hash;
    }
}

