/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableConfigurationInvocationHandler;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventSource;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.sync.NoOpSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigurationUtils {
    private static final String METHOD_CLONE = "clone";
    private static final Class<?>[] IMMUTABLE_CONFIG_IFCS = new Class[]{ImmutableConfiguration.class};
    private static final Class<?>[] IMMUTABLE_HIERARCHICAL_CONFIG_IFCS = new Class[]{ImmutableHierarchicalConfiguration.class};
    private static final EventSource DUMMY_EVENT_SOURCE = new EventSource(){

        @Override
        public <T extends Event> void addEventListener(EventType<T> eventType, EventListener<? super T> listener) {
        }

        @Override
        public <T extends Event> boolean removeEventListener(EventType<T> eventType, EventListener<? super T> listener) {
            return false;
        }
    };
    private static final Log LOG = LogFactory.getLog(ConfigurationUtils.class);

    public static void append(Configuration source, Configuration target) {
        ConfigurationUtils.append((ImmutableConfiguration)source, target);
    }

    public static void append(ImmutableConfiguration source, Configuration target) {
        source.forEach(target::addProperty);
    }

    public static EventSource asEventSource(Object obj, boolean mockIfUnsupported) {
        if (obj instanceof EventSource) {
            return (EventSource)obj;
        }
        if (!mockIfUnsupported) {
            throw new ConfigurationRuntimeException("Cannot cast to EventSource: " + obj);
        }
        return DUMMY_EVENT_SOURCE;
    }

    static <T> T clone(T obj) throws CloneNotSupportedException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Cloneable) {
            try {
                return (T)obj.getClass().getMethod(METHOD_CLONE, new Class[0]).invoke(obj, new Object[0]);
            }
            catch (NoSuchMethodException nmex) {
                throw new CloneNotSupportedException("No clone() method found for class" + obj.getClass().getName());
            }
            catch (IllegalAccessException | InvocationTargetException itex) {
                throw new ConfigurationRuntimeException(itex);
            }
        }
        throw new CloneNotSupportedException(obj.getClass().getName() + " does not implement Cloneable");
    }

    public static Configuration cloneConfiguration(Configuration config) throws ConfigurationRuntimeException {
        try {
            return ConfigurationUtils.clone(config);
        }
        catch (CloneNotSupportedException cnex) {
            throw new ConfigurationRuntimeException(cnex);
        }
    }

    public static Object cloneIfPossible(Object obj) {
        try {
            return ConfigurationUtils.clone(obj);
        }
        catch (Exception ex) {
            return obj;
        }
    }

    public static Synchronizer cloneSynchronizer(Synchronizer sync) {
        if (sync == null) {
            throw new IllegalArgumentException("Synchronizer must not be null!");
        }
        if (NoOpSynchronizer.INSTANCE == sync) {
            return sync;
        }
        try {
            return (Synchronizer)sync.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ignore) {
            try {
                return ConfigurationUtils.clone(sync);
            }
            catch (CloneNotSupportedException e) {
                throw new ConfigurationRuntimeException("Cannot clone Synchronizer " + sync);
            }
        }
    }

    public static HierarchicalConfiguration<?> convertToHierarchical(Configuration conf) {
        return ConfigurationUtils.convertToHierarchical(conf, null);
    }

    public static HierarchicalConfiguration<?> convertToHierarchical(Configuration conf, ExpressionEngine engine) {
        if (conf == null) {
            return null;
        }
        if (conf instanceof HierarchicalConfiguration) {
            HierarchicalConfiguration hc = (HierarchicalConfiguration)conf;
            if (engine != null) {
                hc.setExpressionEngine(engine);
            }
            return hc;
        }
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        if (engine != null) {
            hc.setExpressionEngine(engine);
        }
        hc.copy(conf);
        return hc;
    }

    public static void copy(Configuration source, Configuration target) {
        ConfigurationUtils.copy((ImmutableConfiguration)source, target);
    }

    public static void copy(ImmutableConfiguration source, Configuration target) {
        source.forEach(target::setProperty);
    }

    private static ImmutableConfiguration createUnmodifiableConfiguration(Class<?>[] ifcs, Configuration c) {
        return (ImmutableConfiguration)Proxy.newProxyInstance(ConfigurationUtils.class.getClassLoader(), ifcs, (InvocationHandler)new ImmutableConfigurationInvocationHandler(c));
    }

    public static void dump(Configuration configuration, PrintStream out) {
        ConfigurationUtils.dump((ImmutableConfiguration)configuration, out);
    }

    public static void dump(Configuration configuration, PrintWriter out) {
        ConfigurationUtils.dump((ImmutableConfiguration)configuration, out);
    }

    public static void dump(ImmutableConfiguration configuration, PrintStream out) {
        ConfigurationUtils.dump(configuration, new PrintWriter(out));
    }

    public static void dump(ImmutableConfiguration configuration, PrintWriter out) {
        AtomicInteger last = new AtomicInteger(configuration.size());
        configuration.forEach((k, v) -> {
            out.print((String)k);
            out.print("=");
            out.print(v);
            if (last.decrementAndGet() > 0) {
                out.println();
            }
        });
        out.flush();
    }

    public static void enableRuntimeExceptions(Configuration src) {
        if (!(src instanceof EventSource)) {
            throw new IllegalArgumentException("Configuration must implement EventSource!");
        }
        ((EventSource)((Object)src)).addEventListener(ConfigurationErrorEvent.ANY, event -> {
            throw new ConfigurationRuntimeException(event.getCause());
        });
    }

    public static Class<?> loadClass(String clsName) throws ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading class " + clsName);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            if (cl != null) {
                return cl.loadClass(clsName);
            }
        }
        catch (ClassNotFoundException cnfex) {
            LOG.info("Could not load class " + clsName + " using CCL. Falling back to default CL.", cnfex);
        }
        return ConfigurationUtils.class.getClassLoader().loadClass(clsName);
    }

    public static Class<?> loadClassNoEx(String clsName) {
        try {
            return ConfigurationUtils.loadClass(clsName);
        }
        catch (ClassNotFoundException cnfex) {
            throw new ConfigurationRuntimeException("Cannot load class " + clsName, cnfex);
        }
    }

    public static String toString(Configuration configuration) {
        return ConfigurationUtils.toString((ImmutableConfiguration)configuration);
    }

    public static String toString(ImmutableConfiguration configuration) {
        StringWriter writer = new StringWriter();
        ConfigurationUtils.dump(configuration, new PrintWriter(writer));
        return writer.toString();
    }

    public static ImmutableConfiguration unmodifiableConfiguration(Configuration c) {
        return ConfigurationUtils.createUnmodifiableConfiguration(IMMUTABLE_CONFIG_IFCS, c);
    }

    public static ImmutableHierarchicalConfiguration unmodifiableConfiguration(HierarchicalConfiguration<?> c) {
        return (ImmutableHierarchicalConfiguration)ConfigurationUtils.createUnmodifiableConfiguration(IMMUTABLE_HIERARCHICAL_CONFIG_IFCS, c);
    }

    private ConfigurationUtils() {
    }
}

