---
stage: Security Risk Management
group: Security Policies
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ポリシー
description: セキュリティポリシー、適用、コンプライアンス、承認、スキャン。
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ポリシーを使用すると、セキュリティチームおよびコンプライアンスチームは、組織全体にコントロールを適用できます。

セキュリティチームは、次のことを確実に行えます。

- 適切な設定で、開発チームのパイプラインにセキュリティスキャナーを適用する。
- すべてのスキャンジョブを、変更または改変なしに実行する。
- スキャン結果に基づき、マージリクエストに対して適切な承認を行う。
- 検出されなくなった脆弱性を自動的に解決し、脆弱性のトリアージ作業のワークロードを軽減する。

コンプライアンスチームは、次のことを行えます。

- すべてのマージリクエストに複数の承認者を適用する。
- 組織の要件に基づいたプロジェクト設定（マージリクエストの設定またはリポジトリの設定の有効化やロックなど）を適用する。

次のポリシータイプを使用できます。

- [スキャン実行ポリシー](scan_execution_policies.md)。パイプラインの一部として、または指定されたスケジュールに従ってセキュリティスキャンを強制的に実行します。
- [マージリクエスト承認ポリシー](merge_request_approval_policies.md)。スキャン結果に基づいて、プロジェクトレベルの設定と承認ルールを強制的に適用します。
- [パイプライン実行ポリシー](pipeline_execution_policies.md)。プロジェクトのパイプラインの一部としてCI/CDジョブを強制的に実行します。
  - [スケジュールされたパイプライン実行ポリシー（実験的機能）](scheduled_pipeline_execution_policies.md)。コミットアクティビティとは関係なく、スケジュールされたケイデンスでプロジェクト全体にカスタムCI/CDジョブを強制的に実行します。
- [脆弱性管理ポリシー](vulnerability_management_policy.md)。デフォルトブランチで検出されなくなった脆弱性を自動的に解決します。

複数のプロジェクトにわたってポリシーを適用するには、[セキュリティポリシープロジェクト](security_policy_projects.md)を使用します。セキュリティポリシープロジェクトは、ポリシーのみを格納するための特別なタイプのプロジェクトです。セキュリティポリシープロジェクトのポリシーを他のグループやプロジェクトに適用するには、グループまたは他のプロジェクトからセキュリティポリシープロジェクトにリンクします。

## ポリシー設計ガイドライン {#policy-design-guidelines}

ポリシーを設計するときの目標は次のとおりです。

- 適用した際に最小限のオーバーヘッドで最大限のカバレッジが得られるようにポリシーを設計する
- 職務分離を確保する

### 適用 {#enforcement}

要件を満たすようにポリシーを適用するには、次の要素を考慮します。

- **継承**: デフォルトでは、ポリシーは、リンクされている組織単位、およびそのすべての子孫サブグループとそのプロジェクトに適用されます。
- **スコープ**: 要件に合わせてポリシーのスコープを定義し、ポリシーの適用をカスタマイズできます。
- **セキュリティポリシーの一元管理**: GitLab Self-Managedインスタンス管理者は、一元管理された場所から複数のグループとプロジェクトにセキュリティポリシーを適用するために、コンプライアンスとセキュリティポリシー（CSP）グループを指定できます。詳細については、[セキュリティポリシーの一元管理](centralized_security_policy_management.md)を参照してください。

#### 継承 {#inheritance}

ポリシーのカバレッジを最大化するには、目標達成が求められる最上位の組織単位（グループ、サブグループ、またはプロジェクト）にセキュリティポリシープロジェクトをリンクします。ポリシーは、リンクされている組織単位、およびそのすべての子孫サブグループとそのプロジェクトに適用されます。最上位の組織単位に適用することで、必要なセキュリティポリシーの数を最小限に抑え、管理のオーバーヘッドを削減できます。

ポリシーの継承を使用して、ポリシーを段階的にロールアウトできます。たとえば、新しいポリシーをロールアウトする場合、1つのプロジェクトにそのポリシーを適用し、テストを実施できます。テストに成功したら、そのポリシーをプロジェクトから削除し、次にグループに適用するといった具合に階層を上げていき、最終的にすべての該当プロジェクトに適用します。

既存のグループまたはサブグループに適用されるポリシーは、その下に新しく作成されたサブグループとプロジェクトにも自動的に適用されます。ただし、以下のすべての条件を満たす場合に限ります。

- 新しいサブグループおよびプロジェクトがポリシーのスコープ定義に含まれている（たとえば、スコープにこのグループのすべてのプロジェクトが含まれている）。
- 既存のグループまたはサブグループがすでにセキュリティポリシープロジェクトにリンクされている。

{{< alert type="note" >}}

GitLab.comユーザーは、自分のトップレベルグループまたはサブグループ全体にポリシーを適用できますが、GitLab.comの複数のトップレベルグループにまたがってポリシーを適用することはできません。GitLab Self-Managed管理者は、インスタンス内の複数のトップレベルグループにまたがってポリシーを適用できます。

{{< /alert >}}

次の例は、2つのグループとその構造を示しています。

- Alphaグループには2つのサブグループが含まれており、各サブグループには複数のプロジェクトが含まれています。
- セキュリティとコンプライアンスグループには2つのポリシーが含まれています。

**Alpha**グループ（コードプロジェクトを含む）

- **財務**（サブグループ）
  - プロジェクトA
  - 受取勘定（サブグループ）
    - プロジェクトB
    - プロジェクトC
- **エンジニアリング**（サブグループ）
  - プロジェクトK
  - プロジェクトL
  - プロジェクトM

**セキュリティとコンプライアンス**グループ（セキュリティポリシープロジェクトを含む）

- セキュリティポリシー管理
- セキュリティポリシー管理 - セキュリティポリシープロジェクト
  - SASTポリシー
  - シークレット検出ポリシー

ポリシーが適用されていないと仮定して、次の例を考えてみましょう。

- 「SAST」ポリシーがグループAlphaに適用されている場合、そのサブグループである「財務」と「エンジニアリング」、およびそれらのすべてのプロジェクトとサブグループに適用されます。「シークレット検出」ポリシーがサブグループ「受取勘定」でも適用されている場合、「SAST」と「シークレット検出」両方のポリシーがプロジェクトBとCに適用されます。ただし、プロジェクトAには「SAST」ポリシーのみが適用されます。
- 「SAST」ポリシーがサブグループ「受取勘定」に適用されている場合、プロジェクトBとCのみに適用されます。プロジェクトAに「SAST」ポリシーは適用されません。
- 「シークレット検出」ポリシーがプロジェクトKで適用されている場合、プロジェクトKのみに適用されます。他のサブグループまたはプロジェクトに「シークレット検出」ポリシーは適用されません。

#### スコープ {#scope}

{{< history >}}

- GitLab 16.7で、`security_policies_policy_scope`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135398)されました。デフォルトでは有効になっています。
- GitLab 16.11で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/443594)になりました。機能フラグ`security_policies_policy_scope`は削除されました。
- グループによるスコーピングは、GitLab 17.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/468384)されました。

{{< /history >}}

ポリシーのスコープは、次の方法で絞り込むことができます。

- コンプライアンスフレームワーク: 選択したコンプライアンスフレームワークを持つプロジェクトにポリシーを適用します。
- グループ:
  - グループ内のすべてのプロジェクト。すべての子孫サブグループとそのプロジェクトを含みます。オプションで、特定のプロジェクトを除外できます。
  - 複数のグループ内のすべてのプロジェクト。それらの子孫サブグループとそのプロジェクトを含みます。同じセキュリティポリシープロジェクトにリンクされているグループのみ、ポリシーの対象として列挙できます。オプションで、特定のプロジェクトを除外できます。
- プロジェクト: 特定のプロジェクトを含めるか除外します。同じセキュリティポリシープロジェクトにリンクされているプロジェクトのみ、ポリシーの対象として列挙できます。

これらのオプションは、同じポリシー内で組み合わせて使用​​できます。ただし、除外が包含よりも優先されます。

##### `policy_scope`キーワード {#policy_scope-keyword}

`policy_scope`キーワードを使用して、指定したグループ、プロジェクト、コンプライアンスフレームワーク、またはそれらの組み合わせに対してのみポリシーを適用します。

| フィールド                   | 型     | 使用可能な値          | 説明 |
|-------------------------|----------|--------------------------|-------------|
| `compliance_frameworks` | `array`  | 該当なし           | スコープ内のコンプライアンスフレームワークのIDを、キー`id`を持つオブジェクトの配列でリストします。 |
| `projects`              | `object` | `including`、`excluding` | `excluding:`または`including:`を使用して、含めるまたは除外するプロジェクトのIDを、キー`id`を持つオブジェクトの配列でリストします。 |
| `groups`                | `object` | `including`              | `including:`を使用して、含めるグループのIDを、キー`id`を持つオブジェクトの配列でリストします。同じセキュリティポリシープロジェクトにリンクされているグループのみ、ポリシーの対象として列挙できます。 |

##### スコープの例 {#scope-examples}

次の例では、スキャン実行ポリシーは、IDが`2`または`11`のコンプライアンスフレームワークが適用されたすべてのプロジェクトのすべてのリリースパイプラインでSASTスキャンを強制的に実行します。

```yaml
---
scan_execution_policy:
- name: Enforce specified scans in every release pipeline
  description: This policy enforces a SAST scan for release branches
  enabled: true
  rules:
  - type: pipeline
    branches:
    - release/*
  actions:
  - scan: sast
  policy_scope:
    compliance_frameworks:
      - id: 2
      - id: 11
```

次の例では、スキャン実行ポリシーは、IDが`203`のグループ（すべての子孫サブグループとそのプロジェクトを含む）内のすべてのプロジェクトのデフォルトブランチのパイプラインで、シークレット検出とSASTスキャンを強制的に実行します。ただし、IDが`64`のプロジェクトは除外されます。

```yaml
- name: Enforce specified scans in every default branch pipeline
  description: This policy enforces Secret Detection and SAST scans for the default branch
  enabled: true
  rules:
  - type: pipeline
    branches:
    - main
  actions:
  - scan: secret_detection
  - scan: sast
  policy_scope:
    groups:
      including:
        - id: 203
    projects:
      excluding:
        - id: 64
```

### 職務分離 {#separation-of-duties}

ポリシーの正常な実装のためには、職務分離が不可欠です。必要なコンプライアンス要件とセキュリティ要件を満たすポリシーを実装すると同時に、開発チームが目標を達成できるようにします。

セキュリティチームとコンプライアンスチーム:

- ポリシーの定義を担当し、開発チームと協力してポリシーが開発チームの要件を満たすようにする必要があります。

開発チーム:

- いかなる方法でもポリシーを無効化、変更、または回避できないようにする必要があります。

グループ、サブグループ、またはプロジェクトでセキュリティポリシープロジェクトを適用するには、次のいずれかが必要です。

- そのグループ、サブグループ、またはプロジェクトにおけるオーナーロール。
- そのグループ、サブグループ、またはプロジェクトにおける`manage_security_policy_link`権限を持つ[カスタムロール](../../custom_roles/_index.md)。

オーナーロール、および`manage_security_policy_link`権限を持つカスタムロールは、グループ、サブグループ、プロジェクト全体で標準の階層ルールに従います。

| 組織単位 | グループオーナーまたはグループの`manage_security_policy_link`権限 | サブグループオーナーまたはサブグループの`manage_security_policy_link`権限 | プロジェクトオーナーまたはプロジェクトの`manage_security_policy_link`権限 |
|-------------------|---------------------------------------------------------------|---------------------------------------------------------------------|-------------------------------------------------------------------|
| グループ             | {{< icon name="check-circle" >}}適用                          | {{< icon name="dotted-circle" >}}対象外                                | {{< icon name="dotted-circle" >}}対象外                              |
| サブグループ          | {{< icon name="check-circle" >}}適用                          | {{< icon name="check-circle" >}}適用                                | {{< icon name="dotted-circle" >}}対象外                              |
| プロジェクト           | {{< icon name="check-circle" >}}適用                          | {{< icon name="check-circle" >}}適用                                | {{< icon name="check-circle" >}}適用                              |

#### 必要な権限 {#required-permissions}

セキュリティポリシーを作成および管理するには:

- グループに適用されるポリシーの場合: グループのメンテナーロール以上を持っている必要があります。
- プロジェクトに適用されるポリシーの場合:
  - プロジェクトのオーナーである必要があります。
  - グループ内でプロジェクトを作成する権限を持つグループメンバーである必要があります。

{{< alert type="note" >}}

グループメンバーでない場合、プロジェクトのポリシーの追加や編集が制限されることがあります。ポリシーを作成および管理するには、グループ内でプロジェクトを作成する権限が必要です。プロジェクトレベルのポリシーを扱う場合でも、グループ内で必要な権限を持っていることを確認してください。

{{< /alert >}}

## ポリシーの推奨事項 {#policy-recommendations}

ポリシーを実装する際は、次の推奨事項を考慮してください。

### ブランチ名 {#branch-names}

ポリシーでブランチ名を指定する場合は、個々のブランチ名ではなく、**デフォルトブランチ**や**すべての保護ブランチ**など、保護ブランチの汎用的なカテゴリを使用します。

ポリシーは、指定されたブランチがそのプロジェクト内に存在する場合にのみ、プロジェクトに適用されます。たとえば、ポリシーで`main`ブランチにルールを適用していても、スコープ内の一部のプロジェクトが`production`をデフォルトブランチとして使用している場合、そのプロジェクトにはポリシーは適用されません。

### プッシュルール {#push-rules}

GitLab 17.3以前では、プッシュルールを使用して[ブランチ名を検証する](../../project/repository/push_rules.md#validate-branch-names)場合、プレフィックス`update-policy-`を付けたブランチが作成可能であることを確認してください。このブランチ名のプレフィックスは、セキュリティポリシーの作成や修正時に使用されます。例: `update-policy-1659094451`（`1659094451`はタイムスタンプ）。プッシュルールがこのブランチの作成をブロックした場合、次のエラーが発生します。

> Branch name `update-policy-<timestamp>` does not follow the pattern `<branch_name_regex>`.

[GitLab 17.4以降](https://gitlab.com/gitlab-org/gitlab/-/issues/463064)では、セキュリティポリシープロジェクトは、ブランチ名の検証を強制するプッシュルールから除外されます。

### セキュリティポリシープロジェクト {#security-policy-projects}

セキュリティポリシープロジェクトで、非公開にしておきたい機密情報が漏洩するのを防ぐため、セキュリティポリシープロジェクトを他のプロジェクトにリンクする際は、次の点に注意してください。

- セキュリティポリシープロジェクトに機密情報を含めない。
- 非公開のセキュリティポリシープロジェクトをリンクする前に、対象プロジェクトのメンバーリストを確認し、全員がポリシーの内容にアクセス可能になっても問題がないことを確かめる。
- リンク先プロジェクトの表示レベルを評価する。
- [セキュリティポリシー管理](../../compliance/audit_event_types.md#security-policy-management)の監査ログを使用して、プロジェクトのリンクを監視する。

これらの推奨事項は、次の要因による機密情報の漏洩を防ぎます。

- 表示レベルの共有: 非公開のセキュリティプロジェクトが別のプロジェクトにリンクされている場合、リンクされたプロジェクトの**セキュリティポリシー**ページへのアクセス権を持つユーザーは、`.gitlab/security-policies/policy.yml`ファイルの内容を閲覧できます。これには、非公開のセキュリティポリシープロジェクトを公開プロジェクトにリンクする場合も含まれます。これにより、公開プロジェクトにアクセスできるすべてのユーザーにポリシーの内容が公開される可能性があります。
- アクセス制御: 非公開のセキュリティプロジェクトがリンクされているプロジェクトのすべてのメンバーは、元の非公開リポジトリへのアクセス権がない場合でも、**ポリシー**ページでポリシーファイルを閲覧できます。

### セキュリティとコンプライアンスの制御 {#security-and-compliance-controls}

プロジェクトメンテナーによって作成されたプロジェクトのポリシーが、グループのポリシーの実行を妨げる可能性があります。グループのポリシーを変更できるユーザーを制限し、コンプライアンス要件を確実に満たすために、重要なセキュリティまたはコンプライアンスの制御を実装する際は、次の点に注意してください。

- カスタムロールを使用して、プロジェクトレベルでパイプライン実行ポリシーを作成または変更できるユーザーを制限する。
- セキュリティポリシープロジェクトのデフォルトブランチに対して保護ブランチを設定し、直接プッシュを防止する。
- セキュリティポリシープロジェクトでマージリクエスト承認ルールを設定し、指定された承認者からのレビューを必須にする。
- グループとプロジェクトの両方のポリシーで、すべてのポリシーの変更を監視およびレビューする。

## ポリシー管理 {#policy-management}

ポリシーページでは、利用可能なすべての環境にデプロイされたポリシーを表示できます。次の手順により、ポリシーの情報（説明や適用状況など）を確認したり、デプロイされたポリシーを作成または編集したりできます。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ > ポリシー**を選択します。

![ポリシーリストページ](img/policies_list_v17_7.png)

最初の列の緑色のチェックマークは、ポリシーが有効であり、そのスコープ内のすべてのグループとプロジェクトに適用されていることを示します。灰色のチェックマークは、そのポリシーが現在無効であることを示します。

## ポリシーエディタ {#policy-editor}

ポリシーエディタを使用して、ポリシーを作成、編集、削除できます。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ > ポリシー**を選択します。
   - 新しいポリシーを作成するには、**ポリシー**ページのヘッダーにある**新規ポリシー**を選択します。次に、作成するポリシーのタイプを選択します。
   - 既存のポリシーを編集するには、選択したポリシードロワーで**ポリシーを編集**を選択します。

   ポリシーエディタには、次の2つのモードがあります。

   - 視覚的な**ルールモード**では、ルールブロックと関連するコントロールを使用して、ポリシールールを構築およびプレビューできます。

     ![ポリシーエディタのルールモード](img/policy_rule_mode_v15_9.png)

   - **YAMLモード**では、`.yaml`形式でポリシー定義を入力できます。これは、エキスパートユーザーを対象としており、ルールモードではサポートされていないケースに対応できます。

     ![ポリシーエディタのYAMLモード](img/policy_yaml_mode_v15_9.png)

     どちらのモードも、いつでも相互に切り替えることができます。ただし、YAMLリソースが不正確だったり、ルールモードでサポートされていないデータが含まれていたりする場合、ルールモードは自動的に無効になります。YAMLリソースが不正確な場合、ルールモードで再び使用できるようにするには、YAMLモードでポリシーを修正する必要があります。

1. **マージリクエスト経由で設定**を選択して変更を保存し、適用します。

   ポリシーのYAMLが検証され、その結果発生したエラーが表示されます。

1. 生成されたマージリクエストを確認してマージします。

   プロジェクトのオーナーであり、セキュリティポリシープロジェクトがこのプロジェクトに関連付けられていない場合、マージリクエストの作成時にセキュリティポリシープロジェクトが作成され、このプロジェクトにリンクされます。

### `policy.yml`のIDに注釈を付ける {#annotate-ids-in-policyyml}

{{< details >}}

ステータス: 実験的機能

{{< /details >}}

{{< history >}}

- GitLab 18.1で、`policy.yml`ファイルで`annotate_ids`オプションを定義して、[実験的機能](../../../policy/development_stages_support.md)として[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/497774)されました。

{{< /history >}}

`policy.yml`ファイルを簡素化するために、GitLabでは、プロジェクトID、グループID、ユーザーID、コンプライアンスフレームワークIDなどのIDの後にコメントを自動的に付加できます。この注釈により、ユーザーが各IDの意味や由来を識別しやすくなり、`policy.yml`ファイルの内容の把握と管理が容易になります。

この実験的機能を有効にするには、セキュリティポリシープロジェクトの`.gitlab/security-policies/policy.yml`ファイルで、`experiments`セクションに`annotate_ids`セクションを追加します。

```yaml
experiments:
  annotate_ids:
    enabled: true
```

このオプションを有効にすると、GitLab[ポリシーエディタ](#policy-editor)でセキュリティポリシーを変更した際に、`policy.yml`ファイル内のIDの横に注釈コメントが作成されます。

{{< alert type="note" >}}

注釈を適用するには、ポリシーエディタを使用する必要があります。`policy.yml`ファイルを手動で編集した場合（たとえば、Gitコミットを使用）、注釈は適用されません。

{{< /alert>}}

次に例を示します。

```yaml
# Example policy.yml with annotated IDs
approval_policy:
- name: Your policy name
  # ... other policy fields ...
  policy_scope:
    projects:
      including:
      - id: 361 # my-group/my-project
  actions:
  - type: require_approval
    approvals_required: 1
    user_approvers_ids:
    - 75 # jane.doe
    group_approvers_ids:
    - 203 # security-approvers
```

{{< alert type="note" >}}

初回の注釈の適用時には、GitLabは`policy.yml`ファイル内のすべてのID（編集していないポリシー内のIDを含む）に対して注釈を作成します。

{{< /alert >}}

## トラブルシューティング {#troubleshooting}

セキュリティポリシーを扱う場合は、次のトラブルシューティングのヒントを考慮してください。

- セキュリティポリシープロジェクトを、開発プロジェクトと、開発プロジェクトが属するグループまたはサブグループの両方にリンクしないでください。両方にリンクすると、マージリクエスト承認ポリシーからの承認ルールが、開発プロジェクトのマージリクエストに適用されなくなります。
- マージリクエスト承認ポリシーを作成する場合、[`scan_finding`ルール](merge_request_approval_policies.md#scan_finding-rule-type)内の配列`severity_levels`や配列`vulnerability_states`を空にしないでください。ルールを正常に機能させるには、各配列に少なくとも1つのエントリが必要です。
- プロジェクトのオーナーは、そのプロジェクトに対してポリシーを適用できますが、グループ内でプロジェクトを作成する権限も持っている必要があります。グループメンバーではないプロジェクトオーナーは、ポリシーの追加または編集が制限される場合があります。プロジェクトのポリシーを管理できない場合は、グループ管理者に問い合わせて、グループ内で必要な権限が自分に付与されているかを確認してください。

それでも問題が発生する場合は、[最近報告されたバグを確認](https://gitlab.com/gitlab-org/gitlab/-/issues/?sort=popularity&state=opened&label_name%5B%5D=group%3A%3Asecurity%20policies&label_name%5B%5D=type%3A%3Abug&first_page_size=20)し、まだ報告されていない場合は新しいイシューを作成してください。

### GraphQL APIでポリシーを再同期する {#resynchronize-policies-with-the-graphql-api}

ポリシーが適用されていない、または承認が正しくないなど、いずれかのポリシーに矛盾がある場合は、GraphQL `resyncSecurityPolicies`ミューテーションを使用して、ポリシーの再同期を手動で強制できます。

```graphql
mutation {
  resyncSecurityPolicies(input: { fullPath: "group-or-project-path" }) {
    errors
  }
}
```

`fullPath`には、セキュリティポリシープロジェクトが割り当てられているプロジェクトまたはグループのパスを設定します。
