/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import org.antlr.runtime.Token;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;

public class FeatureMatchExpression
extends Expression {
    private final Token feature;
    private final Expression value;
    private Token comp;

    public FeatureMatchExpression(int sourceStart, int sourceEnd, Token feature, Token comp, Expression value) {
        super(sourceStart, sourceEnd);
        this.feature = feature;
        this.comp = comp;
        this.value = value;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.value != null) {
                this.value.traverse(visitor);
            }
            visitor.endvisit((Expression)this);
        }
    }

    public int getKind() {
        if (this.value == null) {
            return -1;
        }
        return this.value.getKind();
    }

    public Token getFeature() {
        return this.feature;
    }

    public Expression getValue() {
        return this.value;
    }

    public String toString() {
        return this.feature.getText() + (this.comp == null ? "" : this.comp.getText()) + (this.value == null ? "" : this.value.toString());
    }
}

