/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.uima.ruta.ide.core.builder.StringTriple;

public class DescriptorManager {
    private static final boolean CONVERT = false;
    private List<String> typeShortNames = new ArrayList<String>();
    private List<StringTriple> typeTriples = new ArrayList<StringTriple>();
    private Collection<String> importedTypeSystems = new HashSet<String>();
    private Map<String, Collection<StringTriple>> features;
    private Collection<String> importedScripts = new HashSet<String>();
    private Collection<String> importedEngines = new HashSet<String>();
    private Collection<String> importedUimafitEngines = new HashSet<String>();

    public DescriptorManager() {
        this.features = new HashMap<String, Collection<StringTriple>>();
    }

    public void addType(String name, String description, String parent) {
        if (parent == null) {
            parent = "uima.tcas.Annotation";
        }
        this.typeShortNames.add(name);
        this.typeTriples.add(new StringTriple(name, description, parent));
    }

    public void addFeature(String type, String name, String description, String parent) {
        Collection<StringTriple> list = this.features.get(type);
        if (list == null) {
            list = new ArrayList<StringTriple>();
            this.features.put(type, list);
        }
        list.add(new StringTriple(name, description, parent));
    }

    public void addScript(String name, boolean convert) {
        if (convert) {
            name = name.replaceAll("[.]", "/");
        }
        this.importedScripts.add(name);
    }

    public void addEngine(String name, boolean convert) {
        if (convert) {
            name = name.replaceAll("[.]", "/");
        }
        this.importedEngines.add(name);
    }

    public void addUimafitEngine(String name) {
        this.importedUimafitEngines.add(name);
    }

    public void addTypeSystem(String name, boolean convert) {
        if (convert) {
            name = name.replaceAll("[.]", "/");
        }
        this.importedTypeSystems.add(name);
    }

    public void addScript(String name) {
        this.addScript(name, false);
    }

    public void addEngine(String name) {
        this.addEngine(name, false);
    }

    public void addTypeSystem(String name) {
        this.addTypeSystem(name, false);
    }

    public List<String> getTypeShortNames() {
        return this.typeShortNames;
    }

    public List<StringTriple> getTypeTriples() {
        return this.typeTriples;
    }

    public Map<String, Collection<StringTriple>> getFeatures() {
        return this.features;
    }

    public Collection<String> getImportedTypeSystems() {
        return this.importedTypeSystems;
    }

    public Collection<String> getImportedScripts() {
        return this.importedScripts;
    }

    public Collection<String> getImportedEngines() {
        return this.importedEngines;
    }

    public Collection<String> getImportedUimafitEngines() {
        return this.importedUimafitEngines;
    }
}

