/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.Map;
import java.util.Set;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.TypesWithNameSpaces;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SelectTypeDialog
extends AbstractDialog {
    private Text typeNameUI;
    private Table matchingTypesUI;
    private Table nameSpacesUI;
    public String typeName = "error-TypeName-never-set";
    public String nameSpaceName = "error-NameSpaceName-never-set";
    private TypesWithNameSpaces types;

    public SelectTypeDialog(AbstractSection section, TypesWithNameSpaces types) {
        super(section, "Select Type Name", "Select an Existing CAS Type name from the set of defined types");
        this.types = types;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent);
        this.createWideLabel(mainArea, "Type Name:");
        this.typeNameUI = this.newText(mainArea, 4, "Specify the type name");
        this.typeNameUI.addListener(24, (Listener)this);
        this.createWideLabel(mainArea, "Matching Types:");
        this.matchingTypesUI = this.newTable(mainArea, 4);
        ((GridData)this.matchingTypesUI.getLayoutData()).heightHint = 250;
        ((GridData)this.matchingTypesUI.getLayoutData()).minimumHeight = 100;
        this.typeNameUI.addListener(13, (Listener)this);
        this.createWideLabel(mainArea, "NameSpaces:");
        this.nameSpacesUI = this.newTable(mainArea, 4);
        ((GridData)this.nameSpacesUI.getLayoutData()).heightHint = 75;
        ((GridData)this.nameSpacesUI.getLayoutData()).minimumHeight = 40;
        this.displayFilteredTypes("");
        return mainArea;
    }

    private void displayFilteredTypes(String aTypeName) {
        this.matchingTypesUI.setRedraw(false);
        this.matchingTypesUI.removeAll();
        Map.Entry topEntry = null;
        aTypeName = aTypeName.toLowerCase();
        for (Map.Entry entry : this.types.sortedNames.entrySet()) {
            String candidateTypeName = ((String)entry.getKey()).toLowerCase();
            if (!candidateTypeName.startsWith(aTypeName)) continue;
            if (null == topEntry) {
                topEntry = entry;
            }
            TableItem item = new TableItem(this.matchingTypesUI, 0);
            item.setText((String)entry.getKey());
            item.setData(entry);
        }
        if (this.matchingTypesUI.getItemCount() > 0) {
            this.matchingTypesUI.select(0);
            this.displayNameSpacesForSelectedItem(topEntry);
        }
        this.matchingTypesUI.setRedraw(true);
    }

    private void displayNameSpacesForSelectedItem(Map.Entry entry) {
        Set nameSpaces = (Set)entry.getValue();
        this.nameSpacesUI.removeAll();
        for (String nameSpace : nameSpaces) {
            TableItem item = new TableItem(this.nameSpacesUI, 0);
            item.setText(nameSpace);
            item.setData((Object)entry);
        }
        if (this.nameSpacesUI.getItemCount() > 0) {
            this.nameSpacesUI.select(0);
        }
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.typeNameUI && event.type == 24) {
            this.typeName = this.typeNameUI.getText();
            this.displayFilteredTypes(this.typeName);
        } else if (event.widget == this.matchingTypesUI && event.type == 13) {
            this.displayNameSpacesForSelectedItem((Map.Entry)this.matchingTypesUI.getSelection()[0].getData());
        }
        super.handleEvent(event);
    }

    @Override
    public void copyValuesFromGUI() {
        if (0 < this.matchingTypesUI.getSelectionCount()) {
            this.typeName = this.matchingTypesUI.getSelection()[0].getText();
        }
        if (0 < this.nameSpacesUI.getSelectionCount()) {
            this.nameSpaceName = this.nameSpacesUI.getSelection()[0].getText();
        }
    }

    @Override
    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(0 < this.nameSpacesUI.getSelectionCount() && 0 < this.matchingTypesUI.getSelectionCount());
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

