/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.Serializable;
import java.util.Map;
import org.apache.openejb.AppContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.threads.impl.ThreadContextProviderUtil;
import org.apache.openejb.util.AppFinder;

public class ApplicationThreadContextProvider
implements ThreadContextProvider,
Serializable {
    public static final ApplicationThreadContextProvider INSTANCE = new ApplicationThreadContextProvider();

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        AppContext appContext = AppFinder.findAppContextOrWeb(Thread.currentThread().getContextClassLoader(), AppFinder.AppContextTransformer.INSTANCE);
        if (appContext == null) {
            return this.clearedContext(props);
        }
        return new ApplicationThreadContextSnapshot(appContext.getId(), ThreadContext.getThreadContext());
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return ThreadContextProviderUtil.NOOP_SNAPSHOT;
    }

    public String getThreadContextType() {
        return "Application";
    }

    public static class ApplicationThreadContextSnapshot
    implements ThreadContextSnapshot,
    Serializable {
        private final Object appId;
        private final ThreadContext threadContext;

        public ApplicationThreadContextSnapshot(Object appId, ThreadContext threadContext) {
            this.appId = appId;
            this.threadContext = threadContext;
        }

        public ThreadContextRestorer begin() {
            if (this.appId == null) {
                return ThreadContextProviderUtil.NOOP_RESTORER;
            }
            AppContext appContext = SystemInstance.get().getComponent(ContainerSystem.class).getAppContext(this.appId);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(appContext.getClassLoader());
            boolean changeThreadContext = this.threadContext != null && this.threadContext != ThreadContext.getThreadContext();
            ThreadContext oldThreadContext = changeThreadContext ? ThreadContext.enter(new ThreadContext(this.threadContext), false) : null;
            return new ApplicationThreadContextRestorer(oldCl, oldThreadContext, changeThreadContext);
        }

        public String toString() {
            return "ApplicationThreadContextSnapshot@" + System.identityHashCode(this) + "{appId=" + this.appId + "{threadContext=" + this.threadContext + "}";
        }
    }

    public static class ApplicationThreadContextRestorer
    implements ThreadContextRestorer {
        private final ClassLoader oldClassLoader;
        private final ThreadContext oldThreadContext;
        private final boolean exitThreadContext;

        public ApplicationThreadContextRestorer(ClassLoader oldClassLoader, ThreadContext oldThreadContext, boolean exitThreadContext) {
            this.oldClassLoader = oldClassLoader;
            this.oldThreadContext = oldThreadContext;
            this.exitThreadContext = exitThreadContext;
        }

        public void endContext() throws IllegalStateException {
            if (this.oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.oldClassLoader);
            }
            if (this.exitThreadContext) {
                ThreadContext.exit(this.oldThreadContext);
            }
        }

        public String toString() {
            return "ApplicationThreadContextRestorer@" + System.identityHashCode(this) + "{oldClassLoader=" + this.oldClassLoader + "{oldThreadContext=" + this.oldThreadContext + "{exitThreadContext=" + this.exitThreadContext + "}";
        }
    }
}

