/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.provisioning.api.data.AnyTypeClassDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class AnyTypeClassLogic
extends AbstractTransactionalLogic<AnyTypeClassTO> {
    protected final AnyTypeClassDataBinder binder;
    protected final AnyTypeClassDAO anyTypeClassDAO;

    public AnyTypeClassLogic(AnyTypeClassDataBinder binder, AnyTypeClassDAO anyTypeClassDAO) {
        this.binder = binder;
        this.anyTypeClassDAO = anyTypeClassDAO;
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_READ')")
    @Transactional(readOnly=true)
    public AnyTypeClassTO read(String key) {
        AnyTypeClass anyTypeClass = (AnyTypeClass)this.anyTypeClassDAO.findById(key).orElseThrow(() -> new NotFoundException("AnyTypeClass " + key));
        return this.binder.getAnyTypeClassTO(anyTypeClass);
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_LIST')")
    @Transactional(readOnly=true)
    public List<AnyTypeClassTO> list() {
        return this.anyTypeClassDAO.findAll().stream().map(arg_0 -> ((AnyTypeClassDataBinder)this.binder).getAnyTypeClassTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_CREATE')")
    public AnyTypeClassTO create(AnyTypeClassTO anyTypeClassTO) {
        if (StringUtils.isBlank((CharSequence)anyTypeClassTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add(AnyTypeClass.class.getSimpleName() + " name");
            throw sce;
        }
        if (this.anyTypeClassDAO.existsById(anyTypeClassTO.getKey())) {
            throw new DuplicateException(anyTypeClassTO.getKey());
        }
        return this.binder.getAnyTypeClassTO((AnyTypeClass)this.anyTypeClassDAO.save((Entity)this.binder.create(anyTypeClassTO)));
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_UPDATE')")
    public AnyTypeClassTO update(AnyTypeClassTO anyTypeClassTO) {
        AnyTypeClass anyTypeClass = (AnyTypeClass)this.anyTypeClassDAO.findById(anyTypeClassTO.getKey()).orElseThrow(() -> new NotFoundException("AnyTypeClass " + anyTypeClassTO.getKey()));
        this.binder.update(anyTypeClass, anyTypeClassTO);
        anyTypeClass = (AnyTypeClass)this.anyTypeClassDAO.save((Entity)anyTypeClass);
        return this.binder.getAnyTypeClassTO(anyTypeClass);
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_DELETE')")
    public AnyTypeClassTO delete(String key) {
        AnyTypeClass anyTypeClass = (AnyTypeClass)this.anyTypeClassDAO.findById(key).orElseThrow(() -> new NotFoundException("AnyTypeClass " + key));
        AnyTypeClassTO deleted = this.binder.getAnyTypeClassTO(anyTypeClass);
        this.anyTypeClassDAO.deleteById(key);
        return deleted;
    }

    @Override
    protected AnyTypeClassTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof AnyTypeClassTO)) continue;
                AnyTypeClassTO anyTypeClassTO = (AnyTypeClassTO)object;
                key = anyTypeClassTO.getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getAnyTypeClassTO((AnyTypeClass)this.anyTypeClassDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

