/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.util.CollectionUtils;

public class AcceptableUsagePolicyStatus
implements Serializable {
    private static final long serialVersionUID = -5552830592634074877L;
    private final TriStateBoolean status;
    private final Principal principal;
    private final MultiValuedMap<String, Object> properties = new ArrayListValuedHashMap(0);

    public static AcceptableUsagePolicyStatus accepted(Principal principal) {
        return new AcceptableUsagePolicyStatus(TriStateBoolean.TRUE, principal);
    }

    public static AcceptableUsagePolicyStatus denied(Principal principal) {
        return new AcceptableUsagePolicyStatus(TriStateBoolean.FALSE, principal);
    }

    public static AcceptableUsagePolicyStatus skipped(Principal principal) {
        return new AcceptableUsagePolicyStatus(TriStateBoolean.UNDEFINED, principal);
    }

    @CanIgnoreReturnValue
    public AcceptableUsagePolicyStatus setProperty(String name, Object value) {
        this.properties.remove((Object)name);
        this.addProperty(name, value);
        return this;
    }

    @CanIgnoreReturnValue
    public AcceptableUsagePolicyStatus clearProperties() {
        this.properties.clear();
        return this;
    }

    @CanIgnoreReturnValue
    public AcceptableUsagePolicyStatus addProperty(String name, Object value) {
        this.properties.put((Object)name, value);
        return this;
    }

    public Collection<Object> getProperty(String name) {
        return this.properties.get((Object)name);
    }

    public Collection<Object> getPropertyOrDefault(String name, Object defaultValue) {
        return this.getPropertyOrDefault(name, CollectionUtils.toCollection((Object)defaultValue));
    }

    public Collection<Object> getPropertyOrDefault(String name, Object ... defaultValues) {
        if (this.properties.containsKey((Object)name)) {
            return this.properties.get((Object)name);
        }
        return Arrays.stream(defaultValues).collect(Collectors.toList());
    }

    public Collection<Object> getPropertyOrDefault(String name, Collection<Object> defaultValues) {
        if (this.properties.containsKey((Object)name)) {
            return this.properties.get((Object)name);
        }
        return defaultValues;
    }

    @JsonIgnore
    public boolean isAccepted() {
        return this.status != null && this.status.isTrue();
    }

    @JsonIgnore
    public boolean isDenied() {
        return this.status != null && this.status.isFalse();
    }

    @Generated
    public AcceptableUsagePolicyStatus(TriStateBoolean status, Principal principal) {
        this.status = status;
        this.principal = principal;
    }

    @Generated
    public TriStateBoolean getStatus() {
        return this.status;
    }

    @Generated
    public Principal getPrincipal() {
        return this.principal;
    }

    @Generated
    public MultiValuedMap<String, Object> getProperties() {
        return this.properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceptableUsagePolicyStatus)) {
            return false;
        }
        AcceptableUsagePolicyStatus other = (AcceptableUsagePolicyStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TriStateBoolean this$status = this.status;
        TriStateBoolean other$status = other.status;
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Principal this$principal = this.principal;
        Principal other$principal = other.principal;
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        MultiValuedMap<String, Object> this$properties = this.properties;
        MultiValuedMap<String, Object> other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AcceptableUsagePolicyStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TriStateBoolean $status = this.status;
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Principal $principal = this.principal;
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        MultiValuedMap<String, Object> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AcceptableUsagePolicyStatus(status=" + String.valueOf(this.status) + ", principal=" + String.valueOf(this.principal) + ", properties=" + String.valueOf(this.properties) + ")";
    }
}

