/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import com.fasterxml.jackson.databind.json.JsonMapper;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.Realm;
import org.apache.syncope.client.console.panels.RealmChoicePanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.tasks.TemplatesTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.any.ResultPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Realms
extends BasePage {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    public static final String SELECTED_INDEX = "selectedIndex";
    public static final String INITIAL_REALM = "initialRealm";
    @SpringBean
    protected RealmRestClient realmRestClient;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final TemplatesTogglePanel templates = new TemplatesTogglePanel("content", (MarkupContainer)this, this.getPageReference()){
        private static final long serialVersionUID = 4828350561653999922L;

        @Override
        protected Serializable onApplyInternal(TemplatableTO targetObject, String type, AnyTO anyTO) {
            targetObject.getTemplates().put(type, anyTO);
            Realms.this.realmRestClient.update((RealmTO)RealmTO.class.cast(targetObject));
            return targetObject;
        }
    };
    protected final RealmChoicePanel realmChoicePanel;
    protected final WebMarkupContainer content;
    protected final BaseModal<RealmTO> modal;
    protected final BaseModal<Serializable> templateModal;

    public Realms(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build("dashboard", "dashboardBr", Dashboard.class)});
        this.content = new WebMarkupContainer("content");
        this.body.add(new Component[]{this.content.setOutputMarkupId(true)});
        this.realmChoicePanel = this.buildRealmChoicePanel(parameters.get(INITIAL_REALM).toOptionalString(), this.getPageReference());
        this.content.add(new Component[]{this.realmChoicePanel});
        this.content.add(new Component[]{new Label("body", (Serializable)((Object)"Root realm"))});
        this.modal = new BaseModal("modal");
        this.modal.size(Modal.Size.Large);
        this.content.add(new Component[]{this.modal});
        this.content.add(new Component[]{this.templates});
        this.templateModal = new BaseModal<Serializable>("templateModal"){
            private static final long serialVersionUID = 5787433530654262016L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.templateModal.size(Modal.Size.Extra_large);
        this.content.add(new Component[]{this.templateModal});
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            target.add(new Component[]{this.realmChoicePanel.reloadRealmTree(target)});
            target.add(new Component[]{this.content});
            this.modal.show(false);
        });
        this.templateModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            target.add(new Component[]{this.content});
            this.templateModal.show(false);
        });
        this.updateRealmContent(this.realmChoicePanel.getCurrentRealm(), parameters.get(SELECTED_INDEX).toInt(0));
    }

    protected RealmChoicePanel buildRealmChoicePanel(String initialRealm, PageReference pageRef) {
        RealmChoicePanel panel = new RealmChoicePanel("realmChoicePanel", initialRealm, this.realmRestClient, pageRef);
        panel.setOutputMarkupId(true);
        return panel;
    }

    public RealmChoicePanel getRealmChoicePanel() {
        return this.realmChoicePanel;
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof RealmChoicePanel.ChosenRealm) {
            RealmChoicePanel.ChosenRealm choosenRealm = (RealmChoicePanel.ChosenRealm)RealmChoicePanel.ChosenRealm.class.cast(event.getPayload());
            this.updateRealmContent((RealmTO)choosenRealm.getObj(), 0);
            choosenRealm.getTarget().add(new Component[]{this.content});
        } else {
            Object choosenRealm = event.getPayload();
            if (choosenRealm instanceof AjaxWizard.NewItemEvent) {
                AjaxWizard.NewItemEvent newItemEvent = (AjaxWizard.NewItemEvent)choosenRealm;
                WizardModalPanel modalPanel = newItemEvent.getModalPanel();
                if (event.getPayload() instanceof AjaxWizard.NewItemActionEvent && modalPanel != null) {
                    CompoundPropertyModel model = new CompoundPropertyModel((Object)modalPanel.getItem());
                    this.templateModal.setFormModel((IModel<Serializable>)model);
                    this.templateModal.header(newItemEvent.getTitleModel());
                    newItemEvent.getTarget().ifPresent(t -> t.add(new Component[]{this.templateModal.setContent((ModalPanel)modalPanel)}));
                    this.templateModal.show(true);
                } else if (event.getPayload() instanceof AjaxWizard.NewItemCancelEvent) {
                    newItemEvent.getTarget().ifPresent(arg_0 -> this.templateModal.close(arg_0));
                } else if (event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    newItemEvent.getTarget().ifPresent(t -> {
                        ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)t);
                        this.templateModal.close((IPartialPageRequestHandler)t);
                    });
                }
            }
        }
    }

    protected WebMarkupContainer updateRealmContent(RealmTO realmTO, int selectedIndex) {
        if (realmTO != null) {
            this.content.addOrReplace(new Component[]{new Content(realmTO, this.anyTypeRestClient.listAnyTypes(), selectedIndex)});
        }
        return this.content;
    }

    protected class Content
    extends Realm {
        private static final long serialVersionUID = 8221398624379357183L;

        protected Content(RealmTO realmTO, List<AnyTypeTO> anyTypes, int selectedIndex) {
            super("body", realmTO, anyTypes, selectedIndex, Realms.this.getPageReference());
        }

        @Override
        protected void setWindowClosedReloadCallback(BaseModal<?> modal) {
            modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
                ModalPanel patt0$temp = modal.getContent();
                if (patt0$temp instanceof ResultPanel) {
                    ResultPanel rp = (ResultPanel)patt0$temp;
                    RealmTO newRealmTO = (RealmTO)RealmTO.class.cast(((ProvisioningResult)ProvisioningResult.class.cast(rp.getResult())).getEntity());
                    target.add(new Component[]{Realms.this.realmChoicePanel.reloadRealmTree(target, (Model<RealmTO>)Model.of((Serializable)newRealmTO))});
                    Realms.this.realmChoicePanel.setCurrentRealm(newRealmTO);
                    this.send((IEventSink)Realms.this, Broadcast.DEPTH, new RealmChoicePanel.ChosenRealm<RealmTO>(newRealmTO, target));
                } else {
                    target.add(new Component[]{Realms.this.realmChoicePanel.reloadRealmTree(target)});
                }
                target.add(new Component[]{Realms.this.content});
                modal.show(false);
            });
        }

        @Override
        protected void onClickTemplate(AjaxRequestTarget target) {
            Realms.this.templates.setTargetObject((TemplatableTO)this.realmTO);
            Realms.this.templates.toggle(target, true);
        }

        @Override
        protected void onClickCreate(AjaxRequestTarget target) {
            this.wizardBuilder.setParent(Realms.this.realmChoicePanel.getCurrentRealm());
            this.send((IEventSink)this, Broadcast.EXACT, new AjaxWizard.NewItemActionEvent<RealmTO>(this, new RealmTO(), target){

                public String getEventDescription() {
                    return "realm.new";
                }
            });
        }

        @Override
        protected void onClickEdit(AjaxRequestTarget target, RealmTO realmTO) {
            this.send((IEventSink)this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<RealmTO>(this, realmTO, target){

                public String getEventDescription() {
                    return "realm.edit";
                }
            });
        }

        @Override
        protected void onClickAudit(AjaxRequestTarget target, final RealmTO realmTO) {
            target.add(new Component[]{Realms.this.templateModal.setContent(new AuditHistoryModal<RealmTO>(OpEvent.CategoryType.LOGIC, "RealmLogic", realmTO, "REALM_UPDATE", Realms.this.auditRestClient){
                private static final long serialVersionUID = -5819724478921691835L;

                @Override
                protected void restore(String json, AjaxRequestTarget target) {
                    try {
                        RealmTO updated = (RealmTO)MAPPER.readValue(json, RealmTO.class);
                        Content.this.realmRestClient.update(updated);
                        SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        target.add(new Component[]{Realms.this.realmChoicePanel.reloadRealmTree(target)});
                    }
                    catch (Exception e) {
                        LOG.error("While restoring realm {}", (Object)realmTO.getKey(), (Object)e);
                        SyncopeConsoleSession.get().onException(e);
                    }
                    ((BasePage)Content.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            })});
            Realms.this.templateModal.header((IModel)new Model((Serializable)((Object)this.getString("realm.auditHistory.title", (IModel)new Model((Serializable)realmTO)))));
            Realms.this.templateModal.show(true);
        }

        @Override
        protected void onClickDelete(AjaxRequestTarget target, RealmTO realmTO) {
            try {
                if (realmTO.getKey() == null) {
                    throw new Exception("Root realm cannot be deleted");
                }
                this.realmRestClient.delete(realmTO.getFullPath());
                RealmTO parent = Realms.this.realmChoicePanel.moveToParentRealm(realmTO.getKey());
                target.add(new Component[]{Realms.this.realmChoicePanel.reloadRealmTree(target)});
                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                Realms.this.updateRealmContent(parent, this.selectedIndex);
                target.add(new Component[]{Realms.this.content});
            }
            catch (Exception e) {
                LOG.error("While deleting realm", (Throwable)e);
                SyncopeConsoleSession.get().onException(e);
            }
            ((BaseWebPage)Realms.this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }
}

