/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.jexl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class JexlContextBuilder {
    protected static final Logger LOG = LoggerFactory.getLogger(JexlContextBuilder.class);
    private static final String[] IGNORE_FIELDS = new String[]{"password", "clearPassword", "serialVersionUID", "class"};
    private static final Map<Class<?>, Set<Pair<PropertyDescriptor, Field>>> FIELD_CACHE = Collections.synchronizedMap(new HashMap());
    protected final JexlContext jexlContext = new MapContext();

    public JexlContextBuilder with(String name, Object value) {
        this.jexlContext.set(name, value);
        return this;
    }

    public JexlContextBuilder fields(Object object) {
        AnyTO anyTO;
        Any any;
        if (object == null) {
            return this;
        }
        Set<Pair<PropertyDescriptor, Field>> cached = FIELD_CACHE.get(object.getClass());
        if (cached == null) {
            FIELD_CACHE.put(object.getClass(), Collections.synchronizedSet(new HashSet()));
            List classes = ClassUtils.getAllSuperclasses(object.getClass());
            classes.add(object.getClass());
            classes.forEach(clazz -> {
                try {
                    for (PropertyDescriptor desc : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                        if (desc.getName().startsWith("pc") || ArrayUtils.contains((Object[])IGNORE_FIELDS, (Object)desc.getName()) || Collection.class.isAssignableFrom(desc.getPropertyType()) || Map.class.isAssignableFrom(desc.getPropertyType()) || desc.getPropertyType().isArray()) continue;
                        Field field = null;
                        try {
                            field = clazz.getDeclaredField(desc.getName());
                        }
                        catch (NoSuchFieldException | SecurityException e) {
                            LOG.debug("Could not get field {} from {}", new Object[]{desc.getName(), clazz.getName(), e});
                        }
                        FIELD_CACHE.get(object.getClass()).add((Pair<PropertyDescriptor, Field>)Pair.of((Object)desc, (Object)field));
                    }
                }
                catch (IntrospectionException e) {
                    LOG.warn("Could not introspect {}", (Object)clazz.getName(), (Object)e);
                }
            });
            cached = FIELD_CACHE.get(object.getClass());
        }
        cached.forEach(fd -> {
            String fieldName = ((PropertyDescriptor)fd.getLeft()).getName();
            Class<?> fieldType = ((PropertyDescriptor)fd.getLeft()).getPropertyType();
            try {
                Object fieldValue = null;
                if (((PropertyDescriptor)fd.getLeft()).getReadMethod() == null) {
                    if (fd.getRight() != null) {
                        ReflectionUtils.makeAccessible((Field)((Field)fd.getRight()));
                        fieldValue = ((Field)fd.getRight()).get(object);
                    }
                } else {
                    fieldValue = ((PropertyDescriptor)fd.getLeft()).getReadMethod().invoke(object, new Object[0]);
                }
                fieldValue = fieldValue == null ? "" : (TemporalAccessor.class.isAssignableFrom(fieldType) ? FormatUtils.format((TemporalAccessor)((TemporalAccessor)fieldValue)) : fieldValue);
                this.jexlContext.set(fieldName, fieldValue);
                LOG.debug("Add field {} with value {}", (Object)fieldName, fieldValue);
            }
            catch (Exception iae) {
                LOG.error("Reading '{}' value error", (Object)fieldName, (Object)iae);
            }
        });
        if (object instanceof Any && (any = (Any)object).getRealm() != null) {
            this.jexlContext.set("realm", (Object)any.getRealm().getFullPath());
        } else if (object instanceof AnyTO && (anyTO = (AnyTO)object).getRealm() != null) {
            this.jexlContext.set("realm", (Object)anyTO.getRealm());
        } else if (object instanceof Realm) {
            Realm realm = (Realm)object;
            this.jexlContext.set("fullPath", (Object)realm.getFullPath());
        } else if (object instanceof RealmTO) {
            RealmTO realmTO = (RealmTO)object;
            this.jexlContext.set("fullPath", (Object)realmTO.getFullPath());
        }
        return this;
    }

    public JexlContextBuilder attrs(Collection<Attr> attrs) {
        attrs.stream().filter(attr -> attr.getSchema() != null).forEach(attr -> {
            Object value = attr.getValues().isEmpty() ? "" : (attr.getValues().size() == 1 ? attr.getValues().getFirst() : attr.getValues());
            LOG.debug("Add attribute {} with value {}", (Object)attr.getSchema(), value);
            this.jexlContext.set(attr.getSchema(), value);
        });
        return this;
    }

    public JexlContextBuilder plainAttrs(Collection<PlainAttr> attrs) {
        attrs.stream().filter(attr -> attr.getSchema() != null).forEach(attr -> {
            List attrValues = attr.getValuesAsStrings();
            Object value = attrValues.isEmpty() ? "" : (attrValues.size() == 1 ? attrValues.getFirst() : attrValues);
            LOG.debug("Add attribute {} with value {}", (Object)attr.getSchema(), value);
            this.jexlContext.set(attr.getSchema(), value);
        });
        return this;
    }

    public JexlContextBuilder derAttrs(Attributable attributable, DerAttrHandler derAttrHandler) {
        Map<String, String> map;
        if (attributable instanceof Realm) {
            Realm realm = (Realm)attributable;
            map = derAttrHandler.getValues(realm);
        } else if (attributable instanceof Any) {
            Any any = (Any)attributable;
            map = derAttrHandler.getValues(any);
        } else {
            map = Map.of();
        }
        Map<String, String> derAttrs = map;
        derAttrs.forEach((schema, value) -> this.jexlContext.set(schema, value));
        return this;
    }

    public JexlContext build() {
        return this.jexlContext;
    }
}

