/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;
import org.apache.syncope.common.rest.api.beans.RealmQuery;
import org.apache.syncope.common.rest.api.service.RealmService;
import org.apache.syncope.core.logic.RealmLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.data.domain.Page;

public class RealmServiceImpl
extends AbstractService
implements RealmService {
    protected final RealmLogic logic;

    public RealmServiceImpl(RealmLogic logic) {
        this.logic = logic;
    }

    public PagedResult<RealmTO> search(RealmQuery query) {
        Page result = this.logic.search((String)Optional.ofNullable(query.getKeyword()).map(k -> k.replace('*', '%')).orElse(null), query.getBases(), RealmServiceImpl.pageable((AbstractQuery)query));
        return this.buildPagedResult(result);
    }

    public Response create(String parentPath, RealmTO realmTO) {
        ProvisioningResult created = this.logic.create(Strings.CS.prependIfMissing(parentPath, (CharSequence)"/", new CharSequence[0]), realmTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(((RealmTO)created.getEntity()).getName()).build(new Object[0]);
        Response.ResponseBuilder builder = Response.created((URI)location).header("X-Syncope-Key", (Object)((RealmTO)created.getEntity()).getFullPath());
        return this.applyPreference(created, builder).build();
    }

    public Response update(RealmTO realmTO) {
        realmTO.setFullPath(Strings.CS.prependIfMissing(realmTO.getFullPath(), (CharSequence)"/", new CharSequence[0]));
        ProvisioningResult updated = this.logic.update(realmTO);
        return this.modificationResponse(updated);
    }

    public Response delete(String fullPath) {
        ProvisioningResult deleted = this.logic.delete(Strings.CS.prependIfMissing(fullPath, (CharSequence)"/", new CharSequence[0]));
        return this.modificationResponse(deleted);
    }
}

