/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.AbstractTimer;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class DefaultTimer
extends AbstractTimer {
    private final Id id;
    private final AtomicLong count;
    private final AtomicLong totalTime;

    DefaultTimer(Clock clock, Id id) {
        super(clock);
        this.id = id;
        this.count = new AtomicLong(0L);
        this.totalTime = new AtomicLong(0L);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            long nanos = TimeUnit.NANOSECONDS.convert(amount, unit);
            this.totalTime.addAndGet(nanos);
            this.count.incrementAndGet();
        }
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>(2);
        ms.add(new Measurement(this.id.withTag(Statistic.count), now, this.count.get()));
        ms.add(new Measurement(this.id.withTag(Statistic.totalTime), now, this.totalTime.get()));
        return ms;
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public long totalTime() {
        return this.totalTime.get();
    }
}

