/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.tomcat;

import lombok.Generated;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.x509.X509WebflowAutoConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;

public class X509TomcatServletWebServiceFactoryCustomizer
extends ServletWebServerFactoryCustomizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509TomcatServletWebServiceFactoryCustomizer.class);
    private final CasConfigurationProperties casProperties;
    private final ServerProperties serverProperties;

    public X509TomcatServletWebServiceFactoryCustomizer(ServerProperties serverProperties, CasConfigurationProperties casProperties) {
        super(serverProperties);
        this.casProperties = casProperties;
        this.serverProperties = serverProperties;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        X509WebflowAutoConfigurationProperties webflow = this.casProperties.getAuthn().getX509().getWebflow();
        if (factory instanceof TomcatServletWebServerFactory) {
            TomcatServletWebServerFactory tomcat = (TomcatServletWebServerFactory)factory;
            if (webflow.getPort() > 0) {
                LOGGER.debug("Creating X509 configuration for the tomcat container...");
                Connector connector = new Connector("HTTP/1.1");
                connector.setPort(webflow.getPort());
                connector.setScheme("https");
                connector.setSecure(true);
                connector.setAllowTrace(true);
                Long maxPostSize = this.serverProperties.getTomcat().getMaxHttpFormPostSize().toBytes();
                connector.setMaxPostSize(maxPostSize.intValue());
                LOGGER.debug("Configured max post size for the tomcat connector on port [{}] to be [{}]", (Object)webflow.getPort(), (Object)maxPostSize);
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)connector.getProtocolHandler();
                protocol.setSSLEnabled(true);
                Long maxHeaderSize = this.serverProperties.getMaxHttpRequestHeaderSize().toBytes();
                protocol.setMaxHttpRequestHeaderSize(maxHeaderSize.intValue());
                LOGGER.debug("Configured max request header size for the tomcat connector on port [{}] to be [{}]", (Object)webflow.getPort(), (Object)maxHeaderSize);
                Long maxResponseHeader = this.serverProperties.getTomcat().getMaxHttpResponseHeaderSize().toBytes();
                protocol.setMaxHttpResponseHeaderSize(maxResponseHeader.intValue());
                LOGGER.debug("Configured max response header size for the tomcat connector on port [{}] to be [{}]", (Object)webflow.getPort(), (Object)maxResponseHeader);
                SSLHostConfig sslHostConfig = new SSLHostConfig();
                sslHostConfig.setSslProtocol("TLS");
                sslHostConfig.setHostName(protocol.getDefaultSSLHostConfigName());
                sslHostConfig.setCertificateVerification(webflow.getClientAuth());
                SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
                certificate.setCertificateKeystoreFile(this.serverProperties.getSsl().getKeyStore());
                certificate.setCertificateKeyPassword(this.serverProperties.getSsl().getKeyStorePassword());
                sslHostConfig.setTruststoreFile(this.serverProperties.getSsl().getTrustStore());
                sslHostConfig.setTruststorePassword(this.serverProperties.getSsl().getTrustStorePassword());
                sslHostConfig.addCertificate(certificate);
                protocol.addSslHostConfig(sslHostConfig);
                tomcat.addAdditionalTomcatConnectors(new Connector[]{connector});
            }
        }
    }
}

