/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.principal.DefaultX509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.X509ExtractorUtils;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EDIPIX509AttributeExtractor
extends DefaultX509AttributeExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EDIPIX509AttributeExtractor.class);

    @Override
    public Map<String, List<Object>> extractPersonAttributes(X509Certificate certificate) {
        Map<String, List<Object>> personAttributes = super.extractPersonAttributes(certificate);
        X500Principal subjectPrincipal = certificate.getSubjectX500Principal();
        String commonName = X509ExtractorUtils.retrieveTheCommonName(subjectPrincipal.getName());
        Optional<String> result = X509ExtractorUtils.retrieveTheEDIPI(commonName);
        result.ifPresentOrElse(edipi -> personAttributes.put("x509EDIPI", CollectionUtils.wrapList((Object[])new Object[]{edipi})), () -> LOGGER.trace("EDIPI not found in certificate common name: [{}]", (Object)commonName));
        return personAttributes;
    }
}

