/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.ldap;

import java.net.URI;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class LdaptiveResourceCRLFetcher
extends ResourceCRLFetcher {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdaptiveResourceCRLFetcher.class);
    private final ConnectionConfig connectionConfig;
    private final SearchOperation searchOperation;
    private final String certificateAttribute;

    @Override
    public X509CRL fetch(Resource crl) throws Exception {
        if (LdapUtils.isLdapConnectionUrl((String)crl.toString())) {
            return this.fetchCRLFromLdap(crl);
        }
        return super.fetch(crl);
    }

    @Override
    public X509CRL fetch(URI crl) throws Exception {
        if (LdapUtils.isLdapConnectionUrl((URI)crl)) {
            return this.fetchCRLFromLdap(crl);
        }
        return super.fetch(crl);
    }

    @Override
    public X509CRL fetch(URL crl) throws Exception {
        if (LdapUtils.isLdapConnectionUrl((URL)crl)) {
            return this.fetchCRLFromLdap(crl);
        }
        return super.fetch(crl);
    }

    @Override
    public X509CRL fetch(String crl) throws Exception {
        if (LdapUtils.isLdapConnectionUrl((String)crl)) {
            return this.fetchCRLFromLdap(crl);
        }
        return super.fetch(crl);
    }

    protected X509CRL fetchCRLFromLdap(Object r) throws Exception {
        try {
            String ldapURL = r.toString();
            LOGGER.debug("Fetching CRL from ldap [{}]", (Object)ldapURL);
            SearchResponse result = this.performLdapSearch(ldapURL);
            if (result.isSuccess()) {
                LdapEntry entry = result.getEntry();
                LdapAttribute attribute = Objects.requireNonNull(entry.getAttribute(this.certificateAttribute), () -> String.format("Certificate attribute %s does not exist or has no value", this.certificateAttribute));
                if (attribute.isBinary()) {
                    LOGGER.debug("Located entry [{}]. Retrieving first attribute [{}]", (Object)entry, (Object)attribute);
                    return this.fetchX509CRLFromAttribute(attribute);
                }
                LOGGER.warn("Found certificate attribute [{}] but it is not marked as a binary attribute", (Object)this.certificateAttribute);
            }
            LOGGER.debug("Failed to execute the search [{}]", (Object)result);
            throw new CertificateException("Failed to establish a connection ldap and search.");
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new CertificateException(e.getMessage());
        }
    }

    protected X509CRL fetchX509CRLFromAttribute(LdapAttribute attribute) throws Exception {
        byte[] val = attribute.getBinaryValue();
        byte[] decoded64 = EncodingUtils.decodeBase64((byte[])val);
        LOGGER.trace("Retrieved CRL from ldap as byte array decoded in base64. Fetching...");
        return super.fetch((Resource)new ByteArrayResource(decoded64));
    }

    protected SearchResponse performLdapSearch(String ldapURL) throws LdapException {
        SearchOperation operation = SearchOperation.copy((SearchOperation)this.searchOperation);
        operation.setConnectionFactory(this.prepareConnectionFactory(ldapURL));
        return operation.execute();
    }

    protected ConnectionFactory prepareConnectionFactory(String ldapURL) {
        ConnectionConfig config = ConnectionConfig.copy((ConnectionConfig)this.connectionConfig);
        if (!config.getLdapUrl().equalsIgnoreCase(ldapURL)) {
            config.setConnectionInitializers(new ConnectionInitializer[0]);
        }
        config.setLdapUrl(ldapURL);
        return new DefaultConnectionFactory(config);
    }

    @Generated
    public LdaptiveResourceCRLFetcher(ConnectionConfig connectionConfig, SearchOperation searchOperation, String certificateAttribute) {
        this.connectionConfig = connectionConfig;
        this.searchOperation = searchOperation;
        this.certificateAttribute = certificateAttribute;
    }
}

