/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir.groovy;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.AbstractDefaultAttributePersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.persondir.groovy.PersonAttributeScriptDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyPersonAttributeDao.class);
    private final PersonAttributeScriptDao groovyObject;
    private Set<String> possibleUserAttributeNames;
    private Set<String> availableQueryAttributes;

    public PersonAttributes getPerson(String uid, Set<PersonAttributes> resultPeople, PersonAttributeDaoFilter filter) {
        if (!this.isEnabled()) {
            return null;
        }
        Map<String, Object> personAttributesMap = this.groovyObject.getAttributesForUser(Objects.requireNonNull(uid));
        if (personAttributesMap != null) {
            LOGGER.debug("Creating person attributes with the username [{}] and attributes [{}]", (Object)uid, personAttributesMap);
            Map personAttributes = this.toMultivaluedMap(personAttributesMap);
            return new SimplePersonAttributes(uid, personAttributes);
        }
        return null;
    }

    public Set<PersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> attributes, PersonAttributeDaoFilter filter, Set<PersonAttributes> resultPeople) {
        Map<String, List<Object>> personAttributesMap = this.groovyObject.getPersonAttributesFromMultivaluedAttributes(attributes, resultPeople);
        if (personAttributesMap != null) {
            LOGGER.debug("Creating person attributes: [{}]", personAttributesMap);
            return Set.of(new SimplePersonAttributes(personAttributesMap));
        }
        return null;
    }

    @Generated
    public GroovyPersonAttributeDao(PersonAttributeScriptDao groovyObject) {
        this.groovyObject = groovyObject;
    }

    @Generated
    public PersonAttributeScriptDao getGroovyObject() {
        return this.groovyObject;
    }

    @Generated
    public Set<String> getPossibleUserAttributeNames() {
        return this.possibleUserAttributeNames;
    }

    @Generated
    public Set<String> getAvailableQueryAttributes() {
        return this.availableQueryAttributes;
    }

    @Generated
    public void setPossibleUserAttributeNames(Set<String> possibleUserAttributeNames) {
        this.possibleUserAttributeNames = possibleUserAttributeNames;
    }

    @Generated
    public void setAvailableQueryAttributes(Set<String> availableQueryAttributes) {
        this.availableQueryAttributes = availableQueryAttributes;
    }
}

