/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.time.Clock;
import java.time.Period;
import java.time.ZonedDateTime;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.FreeIPAAccountState;
import org.ldaptive.transcode.GeneralizedTimeValueTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeIPAAuthenticationResponseHandler
extends AbstractFreezable
implements AuthenticationResponseHandler {
    public static final String[] ATTRIBUTES = new String[]{"krbPasswordExpiration", "krbLoginFailedCount", "krbLastPwdChange"};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Clock expirationClock;
    private Period expirationPeriod;
    private Period warningPeriod;
    private int maxLoginFailures;

    FreeIPAAuthenticationResponseHandler(Clock clock) {
        this.expirationClock = clock;
    }

    public FreeIPAAuthenticationResponseHandler() {
        this.expirationClock = Clock.systemDefaultZone();
    }

    public FreeIPAAuthenticationResponseHandler(Period warning, int loginFailures) {
        this.expirationClock = Clock.systemDefaultZone();
        this.setWarningPeriod(warning);
        this.setMaxLoginFailures(loginFailures);
    }

    public FreeIPAAuthenticationResponseHandler(Period expiration, Period warning, int loginFailures) {
        this.expirationClock = Clock.systemDefaultZone();
        this.setExpirationPeriod(expiration);
        this.setWarningPeriod(warning);
        this.setMaxLoginFailures(loginFailures);
    }

    @Override
    public void handle(AuthenticationResponse response) {
        if (response.getResultCode() != ResultCode.SUCCESS) {
            this.logger.debug("Parsing response code: {}, diagnostic message: {}", (Object)response.getResultCode(), (Object)response.getDiagnosticMessage());
            FreeIPAAccountState.Error fError = FreeIPAAccountState.Error.parse(response.getResultCode(), response.getDiagnosticMessage());
            if (fError != null) {
                this.logger.debug("Translated response code and diagnostic message to: {}", (Object)fError);
                response.setAccountState(new FreeIPAAccountState(fError));
            }
        } else if (response.isSuccess()) {
            LdapEntry entry = response.getLdapEntry();
            LdapAttribute expTime = entry != null ? entry.getAttribute("krbPasswordExpiration") : null;
            LdapAttribute failedLogins = entry != null ? entry.getAttribute("krbLoginFailedCount") : null;
            LdapAttribute lastPwdChange = entry != null ? entry.getAttribute("krbLastPwdChange") : null;
            this.logger.debug("Read attributes krbPasswordExpiration: {}, krbLoginFailedCount: {}, krbLastPwdChange: {}", new Object[]{expTime, failedLogins, lastPwdChange});
            ZonedDateTime exp = null;
            Integer loginRemaining = null;
            if (failedLogins != null && this.maxLoginFailures > 0) {
                loginRemaining = this.maxLoginFailures - Integer.parseInt(failedLogins.getStringValue());
            }
            this.logger.debug("Set loginRemaining to {}", loginRemaining);
            if (expTime != null) {
                exp = (ZonedDateTime)expTime.getValue(new GeneralizedTimeValueTranscoder().decoder());
            } else if (this.expirationPeriod != null && lastPwdChange != null) {
                exp = ((ZonedDateTime)lastPwdChange.getValue(new GeneralizedTimeValueTranscoder().decoder())).plus(this.expirationPeriod);
            }
            if (exp != null) {
                this.logger.debug("Transcoded passwordExpirationTime to {}", (Object)exp);
                if (this.warningPeriod != null) {
                    ZonedDateTime warn = exp.minus(this.warningPeriod);
                    ZonedDateTime now = ZonedDateTime.now(this.expirationClock);
                    this.logger.debug("Warning period is: {}, current datetime is {}", (Object)warn, (Object)now);
                    if (now.isAfter(warn)) {
                        response.setAccountState(new FreeIPAAccountState(exp, loginRemaining != null ? loginRemaining : 0));
                    }
                } else {
                    this.logger.debug("No warning period is defined");
                    response.setAccountState(new FreeIPAAccountState(exp, loginRemaining != null ? loginRemaining : 0));
                }
            } else if (loginRemaining != null && loginRemaining < this.maxLoginFailures) {
                this.logger.debug("Using loginRemaining: {}", (Object)loginRemaining);
                response.setAccountState(new FreeIPAAccountState(null, loginRemaining));
            }
        }
        this.logger.debug("Configured authentication response: {}", (Object)response);
    }

    public int getMaxLoginFailures() {
        return this.maxLoginFailures;
    }

    public void setMaxLoginFailures(int loginFailures) {
        this.assertMutable();
        if (loginFailures < 0) {
            throw new IllegalArgumentException("Login failures must be >= 0");
        }
        this.maxLoginFailures = loginFailures;
    }

    public Period getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public void setExpirationPeriod(Period period) {
        this.assertMutable();
        this.expirationPeriod = period;
    }

    public Period getWarningPeriod() {
        return this.warningPeriod;
    }

    public void setWarningPeriod(Period period) {
        this.assertMutable();
        this.warningPeriod = period;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::expirationPeriod=" + this.expirationPeriod + ", warningPeriod=" + this.warningPeriod + ", maxLoginFailures=" + this.maxLoginFailures + "]";
    }
}

