/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.flowable.eventregistry.api.CorrelationKeyGenerator;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRegistryEvent;
import org.flowable.eventregistry.api.EventRegistryEventConsumer;
import org.flowable.eventregistry.api.EventRegistryNonMatchingEventConsumer;
import org.flowable.eventregistry.api.EventRegistryProcessingInfo;
import org.flowable.eventregistry.api.InboundEvent;
import org.flowable.eventregistry.api.InboundEventProcessor;
import org.flowable.eventregistry.api.OutboundEventProcessor;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.impl.DefaultCorrelationKeyGenerator;
import org.flowable.eventregistry.impl.DefaultInboundEvent;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventRegistry
implements EventRegistry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected EventRegistryEngineConfiguration engineConfiguration;
    protected CorrelationKeyGenerator<Map<String, Object>> correlationKeyGenerator;
    protected InboundEventProcessor inboundEventProcessor;
    protected OutboundEventProcessor outboundEventProcessor;
    protected OutboundEventProcessor systemOutboundEventProcessor;

    public DefaultEventRegistry(EventRegistryEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        this.correlationKeyGenerator = new DefaultCorrelationKeyGenerator();
    }

    public void setInboundEventProcessor(InboundEventProcessor inboundEventProcessor) {
        this.inboundEventProcessor = inboundEventProcessor;
    }

    public void setOutboundEventProcessor(OutboundEventProcessor outboundEventProcessor) {
        this.outboundEventProcessor = outboundEventProcessor;
    }

    public OutboundEventProcessor getSystemOutboundEventProcessor() {
        return this.systemOutboundEventProcessor;
    }

    public void setSystemOutboundEventProcessor(OutboundEventProcessor systemOutboundEventProcessor) {
        this.systemOutboundEventProcessor = systemOutboundEventProcessor;
    }

    public void eventReceived(InboundChannelModel channelModel, String event) {
        this.inboundEventProcessor.eventReceived(channelModel, (InboundEvent)new DefaultInboundEvent(event));
    }

    public void eventReceived(InboundChannelModel channelModel, InboundEvent event) {
        this.inboundEventProcessor.eventReceived(channelModel, event);
    }

    public void sendEventToConsumers(EventRegistryEvent eventRegistryEvent) {
        Collection engineEventRegistryEventConsumers = this.engineConfiguration.getEventRegistryEventConsumers().values();
        EventRegistryProcessingInfo eventRegistryProcessingInfo = null;
        boolean debugLoggingEnabled = this.logger.isDebugEnabled();
        for (EventRegistryEventConsumer eventConsumer : engineEventRegistryEventConsumers) {
            if (debugLoggingEnabled) {
                this.logger.debug("Sending {} to event consumer {}", (Object)eventRegistryEvent, (Object)eventConsumer);
            }
            EventRegistryProcessingInfo processingInfo = eventConsumer.eventReceived(eventRegistryEvent);
            if (debugLoggingEnabled) {
                this.logger.debug("Event consumer {} processed event {} with result {}", new Object[]{eventConsumer, eventRegistryEvent, processingInfo});
            }
            if (processingInfo == null || processingInfo.getEventConsumerInfos() == null || processingInfo.getEventConsumerInfos().isEmpty()) continue;
            if (eventRegistryProcessingInfo == null) {
                eventRegistryProcessingInfo = new EventRegistryProcessingInfo();
            }
            eventRegistryProcessingInfo.setEventConsumerInfos(processingInfo.getEventConsumerInfos());
        }
        if (eventRegistryProcessingInfo == null || !eventRegistryProcessingInfo.eventHandled()) {
            EventRegistryNonMatchingEventConsumer nonMatchingEventConsumer = this.engineConfiguration.getNonMatchingEventConsumer();
            if (nonMatchingEventConsumer != null) {
                if (debugLoggingEnabled) {
                    this.logger.debug("No event consumer consumed event {}. Handling it with {}", (Object)eventRegistryEvent, (Object)nonMatchingEventConsumer);
                }
                nonMatchingEventConsumer.handleNonMatchingEvent(eventRegistryEvent, eventRegistryProcessingInfo);
            } else if (debugLoggingEnabled) {
                this.logger.debug("No event consumer consumed event {}", (Object)eventRegistryEvent);
            }
        } else if (debugLoggingEnabled) {
            this.logger.debug("{} was consumed with {}", (Object)eventRegistryEvent, eventRegistryProcessingInfo);
        }
    }

    public void sendSystemEventOutbound(EventInstance eventInstance) {
        this.systemOutboundEventProcessor.sendEvent(eventInstance, Collections.emptyList());
    }

    public void sendEventOutbound(EventInstance eventInstance, Collection<ChannelModel> channelModels) {
        this.outboundEventProcessor.sendEvent(eventInstance, channelModels);
    }

    public void registerEventRegistryEventConsumer(EventRegistryEventConsumer eventRegistryEventBusConsumer) {
        this.engineConfiguration.getEventRegistryEventConsumers().put(eventRegistryEventBusConsumer.getConsumerKey(), eventRegistryEventBusConsumer);
    }

    public void removeFlowableEventRegistryEventConsumer(EventRegistryEventConsumer eventRegistryEventBusConsumer) {
        this.engineConfiguration.getEventRegistryEventConsumers().remove(eventRegistryEventBusConsumer.getConsumerKey());
    }

    public String generateKey(Map<String, Object> data) {
        return this.correlationKeyGenerator.generateKey(data);
    }
}

