/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.commons.IdRepoImplementationInfoProvider;
import org.apache.syncope.client.console.commons.ImplementationInfoProvider;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.common.lib.policy.InboundCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PushCorrelationRuleConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.IdMImplementationType;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class IdMImplementationInfoProvider
extends IdRepoImplementationInfoProvider {
    private static final long serialVersionUID = -5385695412826366167L;

    public IdMImplementationInfoProvider(ClassPathScanImplementationLookup lookup, ImplementationRestClient implementationRestClient) {
        super(lookup, implementationRestClient);
    }

    public ImplementationInfoProvider.ViewMode getViewMode(ImplementationTO implementation) {
        return "INBOUND_CORRELATION_RULE".equals(implementation.getType()) || "PUSH_CORRELATION_RULE".equals(implementation.getType()) ? ImplementationInfoProvider.ViewMode.JSON_BODY : super.getViewMode(implementation);
    }

    public List<String> getClasses(ImplementationTO implementation, ImplementationInfoProvider.ViewMode viewMode) {
        List<Object> classes = new ArrayList();
        if (viewMode == ImplementationInfoProvider.ViewMode.JSON_BODY && IdMImplementationType.values().containsKey(implementation.getType())) {
            switch (implementation.getType()) {
                case "INBOUND_CORRELATION_RULE": {
                    classes = this.lookup.getClasses(InboundCorrelationRuleConf.class).stream().map(Class::getName).collect(Collectors.toList());
                    break;
                }
                case "PUSH_CORRELATION_RULE": {
                    classes = this.lookup.getClasses(PushCorrelationRuleConf.class).stream().map(Class::getName).collect(Collectors.toList());
                    break;
                }
            }
            Collections.sort(classes);
        } else {
            classes = super.getClasses(implementation, viewMode);
        }
        return classes;
    }

    public String getGroovyTemplateClassName(String implementationType) {
        return switch (implementationType) {
            case "RECON_FILTER_BUILDER" -> "MyReconFilterBuilder";
            case "PROPAGATION_ACTIONS" -> "MyPropagationActions";
            case "INBOUND_ACTIONS" -> "MyInboundActions";
            case "PUSH_ACTIONS" -> "MyPushActions";
            case "INBOUND_CORRELATION_RULE" -> "MyInboundCorrelationRule";
            case "PUSH_CORRELATION_RULE" -> "MyPushCorrelationRule";
            case "PROVISION_SORTER" -> "MyProvisionSorter";
            default -> super.getGroovyTemplateClassName(implementationType);
        };
    }

    public Class<?> getClass(String implementationType, String name) {
        return switch (implementationType) {
            case "INBOUND_CORRELATION_RULE" -> this.lookup.getClasses(InboundCorrelationRuleConf.class).stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
            case "PUSH_CORRELATION_RULE" -> this.lookup.getClasses(PushCorrelationRuleConf.class).stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
            default -> super.getClass(implementationType, name);
        };
    }

    public IModel<List<String>> getReconFilterBuilders() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdMImplementationInfoProvider.this.implementationRestClient.list("RECON_FILTER_BUILDER").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }

    public IModel<List<String>> getLiveSyncDeltaMappers() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdMImplementationInfoProvider.this.implementationRestClient.list("LIVE_SYNC_DELTA_MAPPER").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }

    public IModel<List<String>> getInboundActions() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdMImplementationInfoProvider.this.implementationRestClient.list("INBOUND_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }

    public IModel<List<String>> getPushActions() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdMImplementationInfoProvider.this.implementationRestClient.list("PUSH_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }
}

