/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.codegen;

import com.googlecode.cqengine.codegen.MemberFilter;
import com.googlecode.cqengine.codegen.MemberFilters;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AttributeSourceGenerator {
    static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Character.TYPE, Character.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    };

    public static String generateAttributesForPastingIntoTargetClass(Class<?> targetClass) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, false, "", MemberFilters.FIELDS_ONLY);
    }

    public static String generateAttributesForPastingIntoTargetClass(Class<?> targetClass, MemberFilter memberFilter) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, false, "", memberFilter);
    }

    public static String generateSeparateAttributesClass(Class<?> targetClass, String packageOfAttributesClass) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, true, packageOfAttributesClass, MemberFilters.ALL_MEMBERS);
    }

    public static String generateSeparateAttributesClass(Class<?> targetClass, String packageOfAttributesClass, MemberFilter memberFilter) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, true, packageOfAttributesClass, memberFilter);
    }

    public static String generateSeparateAttributesClass(Class<?> targetClass, Package packageOfAttributesClass) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, true, packageOfAttributesClass.getName(), MemberFilters.ALL_MEMBERS);
    }

    public static String generateSeparateAttributesClass(Class<?> targetClass, Package packageOfAttributesClass, MemberFilter memberFilter) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, true, packageOfAttributesClass.getName(), memberFilter);
    }

    static String generateAttributesForClass(Class<?> targetClass, boolean separateAttributesClass, String packageOfAttributesClass, MemberFilter memberFilter) {
        StringBuilder sb = new StringBuilder();
        if (separateAttributesClass) {
            sb.append("package ").append(packageOfAttributesClass).append(";\n\n");
            sb.append("import com.googlecode.cqengine.attribute.*;\n");
            sb.append("import com.googlecode.cqengine.query.option.QueryOptions;\n");
            sb.append("import java.util.*;\n");
            String targetClassName = targetClass.getName().replace("$", ".");
            sb.append("import ").append(targetClassName).append(";\n\n");
            sb.append("/**\n");
            sb.append(" * CQEngine attributes for accessing the members of class {@code ").append(targetClassName).append("}.\n");
            sb.append(" * <p/>.\n");
            sb.append(" * Auto-generated by CQEngine's {@code ").append(AttributeSourceGenerator.class.getSimpleName()).append("}.\n");
            sb.append(" */\n");
            sb.append("public class CQ").append(targetClass.getSimpleName()).append(" {");
        }
        HashSet<String> membersEncountered = new HashSet<String>();
        for (Class<?> currentClass = targetClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Member member : AttributeSourceGenerator.getMembers(currentClass)) {
                int modifiers;
                if (!memberFilter.accept(member) || membersEncountered.contains(member.getName()) || Modifier.isStatic(modifiers = member.getModifiers())) continue;
                if (Modifier.isPrivate(modifiers)) {
                    if (separateAttributesClass || !currentClass.equals(targetClass)) continue;
                    sb.append("\n\n");
                    sb.append(AttributeSourceGenerator.generateAttributeForMember(targetClass, member));
                    membersEncountered.add(member.getName());
                    continue;
                }
                if (Modifier.isProtected(modifiers)) {
                    if (separateAttributesClass && !member.getDeclaringClass().getPackage().getName().equals(packageOfAttributesClass)) continue;
                    sb.append("\n\n");
                    sb.append(AttributeSourceGenerator.generateAttributeForMember(targetClass, member));
                    membersEncountered.add(member.getName());
                    continue;
                }
                if (Modifier.isPublic(modifiers)) {
                    sb.append("\n\n");
                    sb.append(AttributeSourceGenerator.generateAttributeForMember(targetClass, member));
                    membersEncountered.add(member.getName());
                    continue;
                }
                if ((separateAttributesClass || !currentClass.equals(targetClass)) && !member.getDeclaringClass().getPackage().getName().equals(packageOfAttributesClass)) continue;
                sb.append("\n\n");
                sb.append(AttributeSourceGenerator.generateAttributeForMember(targetClass, member));
                membersEncountered.add(member.getName());
            }
        }
        if (separateAttributesClass) {
            sb.append("\n}\n");
        }
        return sb.toString();
    }

    static String generateAttributeForMember(Class<?> enclosingClass, Member member) {
        try {
            MemberType memberType = AttributeSourceGenerator.getMemberType(member);
            if (AttributeSourceGenerator.getType(member).isPrimitive()) {
                return AttributeSourceGenerator.generateSimpleAttribute(enclosingClass.getSimpleName(), PRIMITIVES_TO_WRAPPERS.get(AttributeSourceGenerator.getType(member)).getSimpleName(), member.getName(), memberType);
            }
            if (Iterable.class.isAssignableFrom(AttributeSourceGenerator.getType(member))) {
                ParameterizedType parameterizedType = AttributeSourceGenerator.getGenericType(member);
                if (parameterizedType.getActualTypeArguments().length != 1) {
                    throw new UnsupportedOperationException();
                }
                Class genericType = (Class)parameterizedType.getActualTypeArguments()[0];
                return AttributeSourceGenerator.generateMultiValueNullableAttributeForIterable(enclosingClass.getSimpleName(), genericType.getSimpleName(), member.getName(), memberType);
            }
            if (AttributeSourceGenerator.getType(member).isArray()) {
                if (AttributeSourceGenerator.getType(member).getComponentType().isPrimitive()) {
                    return AttributeSourceGenerator.generateMultiValueNullableAttributeForPrimitiveArray(enclosingClass.getSimpleName(), PRIMITIVES_TO_WRAPPERS.get(AttributeSourceGenerator.getType(member).getComponentType()).getSimpleName(), AttributeSourceGenerator.getType(member).getComponentType().getSimpleName(), member.getName(), memberType);
                }
                return AttributeSourceGenerator.generateMultiValueNullableAttributeForObjectArray(enclosingClass.getSimpleName(), AttributeSourceGenerator.getType(member).getComponentType().getSimpleName(), member.getName(), memberType);
            }
            return AttributeSourceGenerator.generateSimpleNullableAttribute(enclosingClass.getSimpleName(), AttributeSourceGenerator.getType(member).getSimpleName(), member.getName(), memberType);
        }
        catch (Exception e) {
            return "    // *** Note: Could not generate CQEngine attribute automatically for member: " + enclosingClass.getSimpleName() + "." + member.getName() + " ***";
        }
    }

    static String generateSimpleAttribute(String objectType, String attributeType, String memberName, MemberType memberType) {
        return "    /**\n     * CQEngine attribute for accessing " + memberType.description + " {@code " + objectType + "." + memberName + memberType.accessSuffix + "}.\n     */\n    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + " = new SimpleAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + "\") {\n        public " + attributeType + " getValue(" + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) { return " + objectType.toLowerCase() + "." + memberName + memberType.accessSuffix + "; }\n    };";
    }

    static String generateSimpleNullableAttribute(String objectType, String attributeType, String memberName, MemberType memberType) {
        return "    /**\n     * CQEngine attribute for accessing " + memberType.description + " {@code " + objectType + "." + memberName + memberType.accessSuffix + "}.\n     */\n    // Note: For best performance:\n    // - if this " + memberType.description + " cannot " + memberType.produce + " null, replace this SimpleNullableAttribute with a SimpleAttribute\n    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + " = new SimpleNullableAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + "\") {\n        public " + attributeType + " getValue(" + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) { return " + objectType.toLowerCase() + "." + memberName + memberType.accessSuffix + "; }\n    };";
    }

    static String generateMultiValueNullableAttributeForIterable(String objectType, String attributeType, String memberName, MemberType memberType) {
        return "    /**\n     * CQEngine attribute for accessing " + memberType.description + " {@code " + objectType + "." + memberName + memberType.accessSuffix + "}.\n     */\n    // Note: For best performance:\n    // - if the collection cannot contain null elements change true to false in the following constructor, or\n    // - if the collection cannot contain null elements AND the " + memberType.description + " itself cannot " + memberType.produce + " null, replace this\n    //   MultiValueNullableAttribute with a MultiValueAttribute (and change getNullableValues() to getValues())\n    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + " = new MultiValueNullableAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + "\", true) {\n        public Iterable<" + attributeType + "> getNullableValues(" + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) { return " + objectType.toLowerCase() + "." + memberName + memberType.accessSuffix + "; }\n    };";
    }

    static String generateMultiValueNullableAttributeForObjectArray(String objectType, String attributeType, String memberName, MemberType memberType) {
        return "    /**\n     * CQEngine attribute for accessing " + memberType.description + " {@code " + objectType + "." + memberName + memberType.accessSuffix + "}.\n     */\n    // Note: For best performance:\n    // - if the array cannot contain null elements change true to false in the following constructor, or\n    // - if the array cannot contain null elements AND the " + memberType.description + " itself cannot " + memberType.produce + " null, replace this\n    //   MultiValueNullableAttribute with a MultiValueAttribute (and change getNullableValues() to getValues())\n    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + " = new MultiValueNullableAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + "\", true) {\n        public Iterable<" + attributeType + "> getNullableValues(" + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) { return Arrays.asList(" + objectType.toLowerCase() + "." + memberName + memberType.accessSuffix + "); }\n    };";
    }

    static String generateMultiValueNullableAttributeForPrimitiveArray(String objectType, String attributeType, String primitiveType, String memberName, MemberType memberType) {
        return "    /**\n     * CQEngine attribute for accessing " + memberType.description + " {@code " + objectType + "." + memberName + memberType.accessSuffix + "}.\n     */\n    // Note: For best performance:\n    // - if this " + memberType.description + " cannot " + memberType.produce + " null, replace this\n    //   MultiValueNullableAttribute with a MultiValueAttribute (and change getNullableValues() to getValues())\n    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + " = new MultiValueNullableAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(memberName) + "\", false) {\n        public Iterable<" + attributeType + "> getNullableValues(final " + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) {\n            return new AbstractList<" + attributeType + ">() {\n                public " + attributeType + " get(int i) { return " + objectType.toLowerCase() + "." + memberName + memberType.accessSuffix + "[i]; }\n                public int size() { return " + objectType.toLowerCase() + "." + memberName + memberType.accessSuffix + ".length; }\n            };\n        }\n    };";
    }

    static String toUpperCaseWithUnderscores(String camelCase) {
        String[] words = camelCase.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = Arrays.asList(words).iterator();
        while (iterator.hasNext()) {
            String word = iterator.next();
            sb.append(word.toUpperCase());
            if (!iterator.hasNext()) continue;
            sb.append("_");
        }
        return sb.toString();
    }

    static List<Member> getMembers(Class currentClass) {
        ArrayList<Member> declaredMembers = new ArrayList<Member>();
        for (Field field : currentClass.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            declaredMembers.add(field);
        }
        for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
            if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge() || ((Method)accessibleObject).getReturnType().equals(Void.TYPE) || ((Method)accessibleObject).getParameterTypes().length != 0) continue;
            declaredMembers.add((Member)((Object)accessibleObject));
        }
        return declaredMembers;
    }

    static MemberType getMemberType(Member member) {
        if (member instanceof Field) {
            return MemberType.FIELD;
        }
        if (member instanceof Method) {
            return MemberType.METHOD;
        }
        throw new IllegalStateException("Unsupported member type: " + member);
    }

    static Class<?> getType(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof Method) {
            return ((Method)member).getReturnType();
        }
        throw new IllegalStateException("Unsupported member type: " + member);
    }

    static ParameterizedType getGenericType(Member member) {
        if (member instanceof Field) {
            return (ParameterizedType)((Field)member).getGenericType();
        }
        if (member instanceof Method) {
            return (ParameterizedType)((Method)member).getGenericReturnType();
        }
        throw new IllegalStateException("Unsupported member type: " + member);
    }

    AttributeSourceGenerator() {
    }

    static enum MemberType {
        FIELD("field", "", "be"),
        METHOD("method", "()", "return");

        public final String description;
        public final String accessSuffix;
        public final String produce;

        private MemberType(String description, String accessSuffix, String produce) {
            this.description = description;
            this.accessSuffix = accessSuffix;
            this.produce = produce;
        }
    }
}

