/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.CloseableRequestResources;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.onheap.OnHeapPersistence;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantLock;

public class ObjectLockingIndexedCollection<O>
extends ConcurrentIndexedCollection<O> {
    final StripedLock stripedLock;

    public ObjectLockingIndexedCollection() {
        this(OnHeapPersistence.withoutPrimaryKey(), 64);
    }

    public <A extends Comparable<A>> ObjectLockingIndexedCollection(Persistence<O, A> persistence) {
        this(persistence, 64);
    }

    public <A extends Comparable<A>> ObjectLockingIndexedCollection(int concurrencyLevel) {
        this(OnHeapPersistence.withoutPrimaryKey(), concurrencyLevel);
    }

    public <A extends Comparable<A>> ObjectLockingIndexedCollection(Persistence<O, A> persistence, int concurrencyLevel) {
        super(persistence);
        this.stripedLock = new StripedLock(concurrencyLevel);
    }

    @Override
    public CloseableIterator<O> iterator() {
        return new CloseableIterator<O>(){
            final QueryOptions queryOptions;
            private final CloseableIterator<O> collectionIterator;
            boolean autoClosed;
            private O currentObject;
            {
                this.queryOptions = ObjectLockingIndexedCollection.this.openRequestScopeResourcesIfNecessary(null);
                this.collectionIterator = ObjectLockingIndexedCollection.this.objectStore.iterator(this.queryOptions);
                this.autoClosed = false;
                this.currentObject = null;
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this.collectionIterator.hasNext();
                if (!hasNext) {
                    this.close();
                    this.autoClosed = true;
                }
                return hasNext;
            }

            @Override
            public O next() {
                Object next = this.collectionIterator.next();
                this.currentObject = next;
                return next;
            }

            @Override
            public void remove() {
                if (this.currentObject == null) {
                    throw new IllegalStateException();
                }
                ReentrantLock lock = ObjectLockingIndexedCollection.this.stripedLock.getLockForObject(this.currentObject);
                lock.lock();
                try {
                    if (this.autoClosed) {
                        ObjectLockingIndexedCollection.this.remove(this.currentObject);
                    } else {
                        ObjectLockingIndexedCollection.this.doRemoveAll(Collections.singleton(this.currentObject), this.queryOptions);
                    }
                    this.currentObject = null;
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public void close() {
                CloseableRequestResources.closeQuietly(this.collectionIterator);
                ObjectLockingIndexedCollection.this.closeRequestScopeResourcesIfNecessary(this.queryOptions);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(O o) {
        ReentrantLock lock = this.stripedLock.getLockForObject(o);
        lock.lock();
        try {
            boolean bl = super.add(o);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock lock = this.stripedLock.getLockForObject(object);
        lock.lock();
        try {
            boolean bl = super.remove(object);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends O> c) {
        boolean modified = false;
        for (O object : c) {
            modified = this.add(object) || modified;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object object : c) {
            modified = this.remove(object) || modified;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public synchronized void clear() {
        super.clear();
    }

    static class StripedLock {
        final int concurrencyLevel;
        final ReentrantLock[] locks;

        StripedLock(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            this.locks = new ReentrantLock[concurrencyLevel];
            for (int i = 0; i < concurrencyLevel; ++i) {
                this.locks[i] = new ReentrantLock();
            }
        }

        ReentrantLock getLockForObject(Object object) {
            int hashCode = object.hashCode();
            return this.locks[Math.abs(hashCode % this.concurrencyLevel)];
        }
    }
}

