/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.profile.CasRestProfile;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasRestAuthenticator
implements Authenticator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasRestAuthenticator.class);
    protected CasConfiguration configuration;

    public CasRestAuthenticator(CasConfiguration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
    }

    public Optional<Credentials> validate(CallContext ctx, Credentials cred) {
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)cred;
        if (credentials == null || credentials.getPassword() == null || credentials.getUsername() == null) {
            throw new TechnicalException("Credentials are required");
        }
        String ticketGrantingTicketId = this.requestTicketGrantingTicket(credentials.getUsername(), credentials.getPassword(), ctx.webContext());
        if (StringUtils.isNotBlank((CharSequence)ticketGrantingTicketId)) {
            credentials.setUserProfile((UserProfile)new CasRestProfile(ticketGrantingTicketId, credentials.getUsername()));
        }
        return Optional.of(credentials);
    }

    private String requestTicketGrantingTicket(String username, String password, WebContext context) {
        String string;
        int responseCode;
        String locationHeader;
        HttpURLConnection connection;
        block5: {
            connection = null;
            connection = HttpUtils.openPostConnection((URL)new URL(this.configuration.computeFinalRestUrl(context)));
            String payload = HttpUtils.encodeQueryParam((String)"username", (String)username) + "&" + HttpUtils.encodeQueryParam((String)"password", (String)password);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
            out.write(payload);
            out.close();
            locationHeader = connection.getHeaderField("location");
            responseCode = connection.getResponseCode();
            if (locationHeader == null || responseCode != 201) break block5;
            String string2 = locationHeader.substring(locationHeader.lastIndexOf("/") + 1);
            HttpUtils.closeConnection((HttpURLConnection)connection);
            return string2;
        }
        try {
            LOGGER.debug("Ticket granting ticket request failed: " + locationHeader + " " + responseCode + HttpUtils.buildHttpErrorMessage((HttpURLConnection)connection));
            string = null;
        }
        catch (IOException e) {
            try {
                throw new TechnicalException((Throwable)e);
            }
            catch (Throwable throwable) {
                HttpUtils.closeConnection(connection);
                throw throwable;
            }
        }
        HttpUtils.closeConnection((HttpURLConnection)connection);
        return string;
    }
}

