/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.util.resource.IResourceStream;

public final class MarkupException
extends WicketRuntimeException {
    private static final long serialVersionUID = 1L;
    private transient MarkupStream markupStream;

    public MarkupException(String message) {
        super(message);
        this.markupStream = null;
    }

    public MarkupException(IResourceStream resource, String message) {
        super(resource.toString() + ": " + message);
        this.markupStream = null;
    }

    public MarkupException(IResourceStream resource, String message, Throwable cause) {
        super(resource.toString() + ": " + message, cause);
        this.markupStream = null;
    }

    public MarkupException(MarkupStream markupStream, String message) {
        super(message);
        this.markupStream = markupStream;
    }

    public MarkupException(MarkupStream markupStream, String message, Throwable cause) {
        super(message, cause);
        this.markupStream = markupStream;
    }

    public MarkupException(Markup markup, String message, Throwable cause) {
        this(new MarkupStream(markup).setCurrentIndex(markup.size() - 1), message, cause);
    }

    public MarkupStream getMarkupStream() {
        return this.markupStream;
    }

    public void setMarkupStream(MarkupStream markupStream) {
        this.markupStream = markupStream;
    }

    @Override
    public String toString() {
        return this.getMessage() + "\n MarkupStream: " + (this.markupStream == null ? "[unknown]" : this.markupStream.toString());
    }
}

