/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;

public class AcquireJobsCmd
implements Command<List<? extends JobInfoEntity>> {
    protected AsyncExecutor asyncExecutor;
    protected int remainingCapacity;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;

    public AcquireJobsCmd(AsyncExecutor asyncExecutor) {
        this(asyncExecutor, Integer.MAX_VALUE, asyncExecutor.getJobServiceConfiguration().getJobEntityManager());
    }

    public AcquireJobsCmd(AsyncExecutor asyncExecutor, int remainingCapacity, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.asyncExecutor = asyncExecutor;
        this.remainingCapacity = remainingCapacity;
        this.jobEntityManager = jobEntityManager;
    }

    public List<? extends JobInfoEntity> execute(CommandContext commandContext) {
        int maxResults = Math.min(this.remainingCapacity, this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition());
        List<String> enabledCategories = this.asyncExecutor.getJobServiceConfiguration().getEnabledJobCategories();
        List<? extends JobInfoEntity> jobs = this.jobEntityManager.findJobsToExecute(enabledCategories, new Page(0, maxResults));
        for (JobInfoEntity jobInfoEntity : jobs) {
            this.lockJob(jobInfoEntity, this.asyncExecutor.getAsyncJobLockTimeInMillis(), this.asyncExecutor.getJobServiceConfiguration());
        }
        return jobs;
    }

    protected void lockJob(JobInfoEntity job, int lockTimeInMillis, JobServiceConfiguration jobServiceConfiguration) {
        GregorianCalendar gregorianCalendar = this.calculateLockExpirationTime(lockTimeInMillis, jobServiceConfiguration);
        job.setLockOwner(this.asyncExecutor.getLockOwner());
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }

    protected GregorianCalendar calculateLockExpirationTime(int lockTimeInMillis, JobServiceConfiguration jobServiceConfiguration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(jobServiceConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        return gregorianCalendar;
    }
}

