/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.cmd.UnlockExclusiveJobCmd;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;

public abstract class AbstractExternalWorkerJobCmd
implements Command<Void> {
    protected final String externalJobId;
    protected final String workerId;
    protected final JobServiceConfiguration jobServiceConfiguration;

    protected AbstractExternalWorkerJobCmd(String externalJobId, String workerId, JobServiceConfiguration jobServiceConfiguration) {
        this.externalJobId = externalJobId;
        this.workerId = workerId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        ExternalWorkerJobEntity externalWorkerJob = this.resolveJob();
        this.runJobLogic(externalWorkerJob, commandContext);
        if (externalWorkerJob.isExclusive()) {
            new UnlockExclusiveJobCmd(externalWorkerJob, this.jobServiceConfiguration).execute(commandContext);
        }
        return null;
    }

    protected abstract void runJobLogic(ExternalWorkerJobEntity var1, CommandContext var2);

    protected ExternalWorkerJobEntity resolveJob() {
        if (StringUtils.isEmpty((CharSequence)this.externalJobId)) {
            throw new FlowableIllegalArgumentException("externalJobId must not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.workerId)) {
            throw new FlowableIllegalArgumentException("workerId must not be empty");
        }
        ExternalWorkerJobEntityManager externalWorkerJobEntityManager = this.jobServiceConfiguration.getExternalWorkerJobEntityManager();
        ExternalWorkerJobEntity job = (ExternalWorkerJobEntity)externalWorkerJobEntityManager.findById(this.externalJobId);
        if (job == null) {
            throw new FlowableObjectNotFoundException("No External Worker job found for id: " + this.externalJobId, ExternalWorkerJobEntity.class);
        }
        if (!Objects.equals(this.workerId, job.getLockOwner())) {
            throw new FlowableIllegalArgumentException(this.workerId + " does not hold a lock on the requested job");
        }
        return job;
    }
}

