/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.metadata.RemoveUserScramCredentialRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.slf4j.Logger;

public class ScramControlManager {
    static final int MAX_ITERATIONS = 16384;
    private final Logger log;
    private final TimelineHashMap<ScramCredentialKey, ScramCredentialValue> credentials;

    private ScramControlManager(LogContext logContext, SnapshotRegistry snapshotRegistry) {
        this.log = logContext.logger(ScramControlManager.class);
        this.credentials = new TimelineHashMap(snapshotRegistry, 0);
    }

    public ControllerResult<AlterUserScramCredentialsResponseData> alterCredentials(AlterUserScramCredentialsRequestData request, MetadataVersion metadataVersion) {
        ApiError error;
        boolean scramIsSupported = metadataVersion.isScramSupported();
        HashMap<String, AlterUserScramCredentialsRequestData.ScramCredentialDeletion> userToDeletion = new HashMap<String, AlterUserScramCredentialsRequestData.ScramCredentialDeletion>();
        HashMap<String, AlterUserScramCredentialsRequestData.ScramCredentialUpsertion> userToUpsert = new HashMap<String, AlterUserScramCredentialsRequestData.ScramCredentialUpsertion>();
        HashMap<String, ApiError> userToError = new HashMap<String, ApiError>();
        for (AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion : request.deletions()) {
            if (userToError.containsKey(deletion.name())) continue;
            if (userToDeletion.remove(deletion.name()) != null) {
                userToError.put(deletion.name(), new ApiError(Errors.DUPLICATE_RESOURCE, "A user credential cannot be altered twice in the same request"));
                continue;
            }
            if (!scramIsSupported) {
                userToError.put(deletion.name(), new ApiError(Errors.UNSUPPORTED_VERSION, "The current metadata.version does not support SCRAM"));
                continue;
            }
            error = this.validateDeletion(deletion);
            if (error.isFailure()) {
                userToError.put(deletion.name(), error);
                continue;
            }
            userToDeletion.put(deletion.name(), deletion);
        }
        for (AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion : request.upsertions()) {
            if (userToError.containsKey(upsertion.name())) continue;
            if (userToDeletion.remove(upsertion.name()) != null || userToUpsert.remove(upsertion.name()) != null) {
                userToError.put(upsertion.name(), new ApiError(Errors.DUPLICATE_RESOURCE, "A user credential cannot be altered twice in the same request"));
                continue;
            }
            if (!scramIsSupported) {
                userToError.put(upsertion.name(), new ApiError(Errors.UNSUPPORTED_VERSION, "The current metadata.version does not support SCRAM"));
                continue;
            }
            error = ScramControlManager.validateUpsertion(upsertion);
            if (error.isFailure()) {
                userToError.put(upsertion.name(), error);
                continue;
            }
            userToUpsert.put(upsertion.name(), upsertion);
        }
        AlterUserScramCredentialsResponseData response = new AlterUserScramCredentialsResponseData();
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        for (AlterUserScramCredentialsRequestData.ScramCredentialDeletion scramCredentialDeletion : userToDeletion.values()) {
            response.results().add(new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser(scramCredentialDeletion.name()).setErrorCode(Errors.NONE.code()).setErrorMessage(null));
            records.add(new ApiMessageAndVersion((ApiMessage)new RemoveUserScramCredentialRecord().setName(scramCredentialDeletion.name()).setMechanism(scramCredentialDeletion.mechanism()), 0));
        }
        for (AlterUserScramCredentialsRequestData.ScramCredentialUpsertion scramCredentialUpsertion : userToUpsert.values()) {
            ApiError error2 = ScramControlManager.finishUpsertion(records, scramCredentialUpsertion);
            if (!error2.isFailure()) {
                response.results().add(new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser(scramCredentialUpsertion.name()).setErrorCode(Errors.NONE.code()).setErrorMessage(null));
                continue;
            }
            userToError.put(scramCredentialUpsertion.name(), error2);
        }
        for (Map.Entry entry : userToError.entrySet()) {
            response.results().add(new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser((String)entry.getKey()).setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()));
        }
        return ControllerResult.atomicOf(records, response);
    }

    static ApiError finishUpsertion(List<ApiMessageAndVersion> records, AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion) {
        ScramMechanism internalMechanism = ScramMechanism.forMechanismName((String)org.apache.kafka.clients.admin.ScramMechanism.fromType((byte)upsertion.mechanism()).mechanismName());
        try {
            ScramFormatter formatter = new ScramFormatter(internalMechanism);
            records.add(new ApiMessageAndVersion((ApiMessage)new UserScramCredentialRecord().setName(upsertion.name()).setMechanism(upsertion.mechanism()).setSalt(upsertion.salt()).setStoredKey(formatter.storedKey(formatter.clientKey(upsertion.saltedPassword()))).setServerKey(formatter.serverKey(upsertion.saltedPassword())).setIterations(upsertion.iterations()), 0));
        }
        catch (Throwable e) {
            return ApiError.fromThrowable((Throwable)e);
        }
        return ApiError.NONE;
    }

    static ApiError validateUpsertion(AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion) {
        org.apache.kafka.clients.admin.ScramMechanism mechanism = org.apache.kafka.clients.admin.ScramMechanism.fromType((byte)upsertion.mechanism());
        ApiError error = ScramControlManager.validateScramUsernameAndMechanism(upsertion.name(), mechanism);
        if (error.isFailure()) {
            return error;
        }
        ScramMechanism internalMechanism = ScramMechanism.forMechanismName((String)mechanism.mechanismName());
        if (upsertion.iterations() < internalMechanism.minIterations()) {
            return new ApiError(Errors.UNACCEPTABLE_CREDENTIAL, "Too few iterations");
        }
        if (upsertion.iterations() > 16384) {
            return new ApiError(Errors.UNACCEPTABLE_CREDENTIAL, "Too many iterations");
        }
        return ApiError.NONE;
    }

    ApiError validateDeletion(AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion) {
        ApiError error = ScramControlManager.validateScramUsernameAndMechanism(deletion.name(), org.apache.kafka.clients.admin.ScramMechanism.fromType((byte)deletion.mechanism()));
        if (error.isFailure()) {
            return error;
        }
        ScramCredentialKey key = new ScramCredentialKey(deletion.name(), org.apache.kafka.clients.admin.ScramMechanism.fromType((byte)deletion.mechanism()));
        if (!this.credentials.containsKey((Object)key)) {
            return new ApiError(Errors.RESOURCE_NOT_FOUND, "Attempt to delete a user credential that does not exist");
        }
        return ApiError.NONE;
    }

    static ApiError validateScramUsernameAndMechanism(String username, org.apache.kafka.clients.admin.ScramMechanism mechanism) {
        if (username.isEmpty()) {
            return new ApiError(Errors.UNACCEPTABLE_CREDENTIAL, "Username must not be empty");
        }
        if (mechanism == org.apache.kafka.clients.admin.ScramMechanism.UNKNOWN) {
            return new ApiError(Errors.UNSUPPORTED_SASL_MECHANISM, "Unknown SCRAM mechanism");
        }
        return ApiError.NONE;
    }

    public void replay(RemoveUserScramCredentialRecord record) {
        ScramCredentialKey key = new ScramCredentialKey(record.name(), org.apache.kafka.clients.admin.ScramMechanism.fromType((byte)record.mechanism()));
        if (this.credentials.remove((Object)key) == null) {
            throw new RuntimeException("Unable to find credential to delete: " + key);
        }
        this.log.info("Replayed RemoveUserScramCredentialRecord for {} with mechanism {}.", (Object)key.username, (Object)key.mechanism);
    }

    public void replay(UserScramCredentialRecord record) {
        ScramCredentialValue value;
        ScramCredentialKey key = new ScramCredentialKey(record.name(), org.apache.kafka.clients.admin.ScramMechanism.fromType((byte)record.mechanism()));
        if (this.credentials.put((Object)key, (Object)(value = new ScramCredentialValue(record.salt(), record.storedKey(), record.serverKey(), record.iterations()))) == null) {
            this.log.info("Replayed UserScramCredentialRecord creating new entry for {} with mechanism {}.", (Object)key.username, (Object)key.mechanism);
        } else {
            this.log.info("Replayed UserScramCredentialRecord modifying existing entry for {} with mechanism {}.", (Object)key.username, (Object)key.mechanism);
        }
    }

    static class ScramCredentialValue {
        private final byte[] salt;
        private final byte[] storedKey;
        private final byte[] serverKey;
        private final int iterations;

        ScramCredentialValue(byte[] salt, byte[] storedKey, byte[] serverKey, int iterations) {
            this.salt = salt;
            this.storedKey = storedKey;
            this.serverKey = serverKey;
            this.iterations = iterations;
        }

        public int hashCode() {
            return Objects.hash(this.salt, this.storedKey, this.serverKey, this.iterations);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ScramCredentialValue other = (ScramCredentialValue)o;
            return Arrays.equals(this.salt, other.salt) && Arrays.equals(this.storedKey, other.storedKey) && Arrays.equals(this.serverKey, other.serverKey) && this.iterations == other.iterations;
        }

        public String toString() {
            return "ScramCredentialValue(salt=[hidden], storedKey=[hidden], serverKey=[hidden], iterations=[hidden])";
        }
    }

    static class ScramCredentialKey {
        private final String username;
        private final org.apache.kafka.clients.admin.ScramMechanism mechanism;

        ScramCredentialKey(String username, org.apache.kafka.clients.admin.ScramMechanism mechanism) {
            this.username = username;
            this.mechanism = mechanism;
        }

        public int hashCode() {
            return Objects.hash(this.username, this.mechanism);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ScramCredentialKey other = (ScramCredentialKey)o;
            return this.username.equals(other.username) && this.mechanism.equals((Object)other.mechanism);
        }

        public String toString() {
            return "ScramCredentialKey(username=" + this.username + ", mechanism=" + this.mechanism + ")";
        }
    }

    static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        ScramControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            return new ScramControlManager(this.logContext, this.snapshotRegistry);
        }
    }
}

