/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.profile.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.saml.credentials.SAML2AuthenticationCredentials;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexTypeSAML2AttributeConverter
implements AttributeConverter {
    public Object convert(Object a) {
        Attribute attribute = (Attribute)a;
        ArrayList<SAML2AuthenticationCredentials.SAMLAttribute> extractedAttributes = new ArrayList<SAML2AuthenticationCredentials.SAMLAttribute>();
        attribute.getAttributeValues().stream().filter(XMLObject::hasChildren).forEach(attributeValue -> {
            List<SAML2AuthenticationCredentials.SAMLAttribute> attrs = this.collectAttributesFromNodeList(attributeValue.getDOM().getChildNodes());
            extractedAttributes.addAll(attrs);
        });
        SAML2AuthenticationCredentials.SAMLAttribute simpleValues = this.from(attribute);
        if (!simpleValues.getAttributeValues().isEmpty()) {
            extractedAttributes.add(simpleValues);
        }
        return extractedAttributes;
    }

    private SAML2AuthenticationCredentials.SAMLAttribute from(Attribute attribute) {
        SAML2AuthenticationCredentials.SAMLAttribute samlAttribute = new SAML2AuthenticationCredentials.SAMLAttribute();
        samlAttribute.setFriendlyName(attribute.getFriendlyName());
        samlAttribute.setName(attribute.getName());
        samlAttribute.setNameFormat(attribute.getNameFormat());
        List<String> values = attribute.getAttributeValues().stream().filter(val -> !val.hasChildren()).map(XMLObject::getDOM).filter(dom -> dom != null && dom.getTextContent() != null).map(Node::getTextContent).collect(Collectors.toList());
        samlAttribute.setAttributeValues(values);
        return samlAttribute;
    }

    private List<SAML2AuthenticationCredentials.SAMLAttribute> collectAttributesFromNodeList(NodeList nodeList) {
        ArrayList<SAML2AuthenticationCredentials.SAMLAttribute> results = new ArrayList<SAML2AuthenticationCredentials.SAMLAttribute>();
        if (nodeList == null) {
            return results;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.hasChildNodes()) {
                results.addAll(this.collectAttributesFromNodeList(node.getChildNodes()));
                continue;
            }
            if (node.getTextContent().isBlank()) continue;
            SAML2AuthenticationCredentials.SAMLAttribute samlAttribute = new SAML2AuthenticationCredentials.SAMLAttribute();
            samlAttribute.setName(node.getParentNode().getLocalName());
            samlAttribute.getAttributeValues().add(node.getTextContent());
            results.add(samlAttribute);
        }
        return results;
    }
}

