/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.search;

import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import net.tirasa.connid.bundles.ldap.search.LdapSearchResultsHandler;
import net.tirasa.connid.bundles.ldap.search.LdapSearchStrategy;
import org.identityconnectors.common.logging.Log;

public class DefaultSearchStrategy
extends LdapSearchStrategy {
    private static final Log LOG = Log.getLog(DefaultSearchStrategy.class);
    protected final boolean ignoreNonExistingBaseDNs;

    public DefaultSearchStrategy(boolean ignoreNonExistingBaseDNs) {
        this.ignoreNonExistingBaseDNs = ignoreNonExistingBaseDNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSearch(LdapContext initCtx, List<String> baseDNs, String query, SearchControls searchControls, LdapSearchResultsHandler handler) throws NamingException {
        LOG.ok("Searching in {0} with filter {1} and {2}", new Object[]{baseDNs, query, DefaultSearchStrategy.searchControlsToString(searchControls)});
        Iterator<String> baseDNIter = baseDNs.iterator();
        boolean proceed = true;
        while (baseDNIter.hasNext() && proceed) {
            NamingEnumeration<SearchResult> results;
            String baseDN = baseDNIter.next();
            try {
                results = initCtx.search(baseDN, query, searchControls);
            }
            catch (NameNotFoundException e) {
                if (!this.ignoreNonExistingBaseDNs) {
                    throw e;
                }
                LOG.warn((Throwable)e, null, new Object[0]);
                continue;
            }
            catch (InvalidNameException e) {
                if (!this.ignoreNonExistingBaseDNs) {
                    throw e;
                }
                LOG.warn((Throwable)e, null, new Object[0]);
                continue;
            }
            try {
                while (proceed && results.hasMore()) {
                    proceed = handler.handle(baseDN, results.next());
                }
            }
            finally {
                results.close();
            }
        }
    }
}

