/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationRestfulProperties;
import org.apereo.cas.support.pac4j.authentication.clients.BaseDelegatedIdentityProviderFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.pac4j.config.client.PropertiesConfigFactory;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.IndirectClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class RestfulDelegatedIdentityProviderFactory
extends BaseDelegatedIdentityProviderFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulDelegatedIdentityProviderFactory.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public RestfulDelegatedIdentityProviderFactory(Collection<DelegatedClientFactoryCustomizer> customizers, CasSSLContext casSSLContext, CasConfigurationProperties casProperties, Cache<String, Collection<BaseClient>> clientsCache, ConfigurableApplicationContext applicationContext) {
        super(casProperties, customizers, casSSLContext, clientsCache, applicationContext);
    }

    @Override
    protected Collection<BaseClient> loadIdentityProviders() throws Exception {
        Pac4jDelegatedAuthenticationRestfulProperties restProperties = this.casProperties.getAuthn().getPac4j().getRest();
        HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(restProperties.getBasicAuthPassword()).basicAuthUsername(restProperties.getBasicAuthUsername()).method(HttpMethod.valueOf((String)restProperties.getMethod().toUpperCase(Locale.ENGLISH).trim())).url(restProperties.getUrl()).parameters(Map.of("type", restProperties.getType())).headers(restProperties.getHeaders()).build();
        HttpResponse response = HttpUtils.execute((HttpExecutionRequest)exec);
        if (response != null && HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful()) {
            try {
                List<BaseClient> list;
                block14: {
                    String result;
                    InputStream content;
                    block12: {
                        Collection<BaseClient> collection;
                        block13: {
                            content = ((HttpEntityContainer)response).getEntity().getContent();
                            try {
                                result = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
                                if (!"cas".equalsIgnoreCase(restProperties.getType())) break block12;
                                collection = this.buildClientsBasedCasProperties(result);
                                if (content == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (content != null) {
                                    try {
                                        content.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            content.close();
                        }
                        return collection;
                    }
                    list = this.buildClientsBasedPac4jProperties(result);
                    if (content == null) break block14;
                    content.close();
                }
                return list;
            }
            finally {
                HttpUtils.close((HttpResponse)response);
            }
        }
        return new ArrayList<BaseClient>();
    }

    protected Collection<BaseClient> buildClientsBasedCasProperties(String result) throws Exception {
        Map payload = (Map)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), Map.class);
        LOGGER.trace("CAS properties received as [{}]", (Object)payload);
        Optional properties = CasConfigurationProperties.bindFrom((String)this.getClass().getSimpleName(), (Map)payload);
        if (properties.isPresent()) {
            CasConfigurationProperties props = (CasConfigurationProperties)properties.get();
            return this.buildAllIdentityProviders(props);
        }
        return List.of();
    }

    protected List<BaseClient> buildClientsBasedPac4jProperties(String result) throws Exception {
        Map clients = (Map)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), Map.class);
        LOGGER.trace("Delegated clients received are [{}]", (Object)clients);
        String callbackUrl = clients.getOrDefault("callbackUrl", null);
        Map properties = clients.getOrDefault("properties", new HashMap(0));
        PropertiesConfigFactory factory = new PropertiesConfigFactory(callbackUrl, properties);
        return factory.build(new Object[0]).getClients().findAllClients().stream().map(IndirectClient.class::cast).collect(Collectors.toList());
    }
}

