/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.widget.dialog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.behavior.DisplayNoneBehavior;
import org.wicketstuff.jquery.ui.widget.dialog.ButtonAjaxBehavior;
import org.wicketstuff.jquery.ui.widget.dialog.DialogBehavior;
import org.wicketstuff.jquery.ui.widget.dialog.DialogButton;
import org.wicketstuff.jquery.ui.widget.dialog.DialogListenerWrapper;
import org.wicketstuff.jquery.ui.widget.dialog.IDialogListener;

public abstract class AbstractDialog<T extends Serializable>
extends GenericPanel<T>
implements IJQueryWidget,
IDialogListener {
    private static final long serialVersionUID = 1L;
    public static final String OK = "OK";
    public static final String NO = "NO";
    public static final String YES = "YES";
    public static final String CLOSE = "CLOSE";
    public static final String CANCEL = "CANCEL";
    public static final String SUBMIT = "SUBMIT";
    public static final IModel<String> LBL_OK = Model.of((Serializable)((Object)"Ok"));
    public static final IModel<String> LBL_NO = Model.of((Serializable)((Object)"No"));
    public static final IModel<String> LBL_YES = Model.of((Serializable)((Object)"Yes"));
    public static final IModel<String> LBL_CLOSE = Model.of((Serializable)((Object)"Close"));
    public static final IModel<String> LBL_CANCEL = Model.of((Serializable)((Object)"Cancel"));
    public static final IModel<String> LBL_SUBMIT = Model.of((Serializable)((Object)"Submit"));
    private static final int WIDTH = 450;
    private IModel<String> title;
    private boolean modal;
    private DialogBehavior widgetBehavior;
    private final DialogButton btnOk = new DialogButton("OK", LBL_OK);

    public AbstractDialog(String id, String title) {
        this(id, title, null, true);
    }

    public AbstractDialog(String id, IModel<String> title) {
        this(id, title, null, true);
    }

    public AbstractDialog(String id, String title, IModel<T> model) {
        this(id, title, model, true);
    }

    public AbstractDialog(String id, IModel<String> title, IModel<T> model) {
        this(id, title, model, true);
    }

    public AbstractDialog(String id, String title, boolean modal) {
        this(id, title, null, modal);
    }

    public AbstractDialog(String id, IModel<String> title, boolean modal) {
        this(id, title, null, modal);
    }

    public AbstractDialog(String id, String title, IModel<T> model, boolean modal) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model, modal);
    }

    public AbstractDialog(String id, IModel<String> title, IModel<T> model, boolean modal) {
        super(id, model);
        this.title = title;
        this.modal = modal;
        this.add(new Behavior[]{new DisplayNoneBehavior()});
        this.setOutputMarkupPlaceholderTag(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.widgetBehavior = (DialogBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this);
        this.add(new Behavior[]{this.widgetBehavior});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("autoOpen", (Object)false);
        behavior.setOption("title", (Object)Options.asString((String)((String)this.title.getObject())));
        behavior.setOption("modal", (Object)this.isModal());
        behavior.setOption("resizable", (Object)this.isResizable());
        behavior.setOption("width", (Object)this.getWidth());
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    protected void onOpen(IPartialPageRequestHandler handler) {
    }

    @Override
    public void onClick(AjaxRequestTarget target, DialogButton button) {
        this.close((IPartialPageRequestHandler)target, button);
    }

    void internalOnClick(AjaxRequestTarget target, DialogButton button) {
        this.onClick(target, button);
    }

    protected void onDetach() {
        super.onDetach();
        this.title.detach();
    }

    protected List<DialogButton> getButtons() {
        return Arrays.asList(this.btnOk);
    }

    public int getWidth() {
        return 450;
    }

    public IModel<String> getTitle() {
        return this.title;
    }

    public void setTitle(IModel<String> title) {
        Args.notNull(title, (String)"title");
        this.title = title;
    }

    public void setTitle(IPartialPageRequestHandler handler, String title) {
        this.setTitle(handler, (IModel<String>)Model.of((Serializable)((Object)title)));
    }

    public void setTitle(IPartialPageRequestHandler handler, IModel<String> title) {
        this.setTitle(title);
        handler.appendJavaScript((CharSequence)this.widgetBehavior.$(new Object[]{Options.asString((String)"option"), Options.asString((String)"title"), Options.asString((String)((String)title.getObject()))}));
    }

    public boolean isModal() {
        return this.modal;
    }

    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean isDefaultCloseEventEnabled() {
        return false;
    }

    @Override
    public boolean isEscapeCloseEventEnabled() {
        return false;
    }

    public DialogButton findButton(String name) {
        for (DialogButton button : this.getButtons()) {
            if (button == null || !button.match(name)) continue;
            return button;
        }
        return null;
    }

    public final void open(IPartialPageRequestHandler handler) {
        this.onOpen(handler);
        if (this.widgetBehavior != null) {
            this.widgetBehavior.open(handler);
        }
    }

    public final void close(IPartialPageRequestHandler handler, DialogButton button) {
        if (this.widgetBehavior != null) {
            this.widgetBehavior.close(handler);
        }
        this.onClose(handler, button);
    }

    public DialogBehavior newWidgetBehavior(String selector) {
        return new DialogBehavior(selector, this.newDialogListenerWrapper()){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<DialogButton> getButtons() {
                return AbstractDialog.this.getButtons();
            }

            @Override
            protected ButtonAjaxBehavior newButtonAjaxBehavior(IJQueryAjaxAware source, DialogButton button) {
                return AbstractDialog.this.newButtonAjaxBehavior(source, button);
            }
        };
    }

    protected final IDialogListener newDialogListenerWrapper() {
        return new DialogListenerWrapper(this){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick(AjaxRequestTarget target, DialogButton button) {
                AbstractDialog.this.internalOnClick(target, button);
            }
        };
    }

    protected ButtonAjaxBehavior newButtonAjaxBehavior(IJQueryAjaxAware source, DialogButton button) {
        return new ButtonAjaxBehavior(source, button);
    }
}

