/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.tirasa.connid.bundles.ldup.LdUpConfiguration;
import net.tirasa.connid.bundles.ldup.LdUpConstants;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.BaseConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObjectReference;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.BindRequest;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.PooledConnectionFactory;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchScope;
import org.ldaptive.SimpleBindRequest;
import org.ldaptive.handler.ResultPredicate;
import org.ldaptive.pool.BindConnectionPassivator;
import org.ldaptive.pool.ConnectionPassivator;

public class LdUpUtils {
    protected static final Log LOG = Log.getLog(LdUpUtils.class);
    protected static final Set<String> ENTRY_DN_ATTRS;
    protected final LdUpConfiguration configuration;
    protected ConnectionConfig connectionConfig;
    protected PooledConnectionFactory connectionFactory;

    public static boolean isDNAttribute(String attrID) {
        return ENTRY_DN_ATTRS.contains(attrID);
    }

    public LdUpUtils(LdUpConfiguration configuration) {
        this.configuration = configuration;
    }

    public LdUpConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionConfig getConnectionConfig() {
        LdUpConfiguration ldUpConfiguration = this.configuration;
        synchronized (ldUpConfiguration) {
            if (this.connectionConfig == null) {
                ConnectionConfig.Builder builder = ConnectionConfig.builder().url(this.configuration.getUrl()).useStartTLS(this.configuration.isUseStartTLS()).autoReconnect(this.configuration.isAutoReconnect()).connectTimeout(Duration.ofSeconds(this.configuration.getConnectTimeoutSeconds())).responseTimeout(Duration.ofSeconds(this.configuration.getResponseTimeoutSeconds()));
                if (StringUtil.isNotBlank((String)this.configuration.getBindDn())) {
                    BindConnectionInitializer.Builder bcib = BindConnectionInitializer.builder().dn(this.configuration.getBindDn());
                    Optional.ofNullable(this.configuration.getBindPassword()).map(SecurityUtil::decrypt).ifPresent(arg_0 -> ((BindConnectionInitializer.Builder)bcib).credential(arg_0));
                    builder.connectionInitializers(new ConnectionInitializer[]{bcib.build()});
                }
                this.connectionConfig = builder.build();
            }
        }
        return this.connectionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnectionFactory getConnectionFactory() {
        LdUpConfiguration ldUpConfiguration = this.configuration;
        synchronized (ldUpConfiguration) {
            if (this.connectionFactory == null) {
                this.connectionFactory = PooledConnectionFactory.builder().config(this.getConnectionConfig()).min(this.configuration.getPoolMinSize()).max(this.configuration.getPoolMaxSize()).validateOnCheckOut(true).validatePeriodically(true).build();
                if (StringUtil.isNotBlank((String)this.configuration.getBindDn())) {
                    SimpleBindRequest.Builder builder = SimpleBindRequest.builder().dn(this.configuration.getBindDn());
                    Optional.ofNullable(this.configuration.getBindPassword()).map(SecurityUtil::decrypt).ifPresent(arg_0 -> ((SimpleBindRequest.Builder)builder).password(arg_0));
                    this.connectionFactory.setPassivator((ConnectionPassivator)new BindConnectionPassivator((BindRequest)builder.build()));
                }
                this.connectionFactory.initialize();
            }
        }
        return this.connectionFactory;
    }

    public boolean isAccount(ObjectClass objectClass) {
        return objectClass.equals((Object)ObjectClass.ACCOUNT) || this.configuration.getAccountObjectClass().equals(objectClass.getObjectClassValue());
    }

    public boolean isGroup(ObjectClass objectClass) {
        return objectClass.equals((Object)ObjectClass.GROUP) || this.configuration.getGroupObjectClass().equals(objectClass.getObjectClassValue());
    }

    public String getIdAttribute(ObjectClass objectClass) {
        if (this.isAccount(objectClass)) {
            return this.configuration.getUidAttribute();
        }
        if (this.isGroup(objectClass)) {
            return this.configuration.getGidAttribute();
        }
        return this.configuration.getAidAttribute();
    }

    public Optional<String> getLdapAttribute(ObjectClass objectClass, String attribute) {
        if (AttributeUtil.namesEqual((String)Uid.NAME, (String)attribute)) {
            return Optional.of(this.getIdAttribute(objectClass));
        }
        if (AttributeUtil.namesEqual((String)Name.NAME, (String)attribute)) {
            return Optional.of("entryDN");
        }
        if (OperationalAttributes.PASSWORD_NAME.equals(attribute)) {
            return Optional.of(this.configuration.getPasswordAttribute());
        }
        if (!AttributeUtil.isSpecialName((String)attribute)) {
            return Optional.of(attribute);
        }
        LOG.warn("Attribute {0} of object class {1} is not mapped to an LDAP attribute", new Object[]{attribute, objectClass.getObjectClassValue()});
        return Optional.empty();
    }

    public String ldapObjectClass(ObjectClass objectClass) {
        return ObjectClass.ACCOUNT.equals((Object)objectClass) ? this.configuration.getAccountObjectClass() : (ObjectClass.GROUP.equals((Object)objectClass) ? this.configuration.getGroupObjectClass() : objectClass.getObjectClassValue());
    }

    public Optional<Set<String>> returnAttributes(OperationOptions options) {
        return Optional.ofNullable(options.getAttributesToGet()).map(attrs -> Stream.of(attrs).filter(attr -> !LdUpConstants.NON_RETURN_ATTRS.contains(attr)).map(attr -> OperationalAttributes.PASSWORD_NAME.equals(attr) ? this.configuration.getPasswordAttribute() : (LdUpConstants.MEMBERS_ATTR_NAME.equals(attr) ? this.configuration.getGroupMemberAttribute() : attr)).collect(Collectors.toSet()));
    }

    protected void copyAttributes(LdapEntry entry, ConnectorObjectBuilder object, Optional<Set<String>> requestedAttributes) {
        HashSet returned = new HashSet();
        entry.getAttributes().forEach(attr -> {
            if (this.configuration.getPasswordAttribute().equals(attr.getName())) {
                object.addAttribute(new Attribute[]{AttributeBuilder.buildPassword((GuardedString)new GuardedString(attr.getStringValue().toCharArray()))});
                returned.add(OperationalAttributes.PASSWORD_NAME);
            } else if (this.configuration.getGroupMemberAttribute().equals(attr.getName())) {
                if (this.configuration.isLegacyCompatibilityMode()) {
                    object.addAttribute(new Attribute[]{AttributeBuilder.build((String)attr.getName(), (Collection)attr.getStringValues())});
                    returned.add(attr.getName());
                } else {
                    Set members = attr.getStringValues().stream().map(dn -> new ConnectorObjectReference((BaseConnectorObject)new ConnectorObjectBuilder().setName(dn).setObjectClass(new ObjectClass(this.configuration.getAccountObjectClass())).buildIdentification())).collect(Collectors.toSet());
                    object.addAttribute(new Attribute[]{AttributeBuilder.build((String)LdUpConstants.MEMBERS_ATTR_NAME, members)});
                    returned.add(LdUpConstants.MEMBERS_ATTR_NAME);
                }
            } else {
                object.addAttribute(new Attribute[]{AttributeBuilder.build((String)attr.getName(), (Collection)(attr.isBinary() ? attr.getBinaryValues() : attr.getStringValues()))});
                returned.add(attr.getName());
            }
        });
        requestedAttributes.ifPresent(requested -> {
            HashSet residual = new HashSet(requested);
            residual.removeAll(returned);
            residual.forEach(r -> object.addAttribute(new Attribute[]{AttributeBuilder.build((String)r, Set.of())}));
        });
    }

    protected void addAccountGroups(ObjectClass objectClass, String userDn, ConnectorObjectBuilder user, OperationOptions options) {
        if (!this.isAccount(objectClass)) {
            return;
        }
        if (Optional.ofNullable(options.getAttributesToGet()).map(attrs -> Stream.of(attrs).noneMatch(attr -> this.configuration.isLegacyCompatibilityMode() ? "ldapGroups".equals(attr) : PredefinedAttributes.GROUPS_NAME.equals(attr))).orElse(false).booleanValue()) {
            return;
        }
        try {
            SearchResponse response = ((SearchOperation)((SearchOperation.Builder)((SearchOperation.Builder)SearchOperation.builder().factory((ConnectionFactory)this.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((SearchRequest)SearchRequest.builder().dn(this.configuration.getBaseDn()).scope(SearchScope.SUBTREE).filter("(&(objectClass=" + this.configuration.getGroupObjectClass() + ")(" + this.configuration.getGroupMemberAttribute() + "=" + userDn + "))").returnAttributes(ReturnAttributes.NONE.value()).build());
            if (this.configuration.isLegacyCompatibilityMode()) {
                user.addAttribute(new Attribute[]{AttributeBuilder.build((String)"ldapGroups", (Collection)response.getEntryDns())});
            } else {
                Set groups = response.getEntries().stream().map(LdapEntry::getDn).map(dn -> new ConnectorObjectReference((BaseConnectorObject)new ConnectorObjectBuilder().setName(dn).setObjectClass(new ObjectClass(this.configuration.getGroupObjectClass())).buildIdentification())).collect(Collectors.toSet());
                user.addAttribute(new Attribute[]{AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, groups)});
            }
        }
        catch (LdapException e) {
            LOG.error((Throwable)e, "While searching groups for {0}", new Object[]{userDn});
        }
    }

    public ConnectorObjectBuilder connectorObjectBuilder(ObjectClass objectClass, Uid uid, LdapEntry entry, OperationOptions options) {
        ConnectorObjectBuilder object = new ConnectorObjectBuilder().setObjectClass(objectClass).setUid(uid).setName(entry.getDn());
        this.copyAttributes(entry, object, this.returnAttributes(options));
        this.addAccountGroups(objectClass, entry.getDn(), object, options);
        return object;
    }

    static {
        SortedSet set = CollectionUtil.newCaseInsensitiveSet();
        set.add("entryDN");
        set.add("dn");
        set.add("distinguishedName");
        ENTRY_DN_ATTRS = Collections.unmodifiableSet(set);
    }
}

