/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.BaseOAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RefreshTokenGrantTypeTokenRequestValidator
extends BaseOAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RefreshTokenGrantTypeTokenRequestValidator.class);

    public OAuth20RefreshTokenGrantTypeTokenRequestValidator(OAuth20ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    protected boolean validateInternal(WebContext context, String grantType, ProfileManager manager, UserProfile uProfile) throws Throwable {
        CallContext callContext = new CallContext(context, this.getConfigurationContext().getSessionStore());
        String clientId = (String)this.getConfigurationContext().getRequestParameterResolver().resolveClientIdAndClientSecret(callContext).getLeft();
        Optional refreshTokenResult = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "refresh_token");
        if (refreshTokenResult.isEmpty() || clientId.isEmpty()) {
            return false;
        }
        OAuth20RefreshToken refreshToken = null;
        String token = (String)refreshTokenResult.get();
        try {
            refreshToken = (OAuth20RefreshToken)this.getConfigurationContext().getTicketRegistry().getTicket(token, OAuth20RefreshToken.class);
            LOGGER.trace("Found valid refresh token [{}] in the registry", (Object)refreshToken);
        }
        catch (InvalidTicketException e) {
            LOGGER.warn("Provided refresh token [{}] cannot be found in the registry or has expired", (Object)token);
            return false;
        }
        LOGGER.debug("Received grant type [{}] with client id [{}]", (Object)grantType, (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), clientId);
        AuditableContext audit = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.getConfigurationContext().getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        if (!this.isGrantTypeSupportedBy(registeredService, grantType)) {
            LOGGER.warn("Requested grant type [{}] is not authorized by service definition [{}]", (Object)grantType, (Object)Objects.requireNonNull(registeredService).getServiceId());
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)refreshToken.getClientId(), (CharSequence)clientId)) {
            LOGGER.warn("Provided refresh token [{}] does not belong to client [{}]", (Object)refreshToken.getId(), (Object)clientId);
            return false;
        }
        return true;
    }

    @Override
    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.REFRESH_TOKEN;
    }
}

