/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.ticket.ServiceTicketGeneratorAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogateServiceTicketGeneratorAuthority
implements ServiceTicketGeneratorAuthority {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateServiceTicketGeneratorAuthority.class);
    private final SurrogateAuthenticationService surrogateAuthenticationService;
    private final AuthenticationServiceSelectionPlan serviceSelectionPlan;
    private final PrincipalResolver principalResolver;

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean supports(AuthenticationResult authenticationResult, Service service) {
        Authentication authentication = authenticationResult.getAuthentication();
        LOGGER.debug("Checking if service ticket generation is allowed for [{}] and [{}]", (Object)authentication, (Object)service);
        return this.findSurrogateCredentialTrait(authentication).isPresent();
    }

    public boolean shouldGenerate(AuthenticationResult authenticationResult, Service service) throws Throwable {
        Authentication authentication = authenticationResult.getAuthentication();
        Optional<Pair<Credential, SurrogateCredentialTrait>> result = this.findSurrogateCredentialTrait(authentication);
        if (result.isPresent()) {
            Pair<Credential, SurrogateCredentialTrait> pair = result.get();
            Service givenService = this.serviceSelectionPlan.resolveService(service);
            Principal principal = this.resolvedPrincipal(((Credential)pair.getKey()).getId());
            String surrogateUser = ((SurrogateCredentialTrait)pair.getRight()).getSurrogateUsername();
            LOGGER.debug("Checking if [{}] can impersonate [{}] for service [{}]", new Object[]{principal, surrogateUser, givenService});
            if (this.surrogateAuthenticationService.canImpersonate(surrogateUser, principal, Optional.ofNullable(givenService))) {
                return true;
            }
            LOGGER.warn("Impersonation is not allowed for [{}]", (Object)surrogateUser);
            throw new SurrogateAuthenticationException("Impersonating %s is not allowed".formatted(surrogateUser));
        }
        return true;
    }

    protected Optional<Pair<Credential, SurrogateCredentialTrait>> findSurrogateCredentialTrait(Authentication authentication) {
        return authentication.getCredentials().stream().filter(Objects::nonNull).filter(credential -> Objects.nonNull(credential.getCredentialMetadata())).filter(credential -> credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).isPresent()).map(credential -> {
            SurrogateCredentialTrait credentialTrait = (SurrogateCredentialTrait)credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).orElseThrow();
            return Pair.of((Object)credential, (Object)credentialTrait);
        }).findFirst();
    }

    protected Principal resolvedPrincipal(String username) throws Throwable {
        Principal resolvedPrincipal = this.principalResolver.resolve((Credential)new BasicIdentifiableCredential(username));
        return resolvedPrincipal instanceof NullPrincipal ? PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(username) : resolvedPrincipal;
    }

    @Generated
    public SurrogateServiceTicketGeneratorAuthority(SurrogateAuthenticationService surrogateAuthenticationService, AuthenticationServiceSelectionPlan serviceSelectionPlan, PrincipalResolver principalResolver) {
        this.surrogateAuthenticationService = surrogateAuthenticationService;
        this.serviceSelectionPlan = serviceSelectionPlan;
        this.principalResolver = principalResolver;
    }
}

