/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import jakarta.annotation.Nullable;
import java.util.function.Predicate;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisteredServiceAccessStrategyUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceAccessStrategyUtils.class);

    public static void ensureServiceAccessIsAllowed(RegisteredService registeredService) {
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(null, registeredService);
    }

    public static void ensureServiceAccessIsAllowed(@Nullable Service service, @Nullable RegisteredService registeredService) {
        String id;
        String string = id = service != null ? service.getId() : "unknown";
        if (registeredService == null) {
            LOGGER.warn("Unauthorized Service Access. Service [{}] is not registered in the service registry. Review the service access strategy to evaluate policies required for service access", (Object)id);
            throw UnauthorizedServiceException.denied((String)("Service " + id + " is not found or is disabled in the service registry."));
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed(registeredService, service)) {
            String msg = String.format("Unauthorized Service Access. Service [%s] is not enabled in service registry. You should review the service access strategy to evaluate the conditions and policies required for service access.", id);
            throw UnauthorizedServiceException.denied((String)msg);
        }
        if (!RegisteredServiceAccessStrategyUtils.ensureServiceIsNotExpired(registeredService)) {
            String msg = String.format("Expired service access is denied. Service [%s] has been expired", id);
            throw UnauthorizedServiceException.expired((String)msg);
        }
    }

    public static boolean ensureServiceIsNotExpired(RegisteredService registeredService) {
        return RegisteredServiceAccessStrategyUtils.getRegisteredServiceExpirationPolicyPredicate().test(registeredService);
    }

    public static void ensureServiceSsoAccessIsAllowed(RegisteredService registeredService, Service service, TicketGrantingTicket ticketGrantingTicket) {
        RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed(registeredService, service, ticketGrantingTicket, false);
    }

    public static void ensureServiceSsoAccessIsAllowed(RegisteredService registeredService, Service service, TicketGrantingTicket ticketGrantingTicket, boolean credentialsProvided) {
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowedForSso(registeredService)) {
            LOGGER.debug("Service [{}] is configured to not use SSO", (Object)service.getId());
            if (ticketGrantingTicket.getProxiedBy() != null) {
                LOGGER.warn("Service [{}] is not allowed to use SSO for proxying.", (Object)service.getId());
            }
            if (ticketGrantingTicket.getCountOfUses() > 0 && !credentialsProvided) {
                LOGGER.warn("Service [{}] is not allowed to use SSO. The ticket-granting ticket [{}] is not proxied and it's been used at least once. The authentication request must provide credentials before access can be granted", (Object)ticketGrantingTicket.getId(), (Object)service.getId());
            }
            if (ticketGrantingTicket.getCountOfUses() == 0 && credentialsProvided) {
                LOGGER.debug("The ticket-granting ticket [{}] has never been used before and the authentication request has supplied credentials to access service [{}]", (Object)ticketGrantingTicket.getId(), (Object)service.getId());
            } else if (!credentialsProvided) {
                throw new UnauthorizedSsoServiceException();
            }
        }
        LOGGER.debug("Current authentication via ticket [{}] allows service [{}] to participate in the existing SSO session", (Object)ticketGrantingTicket.getId(), (Object)service.getId());
    }

    public static Predicate<RegisteredService> getRegisteredServiceExpirationPolicyPredicate() {
        return service -> {
            if (service == null) {
                return false;
            }
            RegisteredServiceExpirationPolicy policy = service.getExpirationPolicy();
            return policy == null || !policy.isExpired();
        };
    }

    @Generated
    private RegisteredServiceAccessStrategyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

